/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.link;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.Arrays;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.link.ActionPlanFrame;
import org.openjdk.jmh.runner.link.ClassConventions;
import org.openjdk.jmh.runner.link.ExceptionFrame;
import org.openjdk.jmh.runner.link.FinishingFrame;
import org.openjdk.jmh.runner.link.InfraFrame;
import org.openjdk.jmh.runner.link.OptionsFrame;
import org.openjdk.jmh.runner.link.OutputFormatFrame;
import org.openjdk.jmh.runner.link.OutputFrame;
import org.openjdk.jmh.runner.link.ResultsFrame;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.Multimap;

public final class BinaryLinkClient {
    private final Socket clientSocket;
    private final ObjectOutputStream oos;
    private final ObjectInputStream ois;
    private ForwardingPrintStream streamErr;
    private ForwardingPrintStream streamOut;

    public BinaryLinkClient(String hostName, int hostPort) throws IOException {
        this.clientSocket = new Socket(hostName, hostPort);
        this.oos = new ObjectOutputStream(this.clientSocket.getOutputStream());
        this.ois = new ObjectInputStream(this.clientSocket.getInputStream());
        this.streamErr = new ForwardingPrintStream(OutputFrame.Type.ERR);
        this.streamOut = new ForwardingPrintStream(OutputFrame.Type.OUT);
    }

    public Options requestOptions() throws IOException, ClassNotFoundException {
        this.oos.writeObject(new InfraFrame(InfraFrame.Type.OPTIONS_REQUEST));
        Object reply = this.ois.readObject();
        if (reply instanceof OptionsFrame) {
            return ((OptionsFrame)reply).getOpts();
        }
        throw new IllegalStateException("Got the erroneous reply: " + reply);
    }

    public InvocationHandler getOutputFormatHandler() {
        return new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BinaryLinkClient.this.oos.writeObject(new OutputFormatFrame(ClassConventions.getMethodName(method), args));
                BinaryLinkClient.this.oos.flush();
                return null;
            }
        };
    }

    public void close() throws IOException {
        this.oos.writeObject(new FinishingFrame());
        this.oos.flush();
        this.oos.close();
        this.streamErr.flush();
        this.streamErr.close();
        this.streamOut.flush();
        this.streamOut.close();
        this.clientSocket.close();
    }

    public void pushResults(Multimap<BenchmarkParams, BenchmarkResult> res) throws IOException {
        this.oos.writeObject(new ResultsFrame(res));
        this.oos.flush();
    }

    public ActionPlan requestPlan() throws IOException, ClassNotFoundException {
        this.oos.writeObject(new InfraFrame(InfraFrame.Type.ACTION_PLAN_REQUEST));
        this.oos.flush();
        Object reply = this.ois.readObject();
        if (reply instanceof ActionPlanFrame) {
            return ((ActionPlanFrame)reply).getActionPlan();
        }
        throw new IllegalStateException("Got the erroneous reply: " + reply);
    }

    public void pushException(BenchmarkException error) throws IOException {
        this.oos.writeObject(new ExceptionFrame(error));
        this.oos.flush();
    }

    public PrintStream getErrStream() {
        return this.streamErr;
    }

    public PrintStream getOutStream() {
        return this.streamOut;
    }

    public OutputFormat getOutputFormatHook() {
        return (OutputFormat)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{OutputFormat.class}, this.getOutputFormatHandler());
    }

    class ForwardingPrintStream
    extends PrintStream {
        public ForwardingPrintStream(final OutputFrame.Type type) {
            super(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    BinaryLinkClient.this.oos.writeObject(new OutputFrame(type, new byte[]{(byte)(b & 0xFF)}));
                    BinaryLinkClient.this.oos.flush();
                }

                @Override
                public void write(byte[] b) throws IOException {
                    BinaryLinkClient.this.oos.writeObject(new OutputFrame(type, Arrays.copyOf(b, b.length)));
                    BinaryLinkClient.this.oos.flush();
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    BinaryLinkClient.this.oos.writeObject(new OutputFrame(type, Arrays.copyOfRange(b, off, len + off)));
                    BinaryLinkClient.this.oos.flush();
                }
            });
        }
    }
}

