/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.runner.InfraControlL4;
import org.openjdk.jmh.util.Utils;

public class InfraControl
extends InfraControlL4 {
    public InfraControl(BenchmarkParams benchmarkParams, IterationParams iterationParams, CountDownLatch preSetup, CountDownLatch preTearDown, boolean lastIteration) {
        super(benchmarkParams, iterationParams, preSetup, preTearDown, lastIteration);
    }

    public long getDuration() {
        return this.getDuration(TimeUnit.MILLISECONDS);
    }

    public long getDuration(TimeUnit unit) {
        return this.iterationParams.getTime().convertTo(unit);
    }

    public void preSetup() {
        try {
            this.preSetup.countDown();
            this.preSetup.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void preTearDown() throws InterruptedException {
        this.preTearDown.countDown();
        this.preTearDown.await();
    }

    public void preSetupForce() {
        this.preSetup.countDown();
    }

    public void preTearDownForce() {
        this.preTearDown.countDown();
    }

    public boolean isLastIteration() {
        return this.lastIteration;
    }

    static {
        Utils.check(InfraControl.class, "isDone");
        Utils.check(InfraControl.class, "volatileSpoiler");
        Utils.check(InfraControl.class, "preSetup", "preTearDown");
        Utils.check(InfraControl.class, "lastIteration");
        Utils.check(InfraControl.class, "warmupVisited", "warmdownVisited");
        Utils.check(InfraControl.class, "warmupShouldWait", "warmdownShouldWait");
        Utils.check(InfraControl.class, "benchmarkParams", "iterationParams");
        Utils.check(InfraControl.class, "shouldSynchIterations", "threads");
    }
}

