/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.runner.Action;
import org.openjdk.jmh.runner.ActionMode;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.BenchmarkHandler;
import org.openjdk.jmh.runner.BenchmarkHandlers;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.ClassUtils;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.TreeMultimap;

abstract class BaseRunner {
    private long projectedTotalTime;
    private long projectedRunningTime;
    private long actualRunningTime;
    private long benchmarkStart;
    protected final Options options;
    protected final OutputFormat out;

    public BaseRunner(Options options, OutputFormat handler) {
        if (options == null) {
            throw new IllegalArgumentException("Options is null.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler is null.");
        }
        this.options = options;
        this.out = handler;
    }

    protected Multimap<BenchmarkParams, BenchmarkResult> runBenchmarks(boolean forked, ActionPlan actionPlan) {
        TreeMultimap<BenchmarkParams, BenchmarkResult> results = new TreeMultimap<BenchmarkParams, BenchmarkResult>();
        for (Action action : actionPlan.getActions()) {
            BenchmarkResult r;
            BenchmarkParams params;
            block8: {
                params = action.getParams();
                ActionMode mode = action.getMode();
                if (!forked) {
                    this.beforeBenchmark();
                    this.out.startBenchmark(params);
                    this.out.println("# Fork: N/A, test runs in the existing VM");
                }
                r = null;
                try {
                    switch (mode) {
                        case WARMUP: {
                            this.runBenchmark(params);
                            this.out.println("");
                            break;
                        }
                        case WARMUP_MEASUREMENT: 
                        case MEASUREMENT: {
                            r = this.runBenchmark(params);
                            results.put(params, r);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown mode: " + (Object)((Object)mode));
                        }
                    }
                }
                catch (BenchmarkException be) {
                    this.out.println("<failure>");
                    this.out.println("");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    be.getCause().printStackTrace(pw);
                    pw.close();
                    this.out.println(sw.toString());
                    this.out.println("");
                    if (!this.options.shouldFailOnError().orElse(false).booleanValue()) break block8;
                    throw be;
                }
            }
            if (forked) continue;
            this.afterBenchmark(params);
            this.out.endBenchmark(r);
        }
        return results;
    }

    protected void afterBenchmark(BenchmarkParams params) {
        long current = System.nanoTime();
        this.projectedRunningTime += this.estimateTimeSingleFork(params);
        this.actualRunningTime += current - this.benchmarkStart;
        this.benchmarkStart = current;
    }

    protected void beforeBenchmarks(Collection<ActionPlan> plans) {
        this.projectedTotalTime = 0L;
        for (ActionPlan plan : plans) {
            for (Action act : plan.getActions()) {
                BenchmarkParams params = act.getParams();
                this.projectedTotalTime += (long)(Math.max(1, params.getForks()) + params.getWarmupForks()) * this.estimateTimeSingleFork(params);
            }
        }
    }

    private long estimateTimeSingleFork(BenchmarkParams params) {
        IterationParams wp = params.getWarmup();
        IterationParams mp = params.getMeasurement();
        long estimatedTime = params.getMode() == Mode.SingleShotTime ? (long)(wp.getCount() + mp.getCount()) * TimeUnit.MILLISECONDS.toNanos(1L) : (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.NANOSECONDS) + (long)mp.getCount() * mp.getTime().convertTo(TimeUnit.NANOSECONDS);
        return estimatedTime;
    }

    protected void beforeBenchmark() {
        double partsDone;
        if (this.benchmarkStart == 0L) {
            this.benchmarkStart = System.nanoTime();
        }
        long totalETA = (partsDone = 1.0 * (double)this.projectedRunningTime / (double)this.projectedTotalTime) != 0.0 ? (long)((double)this.actualRunningTime * (1.0 / partsDone - 1.0)) : this.projectedTotalTime;
        this.out.println(String.format("# Run progress: %.2f%% complete, ETA %s", partsDone * 100.0, this.formatDuration(totalETA)));
    }

    protected void afterBenchmarks() {
        this.out.println(String.format("# Run complete. Total time: %s", this.formatDuration(this.actualRunningTime)));
        this.out.println("");
    }

    private String formatDuration(long nanos) {
        long days = TimeUnit.NANOSECONDS.toDays(nanos);
        long hrs = TimeUnit.NANOSECONDS.toHours(nanos -= days * TimeUnit.DAYS.toNanos(1L));
        long mins = TimeUnit.NANOSECONDS.toMinutes(nanos -= hrs * TimeUnit.HOURS.toNanos(1L));
        long secs = TimeUnit.NANOSECONDS.toSeconds(nanos -= mins * TimeUnit.MINUTES.toNanos(1L));
        return String.format("%s%02d:%02d:%02d", days > 0L ? days + "days, " : "", hrs, mins, secs);
    }

    BenchmarkResult runBenchmark(BenchmarkParams benchParams) {
        BenchmarkHandler handler = null;
        try {
            String target = benchParams.generatedBenchmark();
            int lastDot = target.lastIndexOf(46);
            Class<?> clazz = ClassUtils.loadClass(target.substring(0, lastDot));
            Method method = BenchmarkHandlers.findBenchmarkMethod(clazz, target.substring(lastDot + 1));
            handler = BenchmarkHandlers.getInstance(this.out, clazz, method, benchParams, this.options);
            BenchmarkResult benchmarkResult = this.runBenchmark(benchParams, handler);
            return benchmarkResult;
        }
        catch (BenchmarkException be) {
            throw be;
        }
        catch (Throwable ex) {
            throw new BenchmarkException(ex);
        }
        finally {
            if (handler != null) {
                handler.shutdown();
            }
        }
    }

    protected BenchmarkResult runBenchmark(BenchmarkParams benchParams, BenchmarkHandler handler) {
        ArrayList<IterationResult> allResults = new ArrayList<IterationResult>();
        IterationParams wp = benchParams.getWarmup();
        for (int i = 1; i <= wp.getCount(); ++i) {
            if (this.runSystemGC()) {
                this.out.verbosePrintln("System.gc() executed");
            }
            this.out.iteration(benchParams, wp, i);
            boolean isLastIteration = benchParams.getMeasurement().getCount() == 0;
            IterationResult iterData = handler.runIteration(benchParams, wp, isLastIteration);
            this.out.iterationResult(benchParams, wp, i, iterData);
        }
        IterationParams mp = benchParams.getMeasurement();
        for (int i = 1; i <= mp.getCount(); ++i) {
            if (this.runSystemGC()) {
                this.out.verbosePrintln("System.gc() executed");
            }
            this.out.iteration(benchParams, mp, i);
            boolean isLastIteration = i == mp.getCount();
            IterationResult iterData = handler.runIteration(benchParams, mp, isLastIteration);
            this.out.iterationResult(benchParams, mp, i, iterData);
            allResults.add(iterData);
        }
        if (!allResults.isEmpty()) {
            return new BenchmarkResult(allResults);
        }
        return null;
    }

    public boolean runSystemGC() {
        if (this.options.shouldDoGC().orElse(false).booleanValue()) {
            ArrayList<GarbageCollectorMXBean> enabledBeans = new ArrayList<GarbageCollectorMXBean>();
            long beforeGcCount = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = bean.getCollectionCount();
                if (count == -1L) continue;
                enabledBeans.add(bean);
            }
            for (GarbageCollectorMXBean bean : enabledBeans) {
                beforeGcCount += bean.getCollectionCount();
            }
            System.gc();
            int MAX_WAIT_MSEC = 20000;
            if (enabledBeans.isEmpty()) {
                this.out.println("WARNING: MXBeans can not report GC info. System.gc() invoked, pessimistically waiting 20000 msecs");
                try {
                    TimeUnit.MILLISECONDS.sleep(20000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            long start = System.nanoTime();
            while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) < 20000L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                long afterGcCount = 0L;
                for (GarbageCollectorMXBean bean : enabledBeans) {
                    afterGcCount += bean.getCollectionCount();
                }
                if (afterGcCount <= beforeGcCount) continue;
                return true;
            }
            this.out.println("WARNING: System.gc() was invoked but couldn't detect a GC occuring, is System.gc() disabled?");
            return false;
        }
        return false;
    }
}

