/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

class AbstractResourceReader {
    private final String file;
    private final String resource;
    private final String line;

    protected AbstractResourceReader(String file, String resource, String line) {
        this.file = file;
        this.resource = resource;
        this.line = line;
    }

    protected List<Reader> getReaders() {
        if (this.file != null) {
            try {
                return Collections.singletonList(new FileReader(this.file));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("ERROR: Could not find resource", e);
            }
        }
        if (this.resource != null) {
            Enumeration<URL> urls;
            try {
                urls = this.getClass().getClassLoader().getResources(this.resource.startsWith("/") ? this.resource.substring(1) : this.resource);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while obtaining resource: " + this.resource, e);
            }
            if (urls != null) {
                ArrayList<Reader> readers = new ArrayList<Reader>();
                URL url = null;
                try {
                    while (urls.hasMoreElements()) {
                        url = urls.nextElement();
                        InputStream stream = url.openStream();
                        readers.add(new InputStreamReader(stream));
                    }
                }
                catch (IOException e) {
                    for (Reader r : readers) {
                        try {
                            r.close();
                        }
                        catch (IOException e1) {}
                    }
                    throw new RuntimeException("IOException while opening resource: " + url, e);
                }
                return readers;
            }
            throw new RuntimeException("Unable to find the resource");
        }
        if (this.line != null) {
            return Collections.singletonList(new StringReader(this.line));
        }
        throw new IllegalStateException();
    }
}

