/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;
import org.openjdk.jmh.util.ClassUtils;

class TextResultFormat
implements ResultFormat {
    private final PrintWriter out;

    public TextResultFormat(PrintWriter writer) {
        this.out = writer;
    }

    @Override
    public void writeOut(Collection<RunResult> runResults) {
        ArrayList<String> benchNames = new ArrayList<String>();
        for (RunResult runResult : runResults) {
            benchNames.add(runResult.getParams().getBenchmark());
            for (String label : runResult.getSecondaryResults().keySet()) {
                benchNames.add(runResult.getParams().getBenchmark() + ":" + label);
            }
        }
        Map<String, String> benchPrefixes = ClassUtils.denseClassNames(benchNames);
        int nameLen = 1;
        for (String prefix : benchPrefixes.values()) {
            nameLen = Math.max(nameLen, prefix.length());
        }
        nameLen += 2;
        HashMap<String, Integer> paramLengths = new HashMap<String, Integer>();
        TreeSet<String> params = new TreeSet<String>();
        for (RunResult runResult : runResults) {
            BenchmarkParams bp = runResult.getParams();
            for (String k : bp.getParamsKeys()) {
                params.add(k);
                Integer len = (Integer)paramLengths.get(k);
                if (len == null) {
                    len = ("(" + k + ")").length();
                }
                paramLengths.put(k, Math.max(len, bp.getParam(k).length()));
            }
        }
        this.out.print(String.format("%-" + nameLen + "s ", "Benchmark"));
        for (String k : params) {
            this.out.print(String.format("%" + paramLengths.get(k) + "s ", "(" + k + ")"));
        }
        this.out.print(String.format("%6s %9s %12s %12s %8s%n", "Mode", "Samples", "Score", "Score error", "Units"));
        for (RunResult res : runResults) {
            this.out.print(String.format("%-" + nameLen + "s ", benchPrefixes.get(res.getParams().getBenchmark())));
            for (String k : params) {
                String v = res.getParams().getParam(k);
                this.out.print(String.format("%" + paramLengths.get(k) + "s ", v == null ? "N/A" : v));
            }
            this.out.print(String.format("%6s %9d %12.3f %12.3f %8s%n", res.getParams().getMode().shortLabel(), res.getPrimaryResult().getSampleCount(), res.getPrimaryResult().getScore(), res.getPrimaryResult().getScoreError(), res.getScoreUnit()));
            for (String label : res.getSecondaryResults().keySet()) {
                Result subRes = res.getSecondaryResults().get(label);
                this.out.print(String.format("%-" + nameLen + "s ", benchPrefixes.get(res.getParams().getBenchmark() + ":" + label)));
                for (String k : params) {
                    String v = res.getParams().getParam(k);
                    this.out.print(String.format("%" + paramLengths.get(k) + "s ", v == null ? "N/A" : v));
                }
                this.out.print(String.format("%6s %9d %12.3f %12.3f %8s%n", res.getParams().getMode().shortLabel(), subRes.getSampleCount(), subRes.getScore(), subRes.getScoreError(), subRes.getScoreUnit()));
            }
        }
    }
}

