/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import org.openjdk.jmh.profile.ProfilerResultAggregator;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.Statistics;

public class ProfilerResult
extends Result<ProfilerResult> {
    public ProfilerResult(String label, double n, String unit, AggregationPolicy policy) {
        this(label, ProfilerResult.of(n), unit, policy);
    }

    ProfilerResult(String label, Statistics s, String unit, AggregationPolicy policy) {
        super(ResultRole.SECONDARY, label, s, unit, policy);
    }

    @Override
    protected Aggregator<ProfilerResult> getThreadAggregator() {
        return new ProfilerResultAggregator();
    }

    @Override
    protected Aggregator<ProfilerResult> getIterationAggregator() {
        return new ProfilerResultAggregator();
    }

    @Override
    public String extendedInfo(String label) {
        switch (this.policy) {
            case AVG: {
                return String.format("Result %30s: %.3f \u00b1(99.9%%) %.3f %s", "\"" + label + "\"", this.getScore(), this.getScoreError(), this.getScoreUnit());
            }
            case MAX: 
            case SUM: {
                return String.format("Result %30s: %.3f %s [%s]", new Object[]{"\"" + label + "\"", this.getScore(), this.getScoreUnit(), this.policy});
            }
        }
        throw new IllegalStateException("Unknown policy: " + (Object)((Object)this.policy));
    }
}

