/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Generated;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Group;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.generators.core.BenchmarkGeneratorUtils;
import org.openjdk.jmh.generators.core.BenchmarkInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.CompilerControlPlugin;
import org.openjdk.jmh.generators.core.FieldInfo;
import org.openjdk.jmh.generators.core.GenerationException;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.MethodGroup;
import org.openjdk.jmh.generators.core.MethodInfo;
import org.openjdk.jmh.generators.core.ParameterInfo;
import org.openjdk.jmh.generators.core.StateObject;
import org.openjdk.jmh.generators.core.StateObjectHandler;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.results.AverageTimeResult;
import org.openjdk.jmh.results.RawResults;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.results.SampleTimeResult;
import org.openjdk.jmh.results.SingleShotResult;
import org.openjdk.jmh.results.ThroughputResult;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.Defaults;
import org.openjdk.jmh.runner.InfraControl;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.SampleBuffer;

public class BenchmarkGenerator {
    private final Set<BenchmarkInfo> benchmarkInfos = new HashSet<BenchmarkInfo>();
    private final CompilerControlPlugin compilerControl;
    private final Set<String> processedBenchmarks = new HashSet<String>();

    public BenchmarkGenerator() {
        this.compilerControl = new CompilerControlPlugin();
    }

    public void generate(GeneratorSource source, GeneratorDestination destination) {
        try {
            Multimap<ClassInfo, MethodInfo> clazzes = this.buildAnnotatedSet(source);
            for (ClassInfo clazz : clazzes.keys()) {
                if (!this.processedBenchmarks.add(clazz.getQualifiedName())) continue;
                try {
                    this.validateBenchmark(clazz, clazzes.get(clazz));
                    Collection<BenchmarkInfo> infos = this.makeBenchmarkInfo(clazz, clazzes.get(clazz));
                    for (BenchmarkInfo info : infos) {
                        this.generateClass(source, destination, clazz, info);
                    }
                    this.benchmarkInfos.addAll(infos);
                }
                catch (GenerationException ge) {
                    destination.printError(ge.getMessage(), ge.getElement());
                }
            }
            this.compilerControl.process(source, destination);
        }
        catch (Throwable t) {
            destination.printError("Annotation generator had thrown the exception.", t);
        }
    }

    public void complete(GeneratorSource source, GeneratorDestination destination) {
        this.compilerControl.finish(source, destination);
        try {
            PrintWriter writer = new PrintWriter(destination.newResource("/META-INF/BenchmarkList".substring(1)));
            for (BenchmarkInfo info : this.benchmarkInfos) {
                MethodGroup group = info.methodGroup;
                String method = group.getName();
                for (Mode m : group.getModes()) {
                    BenchmarkListEntry br = new BenchmarkListEntry(info.userName + "." + method, info.generatedName + "." + method, m, group.getThreads(), group.getTotalThreadCount(), group.getWarmupIterations(), group.getWarmupTime(), group.getWarmupBatchSize(), group.getMeasurementIterations(), group.getMeasurementTime(), group.getMeasurementBatchSize(), group.getForks(), group.getWarmupForks(), group.getJvmArgs(), group.getJvmArgsPrepend(), group.getJvmArgsAppend(), group.getParams(), group.getOutputTimeUnit(), group.getOperationsPerInvocation());
                    writer.println(br.toLine());
                }
            }
            writer.close();
        }
        catch (IOException ex) {
            destination.printError("Error writing benchmark list", ex);
        }
    }

    private Multimap<ClassInfo, MethodInfo> buildAnnotatedSet(GeneratorSource source) {
        HashMultimap<ClassInfo, MethodInfo> result = new HashMultimap<ClassInfo, MethodInfo>();
        Iterator<ClassInfo> i$ = source.getClasses().iterator();
        while (i$.hasNext()) {
            ClassInfo currentClass;
            ClassInfo walk = currentClass = i$.next();
            do {
                if (currentClass.getQualifiedName().contains("generated") || currentClass.isAbstract()) continue;
                for (MethodInfo mi : walk.getMethods()) {
                    Benchmark ann = mi.getAnnotation(Benchmark.class);
                    if (ann == null) continue;
                    result.put(currentClass, mi);
                }
            } while ((walk = walk.getSuperClass()) != null);
        }
        return result;
    }

    private void validateBenchmark(ClassInfo clazz, Collection<MethodInfo> methods) {
        if (clazz.getPackageName().isEmpty()) {
            throw new GenerationException("Benchmark class should have package other than default.", clazz);
        }
        if (clazz.isFinal()) {
            throw new GenerationException("Benchmark classes should not be final.", clazz);
        }
        ArrayList<ClassInfo> states = new ArrayList<ClassInfo>();
        for (MethodInfo e : methods) {
            for (ParameterInfo var : e.getParameters()) {
                if (BenchmarkGeneratorUtils.getAnnSuper(var.getType(), State.class) == null) {
                    throw new GenerationException("Method parameters should be @" + State.class.getSimpleName() + " classes.", e);
                }
                states.add(var.getType());
            }
        }
        if (BenchmarkGeneratorUtils.getAnnSuper(clazz, State.class) != null) {
            states.add(clazz);
        }
        for (ClassInfo state : states) {
            try {
                BenchmarkGeneratorUtils.getAnnSuper(state, State.class).value();
            }
            catch (IncompleteAnnotationException iae) {
                throw new GenerationException("The " + State.class.getSimpleName() + " annotation should have the explicit " + Scope.class.getSimpleName() + " argument", state);
            }
            if (!state.isPublic()) {
                throw new GenerationException("The " + State.class.getSimpleName() + " annotation only supports public classes.", state);
            }
            if (state.isFinal()) {
                throw new GenerationException("The " + State.class.getSimpleName() + " annotation does not support final classes.", state);
            }
            if (state.isInner()) {
                throw new GenerationException("The " + State.class.getSimpleName() + " annotation does not support inner classes, make sure your class is static.", state);
            }
            if (state.isAbstract()) {
                throw new GenerationException("The " + State.class.getSimpleName() + " annotation does not support abstract classes.", state);
            }
            boolean hasDefaultConstructor = false;
            for (MethodInfo constructor : state.getConstructors()) {
                hasDefaultConstructor |= constructor.getParameters().isEmpty() && constructor.isPublic();
            }
            hasDefaultConstructor |= state.getQualifiedName().equals(BenchmarkParams.class.getCanonicalName());
            hasDefaultConstructor |= state.getQualifiedName().equals(IterationParams.class.getCanonicalName());
            if (hasDefaultConstructor |= state.getQualifiedName().equals(ThreadParams.class.getCanonicalName())) continue;
            throw new GenerationException("The " + State.class.getSimpleName() + " annotation can only be applied to the classes having the default public constructor.", state);
        }
        if (BenchmarkGeneratorUtils.getAnnSuper(clazz, State.class) == null || clazz.isAbstract()) {
            for (FieldInfo fi : BenchmarkGeneratorUtils.getAllFields(clazz)) {
                if (fi.isStatic()) continue;
                throw new GenerationException("Field \"" + fi.getName() + "\" is declared within " + "the class not having @" + State.class.getSimpleName() + " annotation. " + "This can result in unspecified behavior, and prohibited.", fi);
            }
        }
        BenchmarkGeneratorUtils.checkAnnotations(clazz);
        for (ClassInfo state : states) {
            BenchmarkGeneratorUtils.checkAnnotations(state);
        }
        for (FieldInfo fi : BenchmarkGeneratorUtils.getAllFields(clazz)) {
            BenchmarkGeneratorUtils.checkAnnotations(fi);
        }
        for (ClassInfo state : states) {
            for (FieldInfo fi : BenchmarkGeneratorUtils.getAllFields(state)) {
                BenchmarkGeneratorUtils.checkAnnotations(fi);
            }
        }
        for (MethodInfo mi : methods) {
            BenchmarkGeneratorUtils.checkAnnotations(mi);
        }
        for (ClassInfo state : states) {
            for (MethodInfo mi : BenchmarkGeneratorUtils.getMethods(state)) {
                BenchmarkGeneratorUtils.checkAnnotations(mi);
            }
        }
        for (MethodInfo m : methods) {
            if (!m.isPublic()) {
                throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method should be public.", m);
            }
            if (m.isAbstract()) {
                throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method can not be abstract.", m);
            }
            if (!m.isSynchronized()) continue;
            State annState = BenchmarkGeneratorUtils.getAnnSuper(m, State.class);
            if (annState == null) {
                throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method can only be synchronized if the enclosing class is annotated with " + "@" + State.class.getSimpleName() + ".", m);
            }
            if (!m.isStatic() || annState.value() == Scope.Benchmark) continue;
            throw new GenerationException("@" + Benchmark.class.getSimpleName() + " method can only be static and synchronized if the enclosing class is annotated with " + "@" + State.class.getSimpleName() + "(" + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Benchmark) + ").", m);
        }
        for (MethodInfo m : methods) {
            OperationsPerInvocation opi = BenchmarkGeneratorUtils.getAnnSuper(m, clazz, OperationsPerInvocation.class);
            if (opi == null || opi.value() >= 1) continue;
            throw new GenerationException("The " + OperationsPerInvocation.class.getSimpleName() + " needs to be greater than 0.", m);
        }
        for (MethodInfo m : methods) {
            if (m.getAnnotation(Group.class) == null || m.getAnnotation(Threads.class) == null) continue;
            throw new GenerationException("@" + Threads.class.getSimpleName() + " annotation is placed within " + "the benchmark method with @" + Group.class.getSimpleName() + " annotation. " + "This has ambiguous behavioral effect, and prohibited. " + "Did you mean @" + GroupThreads.class.getSimpleName() + " instead?", m);
        }
    }

    private void validateBenchmarkInfo(BenchmarkInfo info) {
        MethodGroup group = info.methodGroup;
        if (group.methods().size() == 1) {
            MethodInfo meth = group.methods().iterator().next();
            if (meth.getAnnotation(Group.class) == null) {
                for (ParameterInfo param : meth.getParameters()) {
                    State stateAnn = BenchmarkGeneratorUtils.getAnnSuper(param.getType(), State.class);
                    if (stateAnn == null || stateAnn.value() != Scope.Group) continue;
                    throw new GenerationException("Only @" + Group.class.getSimpleName() + " methods can reference @" + State.class.getSimpleName() + "(" + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Group) + ") states.", meth);
                }
                State stateAnn = BenchmarkGeneratorUtils.getAnnSuper(meth.getDeclaringClass(), State.class);
                if (stateAnn != null && stateAnn.value() == Scope.Group) {
                    throw new GenerationException("Only @" + Group.class.getSimpleName() + " methods can implicitly reference @" + State.class.getSimpleName() + "(" + Scope.class.getSimpleName() + "." + (Object)((Object)Scope.Group) + ") states.", meth);
                }
            }
        } else {
            for (MethodInfo m : group.methods()) {
                if (m.getAnnotation(Group.class) != null) continue;
                throw new GenerationException("Internal error: multiple methods per @" + Group.class.getSimpleName() + ", but not all methods have @" + Group.class.getSimpleName(), m);
            }
        }
    }

    private Collection<BenchmarkInfo> makeBenchmarkInfo(ClassInfo clazz, Collection<MethodInfo> methods) {
        TreeMap<String, MethodGroup> result = new TreeMap<String, MethodGroup>();
        for (MethodInfo method : methods) {
            BenchmarkMode mbAn;
            String groupName;
            Group groupAnn = method.getAnnotation(Group.class);
            String string = groupName = groupAnn != null ? groupAnn.value() : method.getName();
            if (!BenchmarkGeneratorUtils.checkJavaIdentifier(groupName)) {
                throw new GenerationException("Group name should be the legal Java identifier.", method);
            }
            MethodGroup group = (MethodGroup)result.get(groupName);
            if (group == null) {
                group = new MethodGroup(clazz, groupName);
                result.put(groupName, group);
            }
            if ((mbAn = BenchmarkGeneratorUtils.getAnnSuper(method, clazz, BenchmarkMode.class)) != null) {
                group.addModes(mbAn.value());
            }
            group.addStrictFP(clazz.isStrictFP());
            group.addStrictFP(method.isStrictFP());
            group.addMethod(method, method.getAnnotation(GroupThreads.class) != null ? method.getAnnotation(GroupThreads.class).value() : 1);
            for (ParameterInfo pi : method.getParameters()) {
                BenchmarkGeneratorUtils.addParameterValuesToGroup(pi.getType(), group);
            }
            BenchmarkGeneratorUtils.addParameterValuesToGroup(clazz, group);
        }
        for (MethodGroup group : result.values()) {
            if (!group.getModes().isEmpty()) continue;
            group.addModes(Defaults.BENCHMARK_MODE);
        }
        ArrayList<BenchmarkInfo> benchmarks = new ArrayList<BenchmarkInfo>();
        for (MethodGroup group : result.values()) {
            String sourcePackage = clazz.getPackageName();
            String generatedPackageName = sourcePackage + ".generated";
            String generatedClassName = BenchmarkGeneratorUtils.getGeneratedName(clazz) + "_" + group.getName();
            BenchmarkInfo info = new BenchmarkInfo(clazz.getQualifiedName(), generatedPackageName, generatedClassName, group);
            this.validateBenchmarkInfo(info);
            benchmarks.add(info);
        }
        return benchmarks;
    }

    private void generateClass(GeneratorSource source, GeneratorDestination destination, ClassInfo classInfo, BenchmarkInfo info) throws IOException {
        PrintWriter writer = new PrintWriter(destination.newClass(info.generatedName), false);
        writer.println("package " + info.generatedPackageName + ';');
        writer.println();
        this.generateImport(writer);
        writer.println("@Generated(\"" + BenchmarkGenerator.class.getCanonicalName() + "\")");
        writer.println("public final class " + info.generatedClassName + " {");
        writer.println();
        this.generatePadding(writer);
        writer.println(BenchmarkGenerator.ident(1) + "int startRndMask;");
        StateObjectHandler states = new StateObjectHandler(this.compilerControl);
        states.bindImplicit(classInfo, "bench", Scope.Thread);
        states.bindImplicit(source.resolveClass(Blackhole.class.getCanonicalName()), "blackhole", Scope.Thread);
        states.bindMethodGroup(info.methodGroup);
        for (Mode benchmarkKind : Mode.values()) {
            if (benchmarkKind == Mode.All) continue;
            this.generateMethod(classInfo, benchmarkKind, writer, info.methodGroup, states);
        }
        for (String s : states.getStateInitializers()) {
            writer.println(BenchmarkGenerator.ident(1) + s);
        }
        writer.println();
        for (String s : states.getFields()) {
            writer.println(BenchmarkGenerator.ident(1) + s);
        }
        writer.println();
        for (String s : states.getStateOverrides()) {
            writer.println(BenchmarkGenerator.ident(1) + s);
        }
        writer.println();
        writer.println("}");
        writer.println();
        writer.close();
    }

    private void generatePadding(PrintWriter writer) {
        for (int p = 0; p < 16; ++p) {
            StringBuilder sb = new StringBuilder();
            sb.append(BenchmarkGenerator.ident(1));
            sb.append("private boolean p").append(p);
            for (int q = 1; q < 16; ++q) {
                sb.append(", p").append(p).append("_").append(q);
            }
            sb.append(";");
            writer.println(sb.toString());
        }
    }

    private void generateImport(PrintWriter writer) {
        Class[] imports;
        for (Class c : imports = new Class[]{List.class, AtomicInteger.class, AtomicIntegerFieldUpdater.class, Collection.class, Collections.class, ArrayList.class, Arrays.class, TimeUnit.class, Generated.class, CompilerControl.class, InfraControl.class, ThreadParams.class, Blackhole.class, Result.class, ThroughputResult.class, AverageTimeResult.class, SampleTimeResult.class, SingleShotResult.class, SampleBuffer.class, Mode.class, Fork.class, Measurement.class, Threads.class, Warmup.class, BenchmarkMode.class, RawResults.class, ResultRole.class, Field.class, BenchmarkParams.class, IterationParams.class}) {
            writer.println("import " + c.getName() + ';');
        }
        writer.println();
    }

    private void generateMethod(ClassInfo classInfo, Mode benchmarkKind, PrintWriter writer, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println();
        switch (benchmarkKind) {
            case Throughput: {
                this.generateThroughput(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            case AverageTime: {
                this.generateAverageTime(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            case SampleTime: {
                this.generateSampleTime(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            case SingleShotTime: {
                this.generateSingleShotTime(classInfo, writer, benchmarkKind, methodGroup, states);
                break;
            }
            default: {
                throw new AssertionError((Object)"Shouldn't be here");
            }
        }
    }

    private void generateThroughput(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public Collection<? extends Result> " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            this.iterationProlog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmupReady();");
            writer.println(BenchmarkGenerator.ident(3) + "while (control.warmupShouldWait) {");
            this.invocationProlog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println();
            for (StateObject so : states.getControls()) {
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".startMeasurement = true;");
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".iterationTime = control.getDuration();");
            }
            writer.println(BenchmarkGenerator.ident(3) + "RawResults res = new RawResults(control.benchmarkParams.getOpsPerInvocation());");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhLoop" + "(control, res" + this.prefix(states.getArgList(method)) + ");");
            for (StateObject so : states.getControls()) {
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".stopMeasurement = true;");
            }
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmdownReady();");
            writer.println(BenchmarkGenerator.ident(3) + "try {");
            writer.println(BenchmarkGenerator.ident(4) + "while (control.warmdownShouldWait) {");
            this.invocationProlog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDown();");
            writer.println(BenchmarkGenerator.ident(3) + "} catch (InterruptedException ie) {");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDownForce();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "Collection<Result> results = new ArrayList<Result>();");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new ThroughputResult(ResultRole.PRIMARY, \"" + method.getName() + "\", res.getOperations(), res.getTime(), control.benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new ThroughputResult(ResultRole.SECONDARY, \"" + method.getName() + "\", res.getOperations(), res.getTime(), control.benchmarkParams.getTimeUnit()));");
            }
            for (String ops : states.getAuxResultNames(method)) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new ThroughputResult(ResultRole.SECONDARY, \"" + ops + "\", " + states.getAuxResultAccessor(method, ops) + ", res.getTime(), control.benchmarkParams.getTimeUnit()));");
            }
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhLoop";
            this.compilerControl.defaultForceInline(method);
            this.compilerControl.alwaysDontInline(classInfo.getQualifiedName(), methodName);
            writer.println(BenchmarkGenerator.ident(1) + "public" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(InfraControl control, RawResults result" + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long operations = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "result.startTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "do {");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + "operations++;");
            writer.println(BenchmarkGenerator.ident(2) + "} while(!control.isDone);");
            writer.println(BenchmarkGenerator.ident(2) + "result.stopTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "result.realTime = realTime;");
            writer.println(BenchmarkGenerator.ident(2) + "result.operations = operations;");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private void generateAverageTime(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public Collection<? extends Result> " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            this.iterationProlog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmupReady();");
            writer.println(BenchmarkGenerator.ident(3) + "while (control.warmupShouldWait) {");
            this.invocationProlog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println();
            for (StateObject so : states.getControls()) {
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".startMeasurement = true;");
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".iterationTime = control.getDuration();");
            }
            writer.println(BenchmarkGenerator.ident(3) + "RawResults res = new RawResults(control.benchmarkParams.getOpsPerInvocation());");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhLoop(control, res" + this.prefix(states.getArgList(method)) + ");");
            for (StateObject so : states.getControls()) {
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".stopMeasurement = true;");
            }
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmdownReady();");
            writer.println(BenchmarkGenerator.ident(3) + "try {");
            writer.println(BenchmarkGenerator.ident(4) + "while (control.warmdownShouldWait) {");
            this.invocationProlog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDown();");
            writer.println(BenchmarkGenerator.ident(3) + "} catch (InterruptedException ie) {");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDownForce();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "Collection<Result> results = new ArrayList<Result>();");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new AverageTimeResult(ResultRole.PRIMARY, \"" + method.getName() + "\", res.getOperations(), res.getTime(), control.benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new AverageTimeResult(ResultRole.SECONDARY, \"" + method.getName() + "\", res.getOperations(), res.getTime(), control.benchmarkParams.getTimeUnit()));");
            }
            for (String ops : states.getAuxResultNames(method)) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new AverageTimeResult(ResultRole.SECONDARY, \"" + ops + "\", " + states.getAuxResultAccessor(method, ops) + ", res.getTime(), control.benchmarkParams.getTimeUnit()));");
            }
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhLoop";
            this.compilerControl.defaultForceInline(method);
            this.compilerControl.alwaysDontInline(classInfo.getQualifiedName(), methodName);
            writer.println(BenchmarkGenerator.ident(1) + "public" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(InfraControl control, RawResults result" + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long operations = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "result.startTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "do {");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + "operations++;");
            writer.println(BenchmarkGenerator.ident(2) + "} while(!control.isDone);");
            writer.println(BenchmarkGenerator.ident(2) + "result.stopTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "result.realTime = realTime;");
            writer.println(BenchmarkGenerator.ident(2) + "result.operations = operations;");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private void methodProlog(PrintWriter writer, MethodGroup methodGroup) {
    }

    private String prefix(String argList) {
        if (argList.trim().isEmpty()) {
            return "";
        }
        return ", " + argList;
    }

    private void generateSampleTime(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public Collection<? extends Result> " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            this.iterationProlog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmupReady();");
            writer.println(BenchmarkGenerator.ident(3) + "while (control.warmupShouldWait) {");
            this.invocationProlog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 4, method, states, false);
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println();
            for (StateObject so : states.getControls()) {
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".startMeasurement = true;");
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".iterationTime = control.getDuration();");
            }
            writer.println(BenchmarkGenerator.ident(3) + "int targetSamples = (int) (control.getDuration(TimeUnit.MILLISECONDS) * 20); // at max, 20 timestamps per millisecond");
            writer.println(BenchmarkGenerator.ident(3) + "SampleBuffer buffer = new SampleBuffer();");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhLoop(control, buffer, targetSamples, control.benchmarkParams.getOpsPerInvocation()" + this.prefix(states.getArgList(method)) + ");");
            for (StateObject so : states.getControls()) {
                writer.println(BenchmarkGenerator.ident(3) + so.localIdentifier + ".stopMeasurement = true;");
            }
            writer.println(BenchmarkGenerator.ident(3) + "control.announceWarmdownReady();");
            writer.println(BenchmarkGenerator.ident(3) + "try {");
            writer.println(BenchmarkGenerator.ident(4) + "while (control.warmdownShouldWait) {");
            this.invocationProlog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(5) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 5, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDown();");
            writer.println(BenchmarkGenerator.ident(3) + "} catch (InterruptedException ie) {");
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDownForce();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "Collection<Result> results = new ArrayList<Result>();");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new SampleTimeResult(ResultRole.PRIMARY, \"" + method.getName() + "\", buffer, control.benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new SampleTimeResult(ResultRole.SECONDARY, \"" + method.getName() + "\", buffer, control.benchmarkParams.getTimeUnit()));");
            }
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhLoop";
            this.compilerControl.defaultForceInline(method);
            this.compilerControl.alwaysDontInline(classInfo.getQualifiedName(), methodName);
            writer.println(BenchmarkGenerator.ident(1) + "public" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(InfraControl control, SampleBuffer buffer, int targetSamples, long opsPerInv" + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "int rnd = (int)System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "int rndMask = startRndMask;");
            writer.println(BenchmarkGenerator.ident(2) + "long time = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "int currentStride = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "do {");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + "rnd = (rnd * 1664525 + 1013904223);");
            writer.println(BenchmarkGenerator.ident(3) + "boolean sample = (rnd & rndMask) == 0;");
            writer.println(BenchmarkGenerator.ident(3) + "if (sample) {");
            writer.println(BenchmarkGenerator.ident(4) + "time = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            writer.println(BenchmarkGenerator.ident(3) + "" + this.emitCall(method, states) + ';');
            writer.println(BenchmarkGenerator.ident(3) + "if (sample) {");
            writer.println(BenchmarkGenerator.ident(4) + "buffer.add((System.nanoTime() - time) / opsPerInv);");
            writer.println(BenchmarkGenerator.ident(4) + "if (currentStride++ > targetSamples) {");
            writer.println(BenchmarkGenerator.ident(5) + "buffer.half();");
            writer.println(BenchmarkGenerator.ident(5) + "currentStride = 0;");
            writer.println(BenchmarkGenerator.ident(5) + "rndMask = (rndMask << 1) + 1;");
            writer.println(BenchmarkGenerator.ident(4) + "}");
            writer.println(BenchmarkGenerator.ident(3) + "}");
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(2) + "} while(!control.isDone);");
            writer.println(BenchmarkGenerator.ident(2) + "startRndMask = Math.max(startRndMask, rndMask);");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private void generateSingleShotTime(ClassInfo classInfo, PrintWriter writer, Mode benchmarkKind, MethodGroup methodGroup, StateObjectHandler states) {
        writer.println(BenchmarkGenerator.ident(1) + "public Collection<? extends Result> " + methodGroup.getName() + "_" + (Object)((Object)benchmarkKind) + "(InfraControl control, ThreadParams threadParams) throws Throwable {");
        this.methodProlog(writer, methodGroup);
        boolean isSingleMethod = methodGroup.methods().size() == 1;
        int subGroup = -1;
        for (MethodInfo method : methodGroup.methods()) {
            this.compilerControl.defaultForceInline(method);
            writer.println(BenchmarkGenerator.ident(2) + "if (threadParams.getSubgroupIndex() == " + ++subGroup + ") {");
            this.iterationProlog(writer, 3, method, states);
            this.invocationProlog(writer, 3, method, states, false);
            writer.println(BenchmarkGenerator.ident(3) + "RawResults res = new RawResults(control.benchmarkParams.getOpsPerInvocation());");
            writer.println(BenchmarkGenerator.ident(3) + method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhStub(control, res" + this.prefix(states.getArgList(method)) + ");");
            this.invocationEpilog(writer, 3, method, states, false);
            writer.println(BenchmarkGenerator.ident(4) + "control.preTearDown();");
            this.iterationEpilog(writer, 3, method, states);
            writer.println(BenchmarkGenerator.ident(3) + "Collection<Result> results = new ArrayList<Result>();");
            writer.println(BenchmarkGenerator.ident(3) + "results.add(new SingleShotResult(ResultRole.PRIMARY, \"" + method.getName() + "\", res.getTime(), control.benchmarkParams.getTimeUnit()));");
            if (!isSingleMethod) {
                writer.println(BenchmarkGenerator.ident(3) + "results.add(new SingleShotResult(ResultRole.SECONDARY, \"" + method.getName() + "\", res.getTime(), control.benchmarkParams.getTimeUnit()));");
            }
            writer.println(BenchmarkGenerator.ident(3) + "return results;");
            writer.println(BenchmarkGenerator.ident(2) + "} else");
        }
        writer.println(BenchmarkGenerator.ident(3) + "throw new IllegalStateException(\"Harness failed to distribute threads among groups properly\");");
        writer.println(BenchmarkGenerator.ident(1) + "}");
        writer.println();
        for (MethodInfo method : methodGroup.methods()) {
            String methodName = method.getName() + "_" + benchmarkKind.shortLabel() + "_jmhStub";
            this.compilerControl.defaultForceInline(method);
            this.compilerControl.alwaysDontInline(classInfo.getQualifiedName(), methodName);
            writer.println(BenchmarkGenerator.ident(1) + "public" + (methodGroup.isStrictFP() ? " strictfp" : "") + " void " + methodName + "(InfraControl control, RawResults result" + this.prefix(states.getTypeArgList(method)) + ") throws Throwable {");
            writer.println(BenchmarkGenerator.ident(2) + "long realTime = 0;");
            writer.println(BenchmarkGenerator.ident(2) + "result.startTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "int batchSize = control.iterationParams.getBatchSize();");
            writer.println(BenchmarkGenerator.ident(2) + "for (int b = 0; b < batchSize; b++) {");
            writer.println(BenchmarkGenerator.ident(3) + "if (control.volatileSpoiler) return;");
            this.invocationProlog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(3) + this.emitCall(method, states) + ';');
            this.invocationEpilog(writer, 3, method, states, true);
            writer.println(BenchmarkGenerator.ident(2) + "}");
            writer.println(BenchmarkGenerator.ident(2) + "result.stopTime = System.nanoTime();");
            writer.println(BenchmarkGenerator.ident(2) + "result.realTime = realTime;");
            writer.println(BenchmarkGenerator.ident(1) + "}");
            writer.println();
        }
    }

    private void invocationProlog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states, boolean pauseMeasurement) {
        if (!states.getInvocationSetups(method).isEmpty()) {
            for (String s : states.getInvocationSetups(method)) {
                writer.println(BenchmarkGenerator.ident(prefix) + s);
            }
            if (pauseMeasurement) {
                writer.println(BenchmarkGenerator.ident(prefix) + "long rt = System.nanoTime();");
            }
            writer.println();
        }
    }

    private void invocationEpilog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states, boolean pauseMeasurement) {
        if (!states.getInvocationTearDowns(method).isEmpty()) {
            writer.println();
            if (pauseMeasurement) {
                writer.println(BenchmarkGenerator.ident(prefix) + "realTime += (System.nanoTime() - rt);");
            }
            for (String s : states.getInvocationTearDowns(method)) {
                writer.println(BenchmarkGenerator.ident(prefix) + s);
            }
            writer.println();
        }
    }

    private void iterationProlog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states) {
        for (String s : states.getStateGetters(method)) {
            writer.println(BenchmarkGenerator.ident(prefix) + s);
        }
        writer.println();
        writer.println(BenchmarkGenerator.ident(prefix) + "control.preSetup();");
        for (String s : states.getIterationSetups(method)) {
            writer.println(BenchmarkGenerator.ident(prefix) + s);
        }
        writer.println();
    }

    private void iterationEpilog(PrintWriter writer, int prefix, MethodInfo method, StateObjectHandler states) {
        for (String s : states.getIterationTearDowns(method)) {
            writer.println(BenchmarkGenerator.ident(prefix) + s);
        }
        writer.println();
        writer.println(BenchmarkGenerator.ident(prefix) + "if (control.isLastIteration()) {");
        for (String s : states.getRunTearDowns(method)) {
            writer.println(BenchmarkGenerator.ident(prefix + 1) + s);
        }
        for (String s : states.getStateDestructors(method)) {
            writer.println(BenchmarkGenerator.ident(prefix + 1) + s);
        }
        writer.println(BenchmarkGenerator.ident(prefix) + "}");
    }

    private String emitCall(MethodInfo method, StateObjectHandler states) {
        if ("void".equalsIgnoreCase(method.getReturnType())) {
            return states.getImplicit((String)"bench").localIdentifier + "." + method.getName() + "(" + states.getGMBArgList(method) + ")";
        }
        return states.getImplicit((String)"blackhole").localIdentifier + ".consume(" + states.getImplicit((String)"bench").localIdentifier + "." + method.getName() + "(" + states.getGMBArgList(method) + "))";
    }

    static String ident(int prefix) {
        char[] chars = new char[prefix * 4];
        for (int i = 0; i < prefix * 4; ++i) {
            chars[i] = 32;
        }
        return new String(chars);
    }
}

