/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.opensearch.client;

import io.reactiverse.opensearch.client.TasksClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Optional;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.tasks.CancelTasksRequest;
import org.opensearch.client.tasks.CancelTasksResponse;
import org.opensearch.client.tasks.GetTaskRequest;
import org.opensearch.client.tasks.GetTaskResponse;

class TasksClientImpl
implements TasksClient {
    private final Vertx vertx;
    private final org.opensearch.client.TasksClient delegate;

    TasksClientImpl(Vertx vertx, org.opensearch.client.TasksClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void listAsync(ListTasksRequest request, RequestOptions options, final Handler<AsyncResult<ListTasksResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.listAsync(request, options, (ActionListener)new ActionListener<ListTasksResponse>(){

            public void onResponse(ListTasksResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAsync(GetTaskRequest request, RequestOptions options, final Handler<AsyncResult<Optional<GetTaskResponse>>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAsync(request, options, (ActionListener)new ActionListener<Optional<GetTaskResponse>>(){

            public void onResponse(Optional<GetTaskResponse> value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void cancelAsync(CancelTasksRequest cancelTasksRequest, RequestOptions options, final Handler<AsyncResult<CancelTasksResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.cancelAsync(cancelTasksRequest, options, (ActionListener)new ActionListener<CancelTasksResponse>(){

            public void onResponse(CancelTasksResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

