/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.opensearch.client;

import io.reactiverse.opensearch.client.ClusterClient;
import io.reactiverse.opensearch.client.ClusterClientImpl;
import io.reactiverse.opensearch.client.IndicesClient;
import io.reactiverse.opensearch.client.IndicesClientImpl;
import io.reactiverse.opensearch.client.IngestClient;
import io.reactiverse.opensearch.client.IngestClientImpl;
import io.reactiverse.opensearch.client.RestHighLevelClient;
import io.reactiverse.opensearch.client.SnapshotClient;
import io.reactiverse.opensearch.client.SnapshotClientImpl;
import io.reactiverse.opensearch.client.TasksClient;
import io.reactiverse.opensearch.client.TasksClientImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.opensearch.action.admin.cluster.storedscripts.GetStoredScriptResponse;
import org.opensearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.explain.ExplainRequest;
import org.opensearch.action.explain.ExplainResponse;
import org.opensearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.opensearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.CreatePitResponse;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.action.search.DeletePitResponse;
import org.opensearch.action.search.GetAllPitNodesResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RethrottleRequest;
import org.opensearch.client.core.CountRequest;
import org.opensearch.client.core.CountResponse;
import org.opensearch.client.core.GetSourceRequest;
import org.opensearch.client.core.GetSourceResponse;
import org.opensearch.client.core.MultiTermVectorsRequest;
import org.opensearch.client.core.MultiTermVectorsResponse;
import org.opensearch.client.core.TermVectorsRequest;
import org.opensearch.client.core.TermVectorsResponse;
import org.opensearch.index.rankeval.RankEvalRequest;
import org.opensearch.index.rankeval.RankEvalResponse;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.script.mustache.MultiSearchTemplateRequest;
import org.opensearch.script.mustache.MultiSearchTemplateResponse;
import org.opensearch.script.mustache.SearchTemplateRequest;
import org.opensearch.script.mustache.SearchTemplateResponse;

class RestHighLevelClientImpl
implements RestHighLevelClient {
    private final Vertx vertx;
    private final RestClientBuilder restClientBuilder;
    private final org.opensearch.client.RestHighLevelClient delegate;

    RestHighLevelClientImpl(Vertx vertx, RestClientBuilder restClientBuilder) {
        this.vertx = vertx;
        this.restClientBuilder = restClientBuilder;
        this.delegate = new org.opensearch.client.RestHighLevelClient(restClientBuilder);
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public IndicesClient indices() {
        return new IndicesClientImpl(this.vertx, this.delegate.indices());
    }

    @Override
    public ClusterClient cluster() {
        return new ClusterClientImpl(this.vertx, this.delegate.cluster());
    }

    @Override
    public IngestClient ingest() {
        return new IngestClientImpl(this.vertx, this.delegate.ingest());
    }

    @Override
    public SnapshotClient snapshot() {
        return new SnapshotClientImpl(this.vertx, this.delegate.snapshot());
    }

    @Override
    public TasksClient tasks() {
        return new TasksClientImpl(this.vertx, this.delegate.tasks());
    }

    @Override
    public void bulkAsync(BulkRequest bulkRequest, RequestOptions options, final Handler<AsyncResult<BulkResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.bulkAsync(bulkRequest, options, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void reindexAsync(ReindexRequest reindexRequest, RequestOptions options, final Handler<AsyncResult<BulkByScrollResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.reindexAsync(reindexRequest, options, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void updateByQueryAsync(UpdateByQueryRequest updateByQueryRequest, RequestOptions options, final Handler<AsyncResult<BulkByScrollResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.updateByQueryAsync(updateByQueryRequest, options, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteByQueryAsync(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options, final Handler<AsyncResult<BulkByScrollResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteByQueryAsync(deleteByQueryRequest, options, (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, final Handler<AsyncResult<ListTasksResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteByQueryRethrottleAsync(rethrottleRequest, options, (ActionListener)new ActionListener<ListTasksResponse>(){

            public void onResponse(ListTasksResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void updateByQueryRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, final Handler<AsyncResult<ListTasksResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.updateByQueryRethrottleAsync(rethrottleRequest, options, (ActionListener)new ActionListener<ListTasksResponse>(){

            public void onResponse(ListTasksResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void reindexRethrottleAsync(RethrottleRequest rethrottleRequest, RequestOptions options, final Handler<AsyncResult<ListTasksResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.reindexRethrottleAsync(rethrottleRequest, options, (ActionListener)new ActionListener<ListTasksResponse>(){

            public void onResponse(ListTasksResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAsync(GetRequest getRequest, RequestOptions options, final Handler<AsyncResult<GetResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAsync(getRequest, options, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void mgetAsync(MultiGetRequest multiGetRequest, RequestOptions options, final Handler<AsyncResult<MultiGetResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.mgetAsync(multiGetRequest, options, (ActionListener)new ActionListener<MultiGetResponse>(){

            public void onResponse(MultiGetResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void existsAsync(GetRequest getRequest, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.existsAsync(getRequest, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void existsSourceAsync(GetSourceRequest getSourceRequest, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.existsSourceAsync(getSourceRequest, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getSourceAsync(GetSourceRequest getSourceRequest, RequestOptions options, final Handler<AsyncResult<GetSourceResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getSourceAsync(getSourceRequest, options, (ActionListener)new ActionListener<GetSourceResponse>(){

            public void onResponse(GetSourceResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void indexAsync(IndexRequest indexRequest, RequestOptions options, final Handler<AsyncResult<IndexResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.indexAsync(indexRequest, options, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void countAsync(CountRequest countRequest, RequestOptions options, final Handler<AsyncResult<CountResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.countAsync(countRequest, options, (ActionListener)new ActionListener<CountResponse>(){

            public void onResponse(CountResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void updateAsync(UpdateRequest updateRequest, RequestOptions options, final Handler<AsyncResult<UpdateResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.updateAsync(updateRequest, options, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteAsync(DeleteRequest deleteRequest, RequestOptions options, final Handler<AsyncResult<DeleteResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteAsync(deleteRequest, options, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void searchAsync(SearchRequest searchRequest, RequestOptions options, final Handler<AsyncResult<SearchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.searchAsync(searchRequest, options, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void msearchAsync(MultiSearchRequest searchRequest, RequestOptions options, final Handler<AsyncResult<MultiSearchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.msearchAsync(searchRequest, options, (ActionListener)new ActionListener<MultiSearchResponse>(){

            public void onResponse(MultiSearchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void scrollAsync(SearchScrollRequest searchScrollRequest, RequestOptions options, final Handler<AsyncResult<SearchResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.scrollAsync(searchScrollRequest, options, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void createPitAsync(CreatePitRequest createPitRequest, RequestOptions options, final Handler<AsyncResult<CreatePitResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.createPitAsync(createPitRequest, options, (ActionListener)new ActionListener<CreatePitResponse>(){

            public void onResponse(CreatePitResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deletePitAsync(DeletePitRequest deletePitRequest, RequestOptions options, final Handler<AsyncResult<DeletePitResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deletePitAsync(deletePitRequest, options, (ActionListener)new ActionListener<DeletePitResponse>(){

            public void onResponse(DeletePitResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteAllPitsAsync(RequestOptions options, final Handler<AsyncResult<DeletePitResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteAllPitsAsync(options, (ActionListener)new ActionListener<DeletePitResponse>(){

            public void onResponse(DeletePitResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAllPitsAsync(RequestOptions options, final Handler<AsyncResult<GetAllPitNodesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAllPitsAsync(options, (ActionListener)new ActionListener<GetAllPitNodesResponse>(){

            public void onResponse(GetAllPitNodesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void clearScrollAsync(ClearScrollRequest clearScrollRequest, RequestOptions options, final Handler<AsyncResult<ClearScrollResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.clearScrollAsync(clearScrollRequest, options, (ActionListener)new ActionListener<ClearScrollResponse>(){

            public void onResponse(ClearScrollResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void searchTemplateAsync(SearchTemplateRequest searchTemplateRequest, RequestOptions options, final Handler<AsyncResult<SearchTemplateResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.searchTemplateAsync(searchTemplateRequest, options, (ActionListener)new ActionListener<SearchTemplateResponse>(){

            public void onResponse(SearchTemplateResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void explainAsync(ExplainRequest explainRequest, RequestOptions options, final Handler<AsyncResult<ExplainResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.explainAsync(explainRequest, options, (ActionListener)new ActionListener<ExplainResponse>(){

            public void onResponse(ExplainResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void termvectorsAsync(TermVectorsRequest request, RequestOptions options, final Handler<AsyncResult<TermVectorsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.termvectorsAsync(request, options, (ActionListener)new ActionListener<TermVectorsResponse>(){

            public void onResponse(TermVectorsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void mtermvectorsAsync(MultiTermVectorsRequest request, RequestOptions options, final Handler<AsyncResult<MultiTermVectorsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.mtermvectorsAsync(request, options, (ActionListener)new ActionListener<MultiTermVectorsResponse>(){

            public void onResponse(MultiTermVectorsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void msearchTemplateAsync(MultiSearchTemplateRequest multiSearchTemplateRequest, RequestOptions options, final Handler<AsyncResult<MultiSearchTemplateResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.msearchTemplateAsync(multiSearchTemplateRequest, options, (ActionListener)new ActionListener<MultiSearchTemplateResponse>(){

            public void onResponse(MultiSearchTemplateResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void rankEvalAsync(RankEvalRequest rankEvalRequest, RequestOptions options, final Handler<AsyncResult<RankEvalResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.rankEvalAsync(rankEvalRequest, options, (ActionListener)new ActionListener<RankEvalResponse>(){

            public void onResponse(RankEvalResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getScriptAsync(GetStoredScriptRequest request, RequestOptions options, final Handler<AsyncResult<GetStoredScriptResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getScriptAsync(request, options, (ActionListener)new ActionListener<GetStoredScriptResponse>(){

            public void onResponse(GetStoredScriptResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteScriptAsync(DeleteStoredScriptRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteScriptAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putScriptAsync(PutStoredScriptRequest putStoredScriptRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putScriptAsync(putStoredScriptRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void fieldCapsAsync(FieldCapabilitiesRequest fieldCapabilitiesRequest, RequestOptions options, final Handler<AsyncResult<FieldCapabilitiesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.fieldCapsAsync(fieldCapabilitiesRequest, options, (ActionListener)new ActionListener<FieldCapabilitiesResponse>(){

            public void onResponse(FieldCapabilitiesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

