/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.opensearch.client;

import io.reactiverse.opensearch.client.IndicesClient;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.flush.FlushResponse;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.opensearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.GetAliasesResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.indices.AnalyzeRequest;
import org.opensearch.client.indices.AnalyzeResponse;
import org.opensearch.client.indices.CloseIndexRequest;
import org.opensearch.client.indices.CloseIndexResponse;
import org.opensearch.client.indices.ComposableIndexTemplateExistRequest;
import org.opensearch.client.indices.CreateDataStreamRequest;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.DataStreamsStatsRequest;
import org.opensearch.client.indices.DataStreamsStatsResponse;
import org.opensearch.client.indices.DeleteAliasRequest;
import org.opensearch.client.indices.DeleteComposableIndexTemplateRequest;
import org.opensearch.client.indices.DeleteDataStreamRequest;
import org.opensearch.client.indices.GetComposableIndexTemplateRequest;
import org.opensearch.client.indices.GetComposableIndexTemplatesResponse;
import org.opensearch.client.indices.GetDataStreamRequest;
import org.opensearch.client.indices.GetDataStreamResponse;
import org.opensearch.client.indices.GetFieldMappingsRequest;
import org.opensearch.client.indices.GetFieldMappingsResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.opensearch.client.indices.GetIndexTemplatesRequest;
import org.opensearch.client.indices.GetIndexTemplatesResponse;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.client.indices.GetMappingsResponse;
import org.opensearch.client.indices.IndexTemplatesExistRequest;
import org.opensearch.client.indices.PutComposableIndexTemplateRequest;
import org.opensearch.client.indices.PutIndexTemplateRequest;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.client.indices.ResizeRequest;
import org.opensearch.client.indices.ResizeResponse;
import org.opensearch.client.indices.SimulateIndexTemplateRequest;
import org.opensearch.client.indices.SimulateIndexTemplateResponse;
import org.opensearch.client.indices.rollover.RolloverRequest;
import org.opensearch.client.indices.rollover.RolloverResponse;

class IndicesClientImpl
implements IndicesClient {
    private final Vertx vertx;
    private final org.opensearch.client.IndicesClient delegate;

    IndicesClientImpl(Vertx vertx, org.opensearch.client.IndicesClient delegate) {
        this.vertx = vertx;
        this.delegate = delegate;
    }

    @Override
    public void deleteAsync(DeleteIndexRequest deleteIndexRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteAsync(deleteIndexRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void createAsync(CreateIndexRequest createIndexRequest, RequestOptions options, final Handler<AsyncResult<CreateIndexResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.createAsync(createIndexRequest, options, (ActionListener)new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void createDataStreamAsync(CreateDataStreamRequest createDataStreamRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.createDataStreamAsync(createDataStreamRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteDataStreamAsync(DeleteDataStreamRequest deleteDataStreamRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteDataStreamAsync(deleteDataStreamRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getDataStreamAsync(GetDataStreamRequest dataStreamRequest, RequestOptions options, final Handler<AsyncResult<GetDataStreamResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getDataStreamAsync(dataStreamRequest, options, (ActionListener)new ActionListener<GetDataStreamResponse>(){

            public void onResponse(GetDataStreamResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void dataStreamsStatsAsync(DataStreamsStatsRequest dataStreamsStatsRequest, RequestOptions options, final Handler<AsyncResult<DataStreamsStatsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.dataStreamsStatsAsync(dataStreamsStatsRequest, options, (ActionListener)new ActionListener<DataStreamsStatsResponse>(){

            public void onResponse(DataStreamsStatsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putMappingAsync(PutMappingRequest putMappingRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putMappingAsync(putMappingRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getMappingAsync(GetMappingsRequest getMappingsRequest, RequestOptions options, final Handler<AsyncResult<GetMappingsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getMappingAsync(getMappingsRequest, options, (ActionListener)new ActionListener<GetMappingsResponse>(){

            public void onResponse(GetMappingsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getFieldMappingAsync(GetFieldMappingsRequest getFieldMappingsRequest, RequestOptions options, final Handler<AsyncResult<GetFieldMappingsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getFieldMappingAsync(getFieldMappingsRequest, options, (ActionListener)new ActionListener<GetFieldMappingsResponse>(){

            public void onResponse(GetFieldMappingsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void updateAliasesAsync(IndicesAliasesRequest indicesAliasesRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.updateAliasesAsync(indicesAliasesRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void openAsync(OpenIndexRequest openIndexRequest, RequestOptions options, final Handler<AsyncResult<OpenIndexResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.openAsync(openIndexRequest, options, (ActionListener)new ActionListener<OpenIndexResponse>(){

            public void onResponse(OpenIndexResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public CloseIndexResponse close(CloseIndexRequest closeIndexRequest, RequestOptions options) {
        try {
            return this.delegate.close(closeIndexRequest, options);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void closeAsync(CloseIndexRequest closeIndexRequest, RequestOptions options, final Handler<AsyncResult<CloseIndexResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.closeAsync(closeIndexRequest, options, (ActionListener)new ActionListener<CloseIndexResponse>(){

            public void onResponse(CloseIndexResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void existsAliasAsync(GetAliasesRequest getAliasesRequest, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.existsAliasAsync(getAliasesRequest, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void refreshAsync(RefreshRequest refreshRequest, RequestOptions options, final Handler<AsyncResult<RefreshResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.refreshAsync(refreshRequest, options, (ActionListener)new ActionListener<RefreshResponse>(){

            public void onResponse(RefreshResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void flushAsync(FlushRequest flushRequest, RequestOptions options, final Handler<AsyncResult<FlushResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.flushAsync(flushRequest, options, (ActionListener)new ActionListener<FlushResponse>(){

            public void onResponse(FlushResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getSettingsAsync(GetSettingsRequest getSettingsRequest, RequestOptions options, final Handler<AsyncResult<GetSettingsResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getSettingsAsync(getSettingsRequest, options, (ActionListener)new ActionListener<GetSettingsResponse>(){

            public void onResponse(GetSettingsResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAsync(GetIndexRequest getIndexRequest, RequestOptions options, final Handler<AsyncResult<GetIndexResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAsync(getIndexRequest, options, (ActionListener)new ActionListener<GetIndexResponse>(){

            public void onResponse(GetIndexResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void forcemergeAsync(ForceMergeRequest forceMergeRequest, RequestOptions options, final Handler<AsyncResult<ForceMergeResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.forcemergeAsync(forceMergeRequest, options, (ActionListener)new ActionListener<ForceMergeResponse>(){

            public void onResponse(ForceMergeResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void clearCacheAsync(ClearIndicesCacheRequest clearIndicesCacheRequest, RequestOptions options, final Handler<AsyncResult<ClearIndicesCacheResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.clearCacheAsync(clearIndicesCacheRequest, options, (ActionListener)new ActionListener<ClearIndicesCacheResponse>(){

            public void onResponse(ClearIndicesCacheResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void existsAsync(GetIndexRequest request, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.existsAsync(request, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void shrinkAsync(ResizeRequest resizeRequest, RequestOptions options, final Handler<AsyncResult<ResizeResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.shrinkAsync(resizeRequest, options, (ActionListener)new ActionListener<ResizeResponse>(){

            public void onResponse(ResizeResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void splitAsync(ResizeRequest resizeRequest, RequestOptions options, final Handler<AsyncResult<ResizeResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.splitAsync(resizeRequest, options, (ActionListener)new ActionListener<ResizeResponse>(){

            public void onResponse(ResizeResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void cloneAsync(ResizeRequest resizeRequest, RequestOptions options, final Handler<AsyncResult<ResizeResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.cloneAsync(resizeRequest, options, (ActionListener)new ActionListener<ResizeResponse>(){

            public void onResponse(ResizeResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void rolloverAsync(RolloverRequest rolloverRequest, RequestOptions options, final Handler<AsyncResult<RolloverResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.rolloverAsync(rolloverRequest, options, (ActionListener)new ActionListener<RolloverResponse>(){

            public void onResponse(RolloverResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getAliasAsync(GetAliasesRequest getAliasesRequest, RequestOptions options, final Handler<AsyncResult<GetAliasesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getAliasAsync(getAliasesRequest, options, (ActionListener)new ActionListener<GetAliasesResponse>(){

            public void onResponse(GetAliasesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putSettingsAsync(UpdateSettingsRequest updateSettingsRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putSettingsAsync(updateSettingsRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putTemplateAsync(PutIndexTemplateRequest putIndexTemplateRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putTemplateAsync(putIndexTemplateRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void putIndexTemplateAsync(PutComposableIndexTemplateRequest putIndexTemplateRequest, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.putIndexTemplateAsync(putIndexTemplateRequest, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void simulateIndexTemplateAsync(SimulateIndexTemplateRequest simulateIndexTemplateRequest, RequestOptions options, final Handler<AsyncResult<SimulateIndexTemplateResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.simulateIndexTemplateAsync(simulateIndexTemplateRequest, options, (ActionListener)new ActionListener<SimulateIndexTemplateResponse>(){

            public void onResponse(SimulateIndexTemplateResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void validateQueryAsync(ValidateQueryRequest validateQueryRequest, RequestOptions options, final Handler<AsyncResult<ValidateQueryResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.validateQueryAsync(validateQueryRequest, options, (ActionListener)new ActionListener<ValidateQueryResponse>(){

            public void onResponse(ValidateQueryResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getIndexTemplateAsync(GetComposableIndexTemplateRequest getIndexTemplatesRequest, RequestOptions options, final Handler<AsyncResult<GetComposableIndexTemplatesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getIndexTemplateAsync(getIndexTemplatesRequest, options, (ActionListener)new ActionListener<GetComposableIndexTemplatesResponse>(){

            public void onResponse(GetComposableIndexTemplatesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void getIndexTemplateAsync(GetIndexTemplatesRequest getIndexTemplatesRequest, RequestOptions options, final Handler<AsyncResult<GetIndexTemplatesResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.getIndexTemplateAsync(getIndexTemplatesRequest, options, (ActionListener)new ActionListener<GetIndexTemplatesResponse>(){

            public void onResponse(GetIndexTemplatesResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void existsTemplateAsync(IndexTemplatesExistRequest indexTemplatesExistRequest, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.existsTemplateAsync(indexTemplatesExistRequest, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void existsIndexTemplateAsync(ComposableIndexTemplateExistRequest indexTemplatesExistRequest, RequestOptions options, final Handler<AsyncResult<Boolean>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.existsIndexTemplateAsync(indexTemplatesExistRequest, options, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void analyzeAsync(AnalyzeRequest request, RequestOptions options, final Handler<AsyncResult<AnalyzeResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.analyzeAsync(request, options, (ActionListener)new ActionListener<AnalyzeResponse>(){

            public void onResponse(AnalyzeResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteTemplateAsync(DeleteIndexTemplateRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteTemplateAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteIndexTemplateAsync(DeleteComposableIndexTemplateRequest request, RequestOptions options, final Handler<AsyncResult<AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteIndexTemplateAsync(request, options, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }

    @Override
    public void deleteAliasAsync(DeleteAliasRequest request, RequestOptions options, final Handler<AsyncResult<org.opensearch.client.core.AcknowledgedResponse>> handler) {
        final Context context = this.vertx.getOrCreateContext();
        this.delegate.deleteAliasAsync(request, options, (ActionListener)new ActionListener<org.opensearch.client.core.AcknowledgedResponse>(){

            public void onResponse(org.opensearch.client.core.AcknowledgedResponse value) {
                context.runOnContext(v -> handler.handle((Object)Future.succeededFuture((Object)value)));
            }

            public void onFailure(Exception e) {
                context.runOnContext(v -> handler.handle((Object)Future.failedFuture((Throwable)e)));
            }
        });
    }
}

