/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.sourcemap;

import java.util.Arrays;

class Base64VLQ {
    private static final String BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final int[] BASE64_DECODE_MAP = new int[256];
    private static final int VLQ_BASE_SHIFT = 5;
    private static final int VLQ_BASE = 32;
    private static final int VLQ_BASE_MASK = 31;
    private static final int VLQ_CONTINUATION_BIT = 32;

    private Base64VLQ() {
    }

    private static int fromVLQSigned(int value) {
        boolean negate = (value & 1) == 1;
        return negate ? -value : (value >>= 1);
    }

    public static int decode(CharIterator in) {
        boolean continuation;
        int result = 0;
        int shift = 0;
        do {
            char c;
            int digit;
            continuation = ((digit = Base64VLQ.fromBase64(c = in.next())) & 0x20) != 0;
            result += (digit &= 0x1F) << shift;
            shift += 5;
        } while (continuation);
        return Base64VLQ.fromVLQSigned(result);
    }

    public static int fromBase64(char c) {
        int result = BASE64_DECODE_MAP[c];
        assert (result != -1) : "invalid char";
        return BASE64_DECODE_MAP[c];
    }

    static {
        Arrays.fill(BASE64_DECODE_MAP, -1);
        for (int i = 0; i < BASE64_MAP.length(); ++i) {
            Base64VLQ.BASE64_DECODE_MAP[BASE64_MAP.charAt((int)i)] = i;
        }
    }

    static interface CharIterator {
        public boolean hasNext();

        public char next();
    }
}

