/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.jul;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;

public class ANSIFormatter
extends Formatter {
    private static final boolean colors;
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";

    @Override
    public synchronized String format(LogRecord record) {
        Throwable thrown = record.getThrown();
        String message = record.getMessage();
        String thrownMessage = null;
        String thrownTrace = null;
        if (thrown != null) {
            try (StringWriter sw2 = new StringWriter();){
                PrintWriter pw = new PrintWriter(sw2);
                thrown.printStackTrace(pw);
                String sStackTrace = sw2.toString();
                int idx = sStackTrace.indexOf("\n\tat");
                if (idx != -1) {
                    thrownMessage = sStackTrace.substring(0, idx);
                    thrownTrace = sStackTrace.substring(idx);
                } else {
                    thrownTrace = sStackTrace;
                }
            }
            catch (IOException sw2) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder();
        if (colors) {
            sb.append(ANSIFormatter.prefix(record.getLevel()));
        }
        sb.append(message);
        if (thrownMessage != null) {
            sb.append(" caused by ");
            sb.append(thrownMessage);
        }
        if (colors) {
            sb.append(ANSIFormatter.suffix(record.getLevel()));
        }
        if (thrownTrace != null) {
            sb.append(thrownTrace);
        } else {
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static String prefix(Level l) {
        if (Level.SEVERE.equals(l)) {
            return "\u001b[1m\u001b[31m";
        }
        if (Level.WARNING.equals(l)) {
            return "\u001b[1m\u001b[33m";
        }
        if (Level.INFO.equals(l)) {
            return "";
        }
        if (Level.CONFIG.equals(l)) {
            return "\u001b[1m\u001b[34m";
        }
        if (Level.FINE.equals(l)) {
            return "\u001b[1m\u001b[32m";
        }
        if (Level.FINER.equals(l)) {
            return "\u001b[1m\u001b[94m";
        }
        if (Level.FINEST.equals(l)) {
            return "\u001b[94m";
        }
        return "[" + l.getName().toUpperCase() + "] ";
    }

    private static String suffix(Level l) {
        if (Level.SEVERE.equals(l)) {
            return "\u001b[0m";
        }
        if (Level.WARNING.equals(l)) {
            return "\u001b[0m";
        }
        if (Level.INFO.equals(l)) {
            return "";
        }
        if (Level.CONFIG.equals(l)) {
            return "\u001b[0m";
        }
        if (Level.FINE.equals(l)) {
            return "\u001b[0m";
        }
        if (Level.FINER.equals(l)) {
            return "\u001b[0m";
        }
        if (Level.FINEST.equals(l)) {
            return "\u001b[0m";
        }
        return "";
    }

    public static void printStackTrace(Throwable self, PrintWriter s) {
        Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        dejaVu.add(self);
        s.println(self);
        StackTraceElement[] trace = self.getStackTrace();
        ANSIFormatter.printTrace(self, trace, trace.length, s);
        for (Throwable se : self.getSuppressed()) {
            ANSIFormatter.printEnclosedStackTrace(se, s, trace, SUPPRESSED_CAPTION, "\t", dejaVu);
        }
        Throwable ourCause = self.getCause();
        if (ourCause != null) {
            ANSIFormatter.printEnclosedStackTrace(ourCause, s, trace, CAUSE_CAPTION, "", dejaVu);
        }
    }

    private static void printEnclosedStackTrace(Throwable self, PrintWriter s, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
        if (dejaVu.contains(self)) {
            s.println(prefix + caption + "[CIRCULAR REFERENCE: " + self + "]");
        } else {
            dejaVu.add(self);
            StackTraceElement[] trace = self.getStackTrace();
            int m = trace.length - 1;
            for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            s.println(prefix + caption + self);
            ANSIFormatter.printTrace(self, trace, m, s);
            if (framesInCommon != 0) {
                s.println(prefix + "\t... " + framesInCommon + " more");
            }
            for (Throwable se : self.getSuppressed()) {
                ANSIFormatter.printEnclosedStackTrace(se, s, trace, SUPPRESSED_CAPTION, prefix + "\t", dejaVu);
            }
            Throwable ourCause = self.getCause();
            if (ourCause != null) {
                ANSIFormatter.printEnclosedStackTrace(ourCause, s, trace, CAUSE_CAPTION, prefix, dejaVu);
            }
        }
    }

    private static void printTrace(Throwable self, StackTraceElement[] trace, int limit, PrintWriter s) {
        if (self instanceof PolyglotException) {
            int i = 0;
            for (PolyglotException.StackFrame stackFrame : ((PolyglotException)self).getPolyglotStackTrace()) {
                if (i++ != limit) {
                    if (stackFrame.isHostFrame()) {
                        s.println("\tat " + stackFrame);
                        continue;
                    }
                    SourceSection sourceSection = stackFrame.getSourceLocation();
                    if (sourceSection != null) {
                        URI uri = sourceSection.getSource().getURI();
                        s.println("\tat <js> " + stackFrame.getRootName() + "(" + ("file".equals(uri.getScheme()) ? uri.getPath() : uri) + (sourceSection.hasLines() ? ":" + sourceSection.getStartLine() : "") + (sourceSection.hasColumns() ? ":" + sourceSection.getStartColumn() : "") + ")");
                        continue;
                    }
                    s.println("\tat " + stackFrame);
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i <= limit; ++i) {
                s.println("\tat " + trace[i]);
            }
        }
    }

    static {
        String term;
        colors = Boolean.getBoolean("noTTY") ? false : ((term = System.getenv("TERM")) != null ? (term = term.toLowerCase()).equals("xterm-color") || term.endsWith("-256color") : System.console() != null);
    }
}

