/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.reactiverse.es4x.impl.ImportMapper;
import io.reactiverse.es4x.impl.UnmappedBareSpecifierException;
import io.reactiverse.es4x.impl.Utils;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.polyglot.io.FileSystem;

public final class VertxFileSystem
implements FileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxFileSystem.class);
    private static final FileSystemProvider DELEGATE = FileSystems.getDefault().provider();
    private final Map<String, String> urlMap = new ConcurrentHashMap<String, String>();
    private final VertxInternal vertx;
    private final String[] extensions;
    private final String cwd;
    private final String downloadDir;
    private final String baseDir;
    private final ImportMapper mapper;

    public static String getCWD() {
        String cwdOverride = System.getProperty("vertx.cwd");
        String cwd = cwdOverride != null ? new File(cwdOverride).getAbsolutePath() : System.getProperty("user.dir", "");
        if (cwd.charAt(cwd.length() - 1) != File.separatorChar) {
            cwd = cwd + File.separatorChar;
        }
        return cwd;
    }

    public VertxFileSystem(Vertx vertx, String importMap, String ... extensions) {
        this.vertx = (VertxInternal)vertx;
        this.extensions = extensions;
        try {
            this.cwd = VertxFileSystem.getCWD();
            URL cwdUrl = Utils.fileToURL(new File(this.cwd).getCanonicalFile());
            if (importMap == null) {
                this.mapper = new ImportMapper(new JsonObject().put("imports", (Object)new JsonObject().put(Utils.toNixPath(this.cwd), (Object)"./")), cwdUrl);
                this.baseDir = new File(this.cwd, "node_modules").getCanonicalPath() + File.separator;
                this.downloadDir = new File(this.baseDir, ".download").getCanonicalPath() + File.separator;
            } else {
                this.baseDir = new File(this.cwd).getCanonicalPath() + File.separator;
                this.downloadDir = new File(this.baseDir, ".download").getCanonicalPath() + File.separator;
                JsonObject json = new JsonObject(vertx.fileSystem().readFileBlocking(importMap));
                if (json.containsKey("imports")) {
                    json.getJsonObject("imports").put(Utils.toNixPath(this.cwd), (Object)"./");
                } else {
                    json.put("imports", (Object)new JsonObject().put(Utils.toNixPath(this.cwd), (Object)"./"));
                }
                this.mapper = new ImportMapper(json, cwdUrl);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot resolve the CWD", e);
        }
    }

    private File resolveFile(File root, String suffix) {
        File file;
        File file2 = file = suffix == null ? root : new File(root, suffix);
        if (file.isFile()) {
            return file;
        }
        if (this.extensions != null) {
            String path = file.getPath();
            for (String ext : this.extensions) {
                File f;
                if (path.endsWith(ext) || !(f = this.vertx.resolveFile(path + ext)).isFile()) continue;
                return f;
            }
        }
        if (file.isDirectory()) {
            return this.resolveFile(file, "index");
        }
        return root;
    }

    private Path parsePath(URL url) {
        try {
            String source = url.getProtocol() + "://" + url.getAuthority();
            String hash = Utils.md5(source);
            this.urlMap.put(hash, source);
            File target = new File(this.downloadDir, hash + File.separator + url.getPath());
            if (url.getQuery() != null) {
                LOGGER.warn((Object)"URI with query will always force a download");
                Utils.downloadTo(url, target);
            } else if (!target.exists()) {
                Utils.downloadTo(url, target);
            }
            assert (target.isAbsolute()) : "path should be absolute";
            return target.toPath();
        }
        catch (IOException e) {
            throw new InvalidPathException(url.toString(), e.getMessage());
        }
    }

    public Path parsePath(URI uri) {
        LOGGER.trace((Object)String.format("parsePath(%s)", uri));
        switch (uri.getScheme()) {
            case "file": {
                return this.parsePath(uri.getPath());
            }
            case "http": 
            case "https": {
                try {
                    return this.parsePath(uri.toURL());
                }
                catch (MalformedURLException e) {
                    throw new InvalidPathException(uri.toString(), e.getMessage());
                }
            }
        }
        throw new IllegalArgumentException("unsupported scheme: " + uri.getScheme());
    }

    public Path parsePath(String path) {
        File file;
        LOGGER.trace((Object)String.format("parsePath(%s)", path));
        if ("".equals(path)) {
            return new File(this.cwd).toPath();
        }
        try {
            URI resolved = this.mapper.resolve(path);
            LOGGER.trace((Object)String.format("import-map.resolve(%s) : %s", path, resolved));
            switch (resolved.getScheme()) {
                case "file": {
                    file = this.vertx.resolveFile(resolved.getPath());
                    break;
                }
                case "http": 
                case "https": {
                    try {
                        return this.parsePath(resolved.toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new InvalidPathException(path, e.getMessage());
                    }
                }
                default: {
                    throw new IllegalArgumentException("unsupported scheme: " + resolved.getScheme());
                }
            }
        }
        catch (UnmappedBareSpecifierException e) {
            LOGGER.debug((Object)"Failed to resolve module", (Throwable)e);
            file = new File(this.baseDir, path);
        }
        catch (URISyntaxException e) {
            throw new InvalidPathException(path, e.getMessage());
        }
        if (!this.fetchIfNeeded(file, path)) {
            file = this.vertx.resolveFile(file.getPath());
        }
        return file.toPath();
    }

    private boolean fetchIfNeeded(File file, String path) {
        LOGGER.trace((Object)String.format("fetchIfNeeded(%s, %s)", file, path));
        if (path.startsWith(this.downloadDir)) {
            if (!file.exists()) {
                int split;
                String target = Utils.relativize(this.downloadDir, path);
                String source = target.substring(0, split = target.indexOf(File.separator));
                if (!this.urlMap.containsKey(source)) {
                    throw new InvalidPathException(path, "Cannot resolve the source of the hash: " + source);
                }
                try {
                    URL url = new URL(this.urlMap.get(source) + Utils.slashify(target.substring(split), false));
                    Utils.downloadTo(url, file);
                }
                catch (IOException e) {
                    throw new InvalidPathException(path, e.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
        LOGGER.trace((Object)String.format("checkAccess(%s)", path));
        if (VertxFileSystem.isFollowLinks(linkOptions)) {
            DELEGATE.checkAccess(path, modes.toArray(new AccessMode[0]));
        } else if (modes.isEmpty()) {
            DELEGATE.readAttributes(path, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
        } else {
            throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
        }
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        LOGGER.trace((Object)String.format("createDirectory(%s)", dir));
        DELEGATE.createDirectory(dir, attrs);
    }

    public void delete(Path path) throws IOException {
        LOGGER.trace((Object)String.format("delete(%s)", path));
        DELEGATE.delete(path);
    }

    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        LOGGER.trace((Object)String.format("copy(%s, %s)", source, target));
        DELEGATE.copy(source, target, options);
    }

    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        LOGGER.trace((Object)String.format("move(%s, %s)", source, target));
        DELEGATE.move(source, target, options);
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        LOGGER.trace((Object)String.format("newByteChannel(%s)", path));
        File file = path.toFile();
        if (file.isDirectory()) {
            file = this.resolveFile(file, "index");
        }
        return DELEGATE.newByteChannel(file.toPath(), options, attrs);
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        LOGGER.trace((Object)String.format("newDirectoryStream(%s)", dir));
        return DELEGATE.newDirectoryStream(dir, filter);
    }

    public void createLink(Path link, Path existing) throws IOException {
        LOGGER.trace((Object)String.format("createLink(%s)", link));
        DELEGATE.createLink(link, existing);
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        LOGGER.trace((Object)String.format("createSymbolicLink(%s)", link));
        DELEGATE.createSymbolicLink(link, target, attrs);
    }

    public Path readSymbolicLink(Path link) throws IOException {
        LOGGER.trace((Object)String.format("readSymbolicLink(%s)", link));
        return DELEGATE.readSymbolicLink(link);
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        LOGGER.trace((Object)String.format("readAttributes(%s)", path));
        return DELEGATE.readAttributes(path, attributes, options);
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        LOGGER.trace((Object)String.format("setAttribute(%s)", path));
        DELEGATE.setAttribute(path, attribute, value, options);
    }

    public Path toAbsolutePath(Path path) {
        LOGGER.trace((Object)String.format("toAbsolutePath(%s)", path));
        return path.toAbsolutePath();
    }

    public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
        throw new IllegalStateException("Changing Vert.x Current Working Directory is not allowed after startup.");
    }

    public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
        LOGGER.trace((Object)String.format("toRealPath(%s)", path));
        String name = path.toString();
        File file = this.vertx.resolveFile(Utils.relativize(this.cwd, name));
        boolean isDownloaded = this.fetchIfNeeded(file, name);
        if (!isDownloaded && !file.exists()) {
            file = this.resolveFile(file, null);
        }
        return file.toPath().toRealPath(linkOptions);
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (lo != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
        if (this.toAbsolutePath(path1).equals(this.toAbsolutePath(path2))) {
            return true;
        }
        return this.toRealPath(path1, options).equals(this.toRealPath(path2, options));
    }

    public Path getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir")).toPath();
    }
}

