/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Utils {
    static final MessageDigest MD5;

    private Utils() {
        throw new UnsupportedOperationException("Cannot instantiate Utils");
    }

    public static synchronized String md5(String input) {
        MD5.update(input.getBytes(StandardCharsets.UTF_8));
        byte[] bytes = MD5.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static void downloadTo(URL url, File target) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setRequestProperty("User-Agent", "es4x/pm");
        if (conn.getResponseCode() != 200) {
            throw new IOException(conn.getResponseMessage());
        }
        try (InputStream inputStream = conn.getInputStream();
             BufferedInputStream reader = new BufferedInputStream(inputStream);){
            File parent = target.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new RuntimeException("Failed to mkdirs: " + parent);
            }
            try (BufferedOutputStream writer = new BufferedOutputStream(Files.newOutputStream(target.toPath(), new OpenOption[0]));){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getManifestAttribute(String attribute) throws IOException {
        Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resEnum.hasMoreElements()) {
            URL url = resEnum.nextElement();
            try {
                InputStream is = url.openStream();
                try {
                    Manifest manifest;
                    Attributes mainAttribs;
                    String mode;
                    if (is == null || (mode = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue(attribute)) == null) continue;
                    String string = mode;
                    return string;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static URL fileToURL(File file) {
        try {
            return new URL("file://" + Utils.slashify(file.getPath(), file.isDirectory()));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot convert to URI: " + file, e);
        }
    }

    public static String slashify(String path, boolean isDirectory) {
        String p = path;
        if (File.separatorChar != '/') {
            p = p.replace(File.separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && isDirectory) {
            p = p + "/";
        }
        return p;
    }

    public static String toNixPath(String path) {
        if (File.separatorChar != '/') {
            path = path.replaceAll("^\\\\\\\\\\?\\\\", "");
            path = path.replace('\\', '/');
            if ((path = path.replaceAll("//+", "/")).length() > 1 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                path = "/" + path;
            }
        }
        return path;
    }

    static String relativize(String base, String fileName) {
        if (fileName.startsWith(base)) {
            int baseLen = base.length();
            if (fileName.length() == baseLen) {
                return "";
            }
            int sep = base.charAt(baseLen - 1) == File.separatorChar ? baseLen - 1 : baseLen;
            if (fileName.charAt(sep) == File.separatorChar) {
                return fileName.substring(sep + 1);
            }
        }
        return fileName;
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot instantiate MD5", e);
        }
    }
}

