/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.graalvm.polyglot.Value;

public class StructuredClone {
    public static Object cloneObject(Value oToBeCloned) {
        return StructuredClone.cloneObject(oToBeCloned, new HashMap<Object, Object>());
    }

    private static Object cloneObject(Value oToBeCloned, Map<Object, Object> dejaVu) {
        Object oClone;
        String fConstrName;
        if (oToBeCloned == null || oToBeCloned.isNull()) {
            return null;
        }
        if (dejaVu.containsKey(oToBeCloned)) {
            return dejaVu.get(oToBeCloned);
        }
        if (oToBeCloned.isNumber()) {
            return oToBeCloned.as(Number.class);
        }
        if (oToBeCloned.isBoolean()) {
            return oToBeCloned.asBoolean();
        }
        if (oToBeCloned.isString()) {
            return oToBeCloned.asString();
        }
        if (oToBeCloned.isDate()) {
            return oToBeCloned.asDate();
        }
        if (oToBeCloned.isDuration()) {
            return oToBeCloned.asDuration();
        }
        if (oToBeCloned.isInstant()) {
            return oToBeCloned.asInstant();
        }
        if (oToBeCloned.isTime()) {
            return oToBeCloned.asTime();
        }
        if (oToBeCloned.isTimeZone()) {
            return oToBeCloned.asTimeZone();
        }
        switch (fConstrName = StructuredClone.getConstructorName(oToBeCloned)) {
            case "Object": {
                oClone = new JsonObject();
                dejaVu.put(oToBeCloned, oClone);
                for (String key : oToBeCloned.getMemberKeys()) {
                    ((JsonObject)oClone).put(key, StructuredClone.cloneObject(oToBeCloned.getMember(key), dejaVu));
                }
                break;
            }
            case "Array": {
                oClone = new JsonArray();
                dejaVu.put(oToBeCloned, oClone);
                for (long l = 0L; l < oToBeCloned.getArraySize(); ++l) {
                    ((JsonArray)oClone).add(StructuredClone.cloneObject(oToBeCloned.getArrayElement(l), dejaVu));
                }
                break;
            }
            case "RegExp": {
                int flags = 0;
                if (oToBeCloned.getMember("global").asBoolean()) {
                    flags |= 0x20;
                }
                if (oToBeCloned.getMember("ignoreCase").asBoolean()) {
                    flags |= 2;
                }
                if (oToBeCloned.getMember("multiline").asBoolean()) {
                    flags |= 8;
                }
                oClone = flags != 0 ? Pattern.compile(oToBeCloned.getMember("source").asString(), flags) : Pattern.compile(oToBeCloned.getMember("source").asString());
                dejaVu.put(oToBeCloned, oClone);
                break;
            }
            case "ArrayBuffer": 
            case "EArrayBuffer": {
                oClone = StructuredClone.extractArrayBuffer(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                throw new IllegalStateException("ArrayBuffer not backed by j.n.ByteBuffer not allowed, use a TypedArray instead!");
            }
            case "Int8Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setByte(i, oToBeCloned.getArrayElement((long)i).asByte());
                }
                break;
            }
            case "Uint8Array": 
            case "Uint8ClampedArray": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setUnsignedByte(i, oToBeCloned.getArrayElement((long)i).asShort());
                }
                break;
            }
            case "Int16Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size * 2));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setShort(i, oToBeCloned.getArrayElement((long)i).asShort());
                }
                break;
            }
            case "Uint16Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size * 2));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setUnsignedShort(i, oToBeCloned.getArrayElement((long)i).asInt());
                }
                break;
            }
            case "Int32Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size * 4));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setInt(i, oToBeCloned.getArrayElement((long)i).asInt());
                }
                break;
            }
            case "Uint32Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size * 4));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setUnsignedInt(i, oToBeCloned.getArrayElement((long)i).asLong());
                }
                break;
            }
            case "Float32Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size * 4));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setFloat(i, oToBeCloned.getArrayElement((long)i).asFloat());
                }
                break;
            }
            case "Float64Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size * 8));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setDouble(i, oToBeCloned.getArrayElement((long)i).asDouble());
                }
                break;
            }
            case "BigInt64Array": 
            case "BigUint64Array": {
                oClone = StructuredClone.extractTypedArray(oToBeCloned);
                if (oClone != null) {
                    dejaVu.put(oToBeCloned, oClone);
                    break;
                }
                long size = oToBeCloned.getArraySize();
                oClone = Buffer.buffer((int)((int)size * 8));
                dejaVu.put(oToBeCloned, oClone);
                for (int i = 0; i < (int)size; ++i) {
                    ((Buffer)oClone).setLong(i, oToBeCloned.getArrayElement((long)i).asLong());
                }
                break;
            }
            case "Error": {
                oClone = new RuntimeException(oToBeCloned.getMember("message").asString());
                dejaVu.put(oToBeCloned, oClone);
                break;
            }
            default: {
                throw new IllegalStateException("Type not allowed: " + fConstrName);
            }
        }
        return oClone;
    }

    private static ByteBuffer extractArrayBuffer(Value arrayBuffer) {
        if (arrayBuffer == null || arrayBuffer.isNull()) {
            return null;
        }
        if (arrayBuffer.hasMember("__jbuffer")) {
            Value jbuffer = arrayBuffer.getMember("__jbuffer");
            if (jbuffer == null || jbuffer.isNull()) {
                return null;
            }
            return (ByteBuffer)jbuffer.as(ByteBuffer.class);
        }
        return null;
    }

    private static ByteBuffer extractTypedArray(Value typedArray) {
        ByteBuffer jbuffer = StructuredClone.extractArrayBuffer(typedArray.getMember("buffer"));
        if (jbuffer != null) {
            int offset = typedArray.getMember("byteOffset").asInt();
            int length = typedArray.getMember("byteLength").asInt();
            if (jbuffer.position() != offset || jbuffer.limit() != length) {
                jbuffer.position(offset).limit(length);
            }
            return jbuffer;
        }
        return null;
    }

    private static String getConstructorName(Value oToBeCloned) {
        Value fConstr;
        if (oToBeCloned.isProxyObject()) {
            if (oToBeCloned.hasArrayElements()) {
                return "Array";
            }
            if (oToBeCloned.hasMembers()) {
                return "Object";
            }
        }
        return (fConstr = oToBeCloned.getMember("constructor")) == null ? "undefined" : fConstr.getMember("name").asString();
    }
}

