/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.reactiverse.es4x.Runtime;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.parsetools.RecordParser;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;

public class REPLVerticle
extends AbstractVerticle {
    private static final AtomicBoolean ACTIVE = new AtomicBoolean(false);
    private final Logger log = LoggerFactory.getLogger(REPLVerticle.class);
    private final Runtime runtime;
    private final StringBuilder buffer = new StringBuilder();
    private RecordParser stdin;
    private boolean cancel = false;

    public REPLVerticle(Runtime runtime) {
        this.runtime = runtime;
    }

    private synchronized String updateBuffer(String line, boolean resetOrPrepend) {
        if (resetOrPrepend) {
            this.buffer.append(line);
            String statement = this.buffer.toString();
            this.buffer.setLength(0);
            return statement;
        }
        this.buffer.insert(0, line);
        return null;
    }

    public void start() {
        if (ACTIVE.compareAndSet(false, true)) {
            this.stdin = RecordParser.newDelimited((String)System.getProperty("line.separator"), line -> {
                String statement = this.updateBuffer(line.toString(Charset.defaultCharset()), true);
                if (statement == null || statement.length() == 0) {
                    return;
                }
                try {
                    Value parsed = this.runtime.parse(statement, true);
                    System.out.println("\u001b[1;90m" + parsed.execute(new Object[0]) + "\u001b[0m");
                }
                catch (PolyglotException t) {
                    if (t.isIncompleteSource()) {
                        this.updateBuffer(statement, false);
                        return;
                    }
                    System.out.println("\u001b[1m\u001b[31m" + t.getMessage() + "\u001b[0m");
                    if (t.isExit() || t.isResourceExhausted()) {
                        this.cancel = true;
                        ACTIVE.set(false);
                        this.vertx.close(v -> System.exit(1));
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                finally {
                    System.out.print("js:> ");
                    System.out.flush();
                }
            });
            String script = System.getProperty("script");
            if (script != null) {
                this.stdin.handle(Buffer.buffer((String)(script + System.getProperty("line.separator"))));
            } else {
                this.vertx.setTimer(100L, t -> {
                    System.out.print("js:> ");
                    System.out.flush();
                });
            }
            this.vertx.setPeriodic(100L, l -> {
                if (this.cancel) {
                    this.vertx.cancelTimer(l.longValue());
                    return;
                }
                try {
                    int available = System.in.available();
                    if (available > 0) {
                        byte[] data = new byte[available];
                        int bytes = System.in.read(data);
                        if (bytes == -1) {
                            this.cancel = true;
                            return;
                        }
                        if (bytes != available) {
                            byte[] tmp = new byte[bytes];
                            System.arraycopy(data, 0, tmp, 0, bytes);
                            data = tmp;
                        }
                        this.stdin.handle(Buffer.buffer((byte[])data));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.cancel = true;
                }
            });
        }
    }

    public void stop() {
        this.cancel = true;
        ACTIVE.set(false);
        System.out.println("\u001b[1mShell Terminated.\u001b[0m");
    }
}

