/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.vertx.core.Future;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyIterator;

public final class ProxyUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)ProxyUtil.class.getSimpleName());

    private static Object unwrapValue(Value v) {
        if (v == null) {
            return null;
        }
        return v.isHostObject() ? v.asHostObject() : v.as(Object.class);
    }

    public static void putMember(JsonObject self, String key, Value value) {
        self.put(key, ProxyUtil.unwrapValue(value));
    }

    public static boolean hasMember(JsonObject self, String key) {
        return self.containsKey(key);
    }

    public static Object getMemberKeys(final JsonObject self) {
        return new ProxyArray(){
            private final Object[] keys;
            {
                this.keys = self.fieldNames().toArray();
            }

            public void set(long index, Value value) {
                ProxyUtil.putMember(self, (String)this.get(index), value);
            }

            public long getSize() {
                return this.keys.length;
            }

            public Object get(long index) {
                if (index >= 0L && index <= Integer.MAX_VALUE) {
                    return this.keys[(int)index];
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        };
    }

    public static Object getMember(JsonObject self, String key) {
        return ProxyUtil.wrapJsonValue(self.getMap().get(key));
    }

    public static boolean removeMember(JsonObject self, String key) {
        if (self.containsKey(key)) {
            self.remove(key);
            return true;
        }
        return false;
    }

    public static Object get(JsonArray self, long index) {
        ProxyUtil.checkIndex(index);
        return ProxyUtil.wrapJsonValue(self.getList().get((int)index));
    }

    public static void set(JsonArray self, long index, Value value) {
        ProxyUtil.checkIndex(index);
        if ((long)self.size() <= index) {
            self.add((int)index, ProxyUtil.unwrapValue(value));
        } else {
            self.set((int)index, ProxyUtil.unwrapValue(value));
        }
    }

    private static void checkIndex(long index) {
        if (index > Integer.MAX_VALUE || index < 0L) {
            throw new ArrayIndexOutOfBoundsException("invalid index.");
        }
    }

    public static long getSize(JsonArray self) {
        return self.size();
    }

    public static boolean remove(JsonArray self, long index) {
        ProxyUtil.checkIndex(index);
        if (index < 0L || index >= (long)self.size()) {
            return false;
        }
        self.remove((int)index);
        return true;
    }

    public static Object getIterator(final JsonArray self) {
        return new ProxyIterator(){
            final Iterator<?> it;
            {
                this.it = self.iterator();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object getNext() throws NoSuchElementException, UnsupportedOperationException {
                return this.it.next();
            }
        };
    }

    public static void then(Future<?> self, Value onFulfilled, Value onRejected) {
        self.onComplete(ar -> {
            if (ar.succeeded()) {
                if (onFulfilled != null) {
                    onFulfilled.executeVoid(new Object[]{ar.result()});
                } else {
                    LOG.warn((Object)("Possible Unhandled Promise: " + self));
                }
            } else if (onRejected != null) {
                onRejected.execute(new Object[]{ar.cause()});
            } else {
                LOG.warn((Object)("Possible Unhandled Rejection: " + self));
            }
        });
    }

    private static Object wrapJsonValue(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        } else if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return val;
    }
}

