/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.reactiverse.es4x.ESVerticleFactory;
import io.reactiverse.es4x.Runtime;
import io.reactiverse.es4x.impl.ESModuleIO;
import io.vertx.core.Context;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import java.io.File;
import java.nio.file.InvalidPathException;
import org.graalvm.polyglot.Source;

public final class MJSVerticleFactory
extends ESVerticleFactory {
    public String prefix() {
        return "mjs";
    }

    @Override
    protected Verticle createVerticle(final Runtime runtime, final String fsVerticleName) {
        return new Verticle(){
            private Vertx vertx;
            private Context context;

            public Vertx getVertx() {
                return this.vertx;
            }

            public void init(Vertx vertx, Context context) {
                this.vertx = vertx;
                this.context = context;
            }

            public void start(Promise<Void> startPromise) {
                boolean worker;
                String address;
                if (this.context != null) {
                    address = this.context.deploymentID();
                    worker = this.context.isWorkerContext();
                    if (this.context.config() != null) {
                        runtime.config(this.context.config());
                    }
                } else {
                    worker = false;
                    address = null;
                }
                try {
                    if (worker) {
                        runtime.put("self", runtime.eval(Source.create((String)"js", (CharSequence)"this")));
                        MJSVerticleFactory.this.setupVerticleMessaging(runtime, this.vertx, address);
                    } else {
                        runtime.put("global", runtime.eval(Source.create((String)"js", (CharSequence)"this")));
                    }
                    try {
                        Buffer buffer = this.vertx.fileSystem().readFileBlocking(fsVerticleName);
                        Source source = Source.newBuilder((String)"js", (File)new File(fsVerticleName)).content(ESModuleIO.stripShebang(buffer.toString())).cached(true).interactive(false).mimeType("application/javascript+module").buildLiteral();
                        runtime.eval(source);
                        MJSVerticleFactory.this.waitFor(runtime, (ContextInternal)this.context, "deploy").onComplete(startPromise);
                    }
                    catch (InvalidPathException e) {
                        startPromise.fail("File Not Found: " + fsVerticleName);
                    }
                    catch (RuntimeException e) {
                        startPromise.fail((Throwable)e);
                    }
                }
                catch (RuntimeException e) {
                    startPromise.fail((Throwable)e);
                }
            }

            public void stop(Promise<Void> stopPromise) {
                MJSVerticleFactory.this.waitFor(runtime, (ContextInternal)this.context, "undeploy").onComplete(stopPromise).onSuccess(v -> {
                    try {
                        runtime.close();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                });
            }
        };
    }

    @Override
    protected String[] defaultExtensions() {
        return new String[]{".mjs", ".js"};
    }
}

