/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.reactiverse.es4x.ESVerticleFactory;
import io.reactiverse.es4x.Runtime;
import io.vertx.core.Context;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.net.URL;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public final class JSVerticleFactory
extends ESVerticleFactory {
    public String prefix() {
        return "js";
    }

    @Override
    protected Verticle createVerticle(final Runtime runtime, final String fsVerticleName) {
        final Value module = runtime.eval(Source.newBuilder((String)"js", (URL)JSVerticleFactory.class.getResource("/io/reactiverse/es4x/jvm-npm.js")).buildLiteral());
        return new Verticle(){
            private Vertx vertx;
            private Context context;

            public Vertx getVertx() {
                return this.vertx;
            }

            public void init(Vertx vertx, Context context) {
                this.vertx = vertx;
                this.context = context;
            }

            public void start(Promise<Void> startPromise) {
                boolean worker;
                String address;
                if (this.context != null) {
                    address = this.context.deploymentID();
                    worker = this.context.isWorkerContext();
                    if (this.context.config() != null) {
                        runtime.config(this.context.config());
                    }
                } else {
                    worker = false;
                    address = null;
                }
                try {
                    if (worker) {
                        runtime.put("self", runtime.eval(Source.create((String)"js", (CharSequence)"this")));
                        JSVerticleFactory.this.setupVerticleMessaging(runtime, this.vertx, address);
                    } else {
                        runtime.put("global", runtime.eval(Source.create((String)"js", (CharSequence)"this")));
                    }
                    try {
                        module.invokeMember("runMain", new Object[]{fsVerticleName});
                        JSVerticleFactory.this.waitFor(runtime, (ContextInternal)this.context, "deploy").onComplete(startPromise);
                    }
                    catch (RuntimeException e) {
                        startPromise.fail((Throwable)e);
                    }
                }
                catch (RuntimeException e) {
                    startPromise.fail((Throwable)e);
                }
            }

            public void stop(Promise<Void> stopPromise) {
                JSVerticleFactory.this.waitFor(runtime, (ContextInternal)this.context, "undeploy").onComplete(stopPromise).onSuccess(v -> {
                    try {
                        runtime.close();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                });
            }
        };
    }

    @Override
    protected String[] defaultExtensions() {
        return new String[]{".js"};
    }
}

