/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.reactiverse.es4x.impl.StructuredClone;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.graalvm.polyglot.Value;

public final class JSObjectMessageCodec
implements MessageCodec<Object, Object> {
    private final String codecName;

    public JSObjectMessageCodec(String codecName) {
        this.codecName = codecName;
    }

    public Object decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        pos += 4;
        if (length == 0) {
            return null;
        }
        byte b = buffer.getByte(pos);
        if (b == 123) {
            return new JsonObject(buffer.getBuffer(pos, pos + length));
        }
        if (b == 91) {
            return new JsonArray(buffer.getBuffer(pos, pos + length));
        }
        throw new ClassCastException("type is not Object or Array");
    }

    public String name() {
        return this.codecName;
    }

    public byte systemCodecID() {
        return -1;
    }

    public void encodeToWire(Buffer buffer, Object jsObject) {
        if (jsObject == null) {
            buffer.appendInt(0);
            return;
        }
        Buffer encoded = Json.encodeToBuffer((Object)StructuredClone.cloneObject(Value.asValue((Object)jsObject)));
        buffer.appendInt(encoded.length());
        buffer.appendBuffer(encoded);
    }

    public Object transform(Object jsObject) {
        if (jsObject == null) {
            return null;
        }
        return StructuredClone.cloneObject(Value.asValue((Object)jsObject));
    }
}

