/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.reactiverse.es4x.impl.UnmappedBareSpecifierException;
import io.reactiverse.es4x.impl.Utils;
import io.reactiverse.es4x.impl.VertxFileSystem;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ImportMapper {
    private final Map<String, URL> imports;
    private final Map<String, Map<String, URL>> scopes;
    private final URL baseURL;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportMapper.class);
    private static final Set<String> specialProtocols = new HashSet<String>(Arrays.asList("ftp", "file", "http", "https", "ws", "wss"));

    public ImportMapper(JsonObject config) throws MalformedURLException {
        this(config, new URL("file", "", Utils.slashify(VertxFileSystem.getCWD(), true)));
    }

    public ImportMapper(JsonObject config, URL baseURL) {
        this.imports = config.containsKey("imports") ? this.sortAndNormalizeSpecifierMap(config.getJsonObject("imports"), baseURL) : Collections.emptyMap();
        this.scopes = config.containsKey("scopes") ? this.sortAndNormalizeScopes(config.getJsonObject("scopes"), baseURL) : Collections.emptyMap();
        this.baseURL = baseURL;
    }

    public URI resolve(String specifier) throws UnmappedBareSpecifierException, URISyntaxException {
        URL resolved = this.resolve(specifier, this.baseURL);
        URI uri = resolved.toURI();
        if ("".equals(uri.getPath())) {
            return new URI(uri.getScheme(), uri.getAuthority(), "/", uri.getFragment());
        }
        return uri;
    }

    public URI resolve(String specifier, String referrer) throws MalformedURLException, UnmappedBareSpecifierException, URISyntaxException {
        URL resolved = this.resolve(specifier, new URL(this.baseURL, referrer));
        URI uri = resolved.toURI();
        if ("".equals(uri.getPath())) {
            return new URI(uri.getScheme(), uri.getAuthority(), "/", uri.getFragment());
        }
        return uri;
    }

    public URL resolve(String specifier, URL scriptURL) throws UnmappedBareSpecifierException {
        String posixSpecifier = Utils.toNixPath(specifier);
        URL asURL = ImportMapper.tryURLLikeSpecifierParse(posixSpecifier, scriptURL);
        String normalizedSpecifier = asURL != null ? ImportMapper.href(asURL) : posixSpecifier;
        String scriptURLString = ImportMapper.href(scriptURL);
        for (Map.Entry<String, Map<String, URL>> kv : this.scopes.entrySet()) {
            URL scopeImportsMatch;
            String scopePrefix = kv.getKey();
            Map<String, URL> scopeImports = kv.getValue();
            if (!scopePrefix.equals(scriptURLString) && (!scopePrefix.endsWith("/") || !scriptURLString.startsWith(scopePrefix)) || (scopeImportsMatch = this.resolveImportsMatch(normalizedSpecifier, asURL, scopeImports)) == null) continue;
            return scopeImportsMatch;
        }
        URL topLevelImportsMatch = this.resolveImportsMatch(normalizedSpecifier, asURL, this.imports);
        if (topLevelImportsMatch != null) {
            return topLevelImportsMatch;
        }
        if (asURL != null) {
            return asURL;
        }
        throw new UnmappedBareSpecifierException(specifier);
    }

    private Map<String, URL> sortAndNormalizeSpecifierMap(JsonObject obj, URL baseURL) {
        HashMap<String, URL> normalized = new HashMap<String, URL>();
        for (Map.Entry kv : obj) {
            String normalizedSpecifierKey = ImportMapper.normalizeSpecifierKey((String)kv.getKey(), baseURL);
            if (normalizedSpecifierKey == null) continue;
            if (!(kv.getValue() instanceof String)) {
                LOGGER.warn((Object)("Invalid address " + kv.getValue() + " for the specifier key " + (String)kv.getKey() + ". Addresses must be strings."));
                normalized.put(normalizedSpecifierKey, null);
                continue;
            }
            URL addressURL = ImportMapper.tryURLLikeSpecifierParse((String)kv.getValue(), baseURL);
            if (addressURL == null) {
                LOGGER.warn((Object)("Invalid address " + kv.getValue() + " for the specifier key " + (String)kv.getKey() + "."));
                normalized.put(normalizedSpecifierKey, null);
                continue;
            }
            if (((String)kv.getKey()).endsWith("/") && !ImportMapper.href(addressURL).endsWith("/")) {
                LOGGER.warn((Object)("Invalid address " + ImportMapper.href(addressURL) + " for package specifier key " + (String)kv.getKey() + ". Package addresses must end with \"/\"."));
                normalized.put(normalizedSpecifierKey, null);
                continue;
            }
            normalized.put(normalizedSpecifierKey, addressURL);
        }
        return new TreeMap<String, URL>(normalized);
    }

    private Map<String, Map<String, URL>> sortAndNormalizeScopes(JsonObject obj, URL baseURL) {
        HashMap<String, Map<String, URL>> normalized = new HashMap<String, Map<String, URL>>();
        for (Map.Entry kv : obj) {
            if (!(kv.getValue() instanceof JsonObject)) {
                throw new RuntimeException("The value for the " + (String)kv.getKey() + " scope prefix must be an object.");
            }
            URL scopePrefixURL = ImportMapper.tryURLParse((String)kv.getKey(), baseURL);
            if (scopePrefixURL == null) {
                LOGGER.warn((Object)("Invalid scope " + (String)kv.getKey() + " (parsed against base URL " + baseURL + ")."));
                continue;
            }
            String normalizedScopePrefix = ImportMapper.href(scopePrefixURL);
            normalized.put(normalizedScopePrefix, this.sortAndNormalizeSpecifierMap((JsonObject)kv.getValue(), baseURL));
        }
        return new TreeMap<String, Map<String, URL>>(normalized);
    }

    private static String normalizeSpecifierKey(String specifierKey, URL baseURL) {
        if ("".equals(specifierKey)) {
            LOGGER.warn((Object)"Invalid empty string specifier key.");
            return null;
        }
        URL url = ImportMapper.tryURLLikeSpecifierParse(specifierKey, baseURL);
        if (url != null) {
            return ImportMapper.href(url);
        }
        return specifierKey;
    }

    private static URL tryURLParse(String string, URL baseURL) {
        try {
            if (baseURL != null) {
                return new URL(baseURL, string);
            }
            return new URL(string);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private URL resolveImportsMatch(String normalizedSpecifier, URL asURL, Map<String, URL> specifierMap) {
        for (Map.Entry<String, URL> kv : specifierMap.entrySet()) {
            String specifierKey = kv.getKey();
            URL resolutionResult = kv.getValue();
            if (specifierKey.equals(normalizedSpecifier)) {
                if (resolutionResult == null) {
                    throw new RuntimeException("Blocked by a null entry for " + specifierKey);
                }
                return resolutionResult;
            }
            if (!specifierKey.endsWith("/") || !normalizedSpecifier.startsWith(specifierKey) || asURL != null && !ImportMapper.isSpecial(asURL)) continue;
            if (resolutionResult == null) {
                throw new RuntimeException("Blocked by a null entry for " + specifierKey);
            }
            String afterPrefix = normalizedSpecifier.substring(specifierKey.length());
            assert (ImportMapper.href(resolutionResult).endsWith("/"));
            URL url = ImportMapper.tryURLParse(afterPrefix, resolutionResult);
            if (url == null) {
                throw new RuntimeException("Failed to resolve prefix - match relative URL for " + specifierKey);
            }
            return url;
        }
        return null;
    }

    private static URL tryURLLikeSpecifierParse(String specifier, URL baseURL) {
        if (specifier.startsWith("/") || specifier.startsWith("./") || specifier.startsWith("../")) {
            return ImportMapper.tryURLParse(specifier, baseURL);
        }
        return ImportMapper.tryURLParse(specifier, null);
    }

    private static boolean isSpecial(URL url) {
        return specialProtocols.contains(url.getProtocol());
    }

    private static String href(URL url) {
        String file;
        StringBuilder sb = new StringBuilder();
        sb.append(url.getProtocol());
        sb.append("://");
        String authority = url.getAuthority();
        if (authority != null) {
            sb.append(authority);
        }
        if ((file = url.getFile()) != null) {
            if ("".equals(file)) {
                sb.append("/");
            } else {
                sb.append(url.getFile());
            }
        }
        return sb.toString();
    }
}

