/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ESModuleIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ESModuleIO.class);
    private static final Pattern importDef = Pattern.compile("import (\\* as [a-zA-Z_$][0-9a-zA-Z_$]*|\\{.+?}|[a-zA-Z_$][0-9a-zA-Z_$]*(\\s*,\\s*\\{.+?})?) from ['\"]([0-9a-zA-Z_$@./\\- ]+)['\"];?", 32);
    private static final Pattern exportDef = Pattern.compile("\\{(.+?)}", 32);
    private static final Pattern aliasDef = Pattern.compile("(\\*|[a-zA-Z_$][0-9a-zA-Z_$]*) as ([a-zA-Z_$][0-9a-zA-Z_$]*)", 32);
    private static final Pattern defaultDef = Pattern.compile("[a-zA-Z_$][0-9a-zA-Z_$]*(\\s*,\\s*\\{.+?})?", 32);
    private static final Pattern exportPattern = Pattern.compile("export (default|\\{(.+?)})", 32);
    private final FileSystem fs;

    private static String replace(String source, Pattern pattern, Function<Matcher, String> fn) {
        Matcher m = pattern.matcher(source);
        boolean result = m.find();
        if (result) {
            StringBuilder sb = new StringBuilder(source.length());
            int p = 0;
            do {
                sb.append(source, p, m.start());
                sb.append(fn.apply(m));
                p = m.end();
            } while (m.find());
            sb.append(source, p, source.length());
            return sb.toString();
        }
        return source;
    }

    public static String adapt(String statement) {
        statement = ESModuleIO.replace(statement, importDef, importMatcher -> {
            Matcher exportMatcher;
            LOGGER.debug((Object)importMatcher.group(0));
            String exports = importMatcher.group(1).trim();
            String module = importMatcher.group(2);
            if (importMatcher.groupCount() > 2) {
                module = importMatcher.group(3);
            }
            StringBuilder sb = new StringBuilder();
            int idx = exports.indexOf(",");
            if (idx > 0 && exports.indexOf("{") > idx) {
                String def = exports.substring(0, idx);
                exports = exports.substring(idx + 1).trim();
                sb.append("const " + def + " = require('" + module + "').default;");
            }
            if ((exportMatcher = exportDef.matcher(exports)).find()) {
                String[] multi;
                for (String single : multi = exportMatcher.group(1).split("\\s*,\\s*")) {
                    sb.append(ESModuleIO.adaptImport(single.trim(), module));
                }
            } else {
                Matcher aliasMatcher = aliasDef.matcher(exports);
                if (aliasMatcher.find()) {
                    sb.append(ESModuleIO.adaptImport(exports.trim(), module));
                } else {
                    Matcher defaultMatcher = defaultDef.matcher(exports);
                    if (defaultMatcher.find()) {
                        sb.append("const " + exports + " = require('" + module + "').default;");
                    } else {
                        sb.append(ESModuleIO.adaptImport(exports.trim(), module));
                    }
                }
            }
            for (int i = 0; i < exports.length(); ++i) {
                if (exports.charAt(i) != '\r' && exports.charAt(i) != '\n') continue;
                sb.append(exports.charAt(i));
            }
            return sb.toString();
        });
        return ESModuleIO.replace(statement, exportPattern, matcher -> {
            String exports = matcher.group(1);
            Matcher exportMatcher = exportDef.matcher(exports);
            StringBuilder sb = new StringBuilder();
            if (exportMatcher.find()) {
                String[] multi;
                for (String single : multi = exportMatcher.group(1).split("\\s*,\\s*")) {
                    sb.append(ESModuleIO.adaptExport(single.trim()) + ";");
                }
            } else {
                sb.append("module.exports.default =");
            }
            for (int i = 0; i < exports.length(); ++i) {
                if (exports.charAt(i) != '\r' && exports.charAt(i) != '\n') continue;
                sb.append(exports.charAt(i));
            }
            return sb.toString();
        });
    }

    private static String adaptImport(String exports, String module) {
        Matcher aliasMatcher = aliasDef.matcher(exports);
        if (aliasMatcher.find()) {
            String base = aliasMatcher.group(1).trim();
            String alias = aliasMatcher.group(2).trim();
            if ("*".equals(base)) {
                return "const " + alias + " = require('" + module + "');";
            }
            return "const " + alias + " = require('" + module + "')." + base + ";";
        }
        return "const " + exports + " = require('" + module + "')." + exports + ";";
    }

    private static String adaptExport(String exports) {
        Matcher aliasMatcher = aliasDef.matcher(exports);
        if (aliasMatcher.find()) {
            String base = aliasMatcher.group(1).trim();
            String alias = aliasMatcher.group(2).trim();
            return "module.exports." + alias + " = " + base;
        }
        return "module.exports." + exports + " = " + exports;
    }

    public ESModuleIO(Vertx vertx) {
        this.fs = vertx.fileSystem();
    }

    public String getParent(String uri) throws URISyntaxException {
        switch (uri) {
            case "jar:": 
            case "file:": {
                throw new RuntimeException("Cannot get parent of root.");
            }
        }
        return this.getParent(new URI(uri));
    }

    public String getParent(URI uri) {
        String path = uri.getPath();
        int last = path.lastIndexOf(47);
        if (path.length() > last) {
            return uri.getScheme() + ':' + path.substring(0, last);
        }
        throw new RuntimeException("Cannot get parent of root.");
    }

    public boolean exists(URI uri) {
        if (uri == null) {
            return false;
        }
        switch (uri.getScheme()) {
            case "jar": {
                return this.fs.existsBlocking(uri.getPath().substring(1));
            }
            case "file": {
                return this.fs.existsBlocking(uri.getPath());
            }
        }
        return false;
    }

    public boolean isFile(URI uri) {
        switch (uri.getScheme()) {
            case "jar": {
                return this.fs.propsBlocking(uri.getPath().substring(1)).isRegularFile();
            }
            case "file": {
                return this.fs.propsBlocking(uri.getPath()).isRegularFile();
            }
        }
        return false;
    }

    public String readFile(URI uri) throws IOException {
        return this.readFile(uri, false);
    }

    public String readFile(URI uri, boolean main) throws IOException {
        return this.readFile(uri, main, true);
    }

    public String readFile(URI uri, boolean main, boolean adapt) throws IOException {
        Buffer buffer;
        switch (uri.getScheme()) {
            case "jar": {
                buffer = this.fs.readFileBlocking(uri.getPath().substring(1));
                break;
            }
            case "file": {
                buffer = this.fs.readFileBlocking(uri.getPath());
                break;
            }
            default: {
                throw new IOException("Cannot handle scheme [" + uri.getScheme() + "]");
            }
        }
        String content = main ? ESModuleIO.stripShebang(buffer.toString()) : ESModuleIO.stripBOM(buffer.toString());
        if (adapt) {
            return ESModuleIO.adapt(content);
        }
        return content;
    }

    public static String stripShebang(String content) {
        int contLen = content.length();
        if (contLen >= 2 && content.charAt(0) == '#' && content.charAt(1) == '!') {
            if (contLen == 2) {
                content = "";
            } else {
                char code;
                int i;
                for (i = 2; i < contLen && (code = content.charAt(i)) != '\n' && code != '\r'; ++i) {
                }
                content = i == contLen ? "" : content.substring(i);
            }
        }
        return content;
    }

    public static String stripBOM(String content) {
        if (content != null && content.length() > 0 && content.charAt(0) == '\ufeff') {
            content = content.substring(1);
        }
        return content;
    }
}

