/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.impl;

import io.vertx.core.AsyncResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AsyncError {
    private static final Pattern CRLF = Pattern.compile("\\r?\\n");
    private static final Pattern STACKTRACE = Pattern.compile("at (<?.+?>? )?\\(?(.+?):(\\d+)(:\\d+)?\\)?");

    private AsyncError() throws IllegalAccessException {
        throw new IllegalAccessException("Not Instantiable");
    }

    private static Throwable combine(Throwable throwable, String[] jsAsyncStackLine) {
        int len = jsAsyncStackLine.length - 2;
        if (len >= 0) {
            StackTraceElement[] stack = throwable.getStackTrace();
            if (stack != null) {
                StackTraceElement[] nstack = new StackTraceElement[stack.length + len];
                for (int i = 0; i < len; ++i) {
                    nstack[i] = AsyncError.parseStrackTraceElement(jsAsyncStackLine[2 + i]);
                }
                System.arraycopy(stack, 0, nstack, len, stack.length);
                throwable.setStackTrace(nstack);
            } else {
                StackTraceElement[] nstack = new StackTraceElement[1];
                for (int i = 0; i < len; ++i) {
                    nstack[i] = AsyncError.parseStrackTraceElement(jsAsyncStackLine[2 + i]);
                }
                throwable.setStackTrace(nstack);
            }
        }
        return throwable;
    }

    public static Throwable combine(Throwable throwable, String jsAsyncStackLines) {
        if (jsAsyncStackLines == null) {
            return throwable;
        }
        return AsyncError.combine(throwable, CRLF.split(jsAsyncStackLines));
    }

    public static <T> Throwable combine(AsyncResult<T> asyncResult, String jsAsyncStackLines) {
        if (jsAsyncStackLines == null) {
            return asyncResult.cause();
        }
        return AsyncError.combine(asyncResult.cause(), CRLF.split(jsAsyncStackLines));
    }

    public static String combine(String currentStackLines, String asyncStackLines) {
        String[] current = CRLF.split(currentStackLines);
        String[] async = CRLF.split(asyncStackLines);
        int len = async.length - 2;
        if (len >= 0) {
            CharSequence[] full = new String[current.length + len + 1];
            full[0] = current[0];
            System.arraycopy(async, 2, full, 1, len);
            full[len + 1] = "Async Stacktrace:";
            System.arraycopy(current, 1, full, len + 2, current.length - 1);
            return String.join((CharSequence)System.lineSeparator(), full);
        }
        return currentStackLines;
    }

    public static StackTraceElement parseStrackTraceElement(String element) {
        Matcher matcher;
        String methodName = null;
        String filename = "";
        int lineNumber = 0;
        if (element != null && (matcher = STACKTRACE.matcher(element)).find()) {
            methodName = matcher.group(1);
            filename = matcher.group(2);
            try {
                lineNumber = Integer.parseInt(matcher.group(3));
            }
            catch (NumberFormatException e) {
                lineNumber = -1;
            }
        }
        return new StackTraceElement("<async>", methodName == null ? "<error>" : methodName, filename, lineNumber);
    }
}

