/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x;

import io.reactiverse.es4x.impl.EventEmitterImpl;
import io.reactiverse.es4x.impl.VertxFileSystem;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public final class Runtime
extends EventEmitterImpl {
    private final Context context;
    private final Value bindings;

    Runtime(Vertx vertx, final Context context, Source ... scripts) {
        this.context = context;
        this.bindings = this.context.getBindings("js");
        for (String identifier : Arrays.asList("exit", "quit", "Packages", "java", "javafx", "javax", "com", "org", "edu")) {
            if (!this.bindings.hasMember(identifier)) continue;
            this.bindings.removeMember(identifier);
        }
        this.bindings.putMember("vertx", (Object)vertx);
        final File cwd = new File(VertxFileSystem.getCWD());
        this.bindings.putMember("load", (Object)new Function<Object, Value>(){

            @Override
            public synchronized Value apply(Object value) {
                try {
                    Source source;
                    if (value instanceof String) {
                        try {
                            return this.apply(new URL((String)value));
                        }
                        catch (MalformedURLException murle) {
                            return this.apply(new File((String)value));
                        }
                    }
                    if (value instanceof URL) {
                        source = Source.newBuilder((String)"js", (URL)((URL)value)).build();
                    } else if (value instanceof File) {
                        source = Source.newBuilder((String)"js", (File)((File)value)).build();
                    } else if (value instanceof Map) {
                        String script = (String)((Map)value).get("script");
                        String name = (String)((Map)value).get("name");
                        if (name != null && name.length() > 0) {
                            URI uri = name.charAt(0) != '/' ? new File(cwd, name).toURI() : new File(name).toURI();
                            source = Source.newBuilder((String)"js", (CharSequence)script, (String)uri.getPath()).uri(uri).build();
                        } else {
                            source = Source.newBuilder((String)"js", (CharSequence)script, (String)"<module-wrapper>").cached(false).build();
                        }
                    } else {
                        throw new RuntimeException("TypeError: cannot load [" + value.getClass() + "]");
                    }
                    return context.eval(source);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.bindings.putMember("verticle", (Object)this);
        if (scripts != null) {
            for (Source script : scripts) {
                context.eval(script);
            }
        }
        this.bindings.removeMember("verticle");
    }

    public void config(JsonObject config) {
        if (config != null) {
            this.bindings.putMember("config", (Object)config);
        }
    }

    public Value eval(String script, String name, String contentType, boolean interactive) {
        Source source = Source.newBuilder((String)"js", (CharSequence)script, (String)name).interactive(interactive).mimeType(contentType).buildLiteral();
        return this.context.eval(source);
    }

    public Value eval(Source source) {
        return this.context.eval(source);
    }

    public void put(String name, Object value) {
        this.bindings.putMember(name, value);
    }

    public Value get(String name) {
        return this.bindings.getMember(name);
    }

    public void close() {
        this.context.close();
    }

    public Value eval(String script, boolean interactive) {
        return this.eval(script, "<eval>", interactive);
    }

    public Value parse(String script, boolean interactive) {
        return this.parse(script, "application/javascript", interactive);
    }

    public Value parse(String script, String contentType, boolean interactive) {
        return this.context.parse(Source.newBuilder((String)"js", (CharSequence)script, (String)"<eval>").interactive(interactive).mimeType(contentType).buildLiteral());
    }

    public Value eval(String script, String name, boolean literal) {
        if (name.endsWith(".mjs")) {
            return this.eval(script, name, "application/javascript+module", literal);
        }
        return this.eval(script, name, "application/javascript", literal);
    }

    public Value eval(String script) {
        return this.eval(script, false);
    }
}

