/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x;

import io.reactiverse.es4x.ECMAEngine;
import io.reactiverse.es4x.Runtime;
import io.reactiverse.es4x.impl.REPLVerticle;
import io.reactiverse.es4x.impl.StructuredClone;
import io.reactiverse.es4x.impl.Utils;
import io.reactiverse.es4x.impl.VertxFileSystem;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.VerticleFactory;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.FileSystem;

public abstract class ESVerticleFactory
implements VerticleFactory {
    protected ECMAEngine engine;
    private Vertx vertx;

    public synchronized void init(Vertx vertx) {
        if (this.engine != null) {
            throw new IllegalStateException("Engine already initialized");
        }
        this.vertx = vertx;
        this.engine = new ECMAEngine(vertx);
    }

    public int order() {
        return -1;
    }

    protected Runtime createRuntime(ECMAEngine engine) {
        return engine.newContext(this.createFileSystem(), Source.newBuilder((String)"js", (URL)ESVerticleFactory.class.getResource("polyfill/global.js")).buildLiteral(), Source.newBuilder((String)"js", (URL)ESVerticleFactory.class.getResource("polyfill/date.js")).buildLiteral(), Source.newBuilder((String)"js", (URL)ESVerticleFactory.class.getResource("polyfill/console.js")).buildLiteral(), Source.newBuilder((String)"js", (URL)ESVerticleFactory.class.getResource("polyfill/worker.js")).buildLiteral(), Source.newBuilder((String)"js", (URL)ESVerticleFactory.class.getResource("polyfill/arraybuffer.js")).buildLiteral(), Source.newBuilder((String)"js", (URL)ESVerticleFactory.class.getResource("polyfill/async-error.js")).buildLiteral());
    }

    private FileSystem createFileSystem() {
        try {
            return new VertxFileSystem(this.vertx, Utils.getManifestAttribute("Import-Map"), this.defaultExtensions());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the file system", e);
        }
    }

    protected abstract Verticle createVerticle(Runtime var1, String var2);

    protected abstract String[] defaultExtensions();

    public final void createVerticle(String verticleName, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
        String strippedName = Utils.toNixPath(VerticleFactory.removePrefix((String)verticleName));
        if (">".equals(strippedName)) {
            promise.complete(() -> {
                Runtime runtime = this.createRuntime(this.engine);
                return new REPLVerticle(runtime);
            });
        } else {
            promise.complete(() -> {
                Runtime runtime = this.createRuntime(this.engine);
                return this.createVerticle(runtime, this.mainScript(strippedName));
            });
        }
    }

    protected void setupVerticleMessaging(Runtime runtime, Vertx vertx, String address) {
        Value undefined = runtime.eval("[undefined]").getArrayElement(0L);
        runtime.put("postMessage", arguments -> {
            vertx.eventBus().send(address + ".in", StructuredClone.cloneObject(arguments[0]));
            return undefined;
        });
        vertx.eventBus().consumer(address + ".out", msg -> {
            Value onmessage = runtime.get("onmessage");
            if (onmessage != null && onmessage.canExecute()) {
                onmessage.executeVoid(new Object[]{msg.body()});
            }
        });
    }

    private String mainScript(String fsVerticleName) {
        String main = fsVerticleName;
        if (fsVerticleName.equals(".") || fsVerticleName.equals("..")) {
            main = fsVerticleName + "/";
        } else if (!fsVerticleName.startsWith("./") && !fsVerticleName.startsWith("/")) {
            main = "./" + fsVerticleName;
        }
        return main;
    }

    protected final Future<Void> waitFor(Runtime runtime, ContextInternal context, String callback) {
        PromiseInternal wrapper = context.promise();
        try {
            if (runtime.emit(callback, wrapper) == 0) {
                wrapper.complete();
            }
        }
        catch (RuntimeException e) {
            wrapper.fail((Throwable)e);
        }
        return wrapper.future();
    }

    public void close() {
        if (this.engine != null) {
            this.engine.close();
            this.vertx = null;
        }
    }
}

