/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x;

import io.vertx.core.Launcher;
import io.vertx.core.VertxOptions;
import java.io.File;
import java.util.function.Consumer;

public final class ES4X
extends Launcher {
    public void beforeStartingVertx(VertxOptions options) {
        ES4X.processProperty("inspect", inspect -> {
            System.setProperty("polyglot.inspect", inspect);
            System.setProperty("polyglot.inspect.Suspend", "false");
            options.setBlockedThreadCheckInterval(1000000L);
        });
        ES4X.processProperty("inspect-brk", inspect -> {
            System.setProperty("polyglot.inspect", inspect);
            System.setProperty("polyglot.inspect.Suspend", "true");
            options.setBlockedThreadCheckInterval(1000000L);
        });
    }

    public static void main(String ... args) {
        ES4X launcher = new ES4X();
        if (args != null && args.length > 0 && "--compgen".equals(args[0])) {
            String prefix = args.length == 2 ? args[1] : null;
            for (String name : launcher.commandByName.keySet()) {
                if (prefix != null && !name.startsWith(prefix)) continue;
                System.out.println(name);
            }
            System.exit(3);
            return;
        }
        if (args != null && args.length == 1) {
            boolean isFileOrDir;
            try {
                isFileOrDir = new File(args[0]).exists();
            }
            catch (SecurityException e) {
                isFileOrDir = false;
            }
            if (isFileOrDir) {
                try {
                    launcher.execute("run", args);
                }
                catch (NoClassDefFoundError e) {
                    System.err.println("'node_modules' jars missing and/or wrong versions. Removing 'node_modules' may solve the problem.");
                    System.exit(1);
                }
                return;
            }
        }
        try {
            launcher.dispatch(args);
        }
        catch (NoClassDefFoundError e) {
            System.err.println("'node_modules' jars missing and/or wrong versions. Removing 'node_modules' may solve the problem.");
            System.exit(1);
        }
    }

    private static void processProperty(String name, Consumer<String> consumer) {
        if (System.getProperties().containsKey(name)) {
            try {
                String addr = System.getProperty(name);
                if ("".equals(addr)) {
                    addr = "9229";
                }
                consumer.accept(addr);
            }
            catch (RuntimeException e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
    }
}

