/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.reactiverse.es4x.Runtime;
import io.reactiverse.es4x.impl.AsyncError;
import io.reactiverse.es4x.impl.JSObjectMessageCodec;
import io.reactiverse.es4x.impl.SetContainer;
import io.reactiverse.es4x.jul.ANSIFormatter;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.regex.Pattern;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.proxy.Proxy;

public final class ECMAEngine {
    private final Vertx vertx;
    private final Engine engine;
    private final HostAccess hostAccess;
    private final PolyglotAccess polyglotAccess;
    private final Source objLookup;
    private final Source arrLookup;
    private final AtomicBoolean codecInstalled = new AtomicBoolean(false);

    private static Pattern[] allowedHostClassFilters() {
        String hostClassFilter = System.getProperty("es4x.host.class.filter", System.getenv("ES4XHOSTCLASSFILTER"));
        if (hostClassFilter == null || hostClassFilter.length() == 0) {
            return null;
        }
        String[] glob = hostClassFilter.split(",");
        Pattern[] patterns = new Pattern[glob.length];
        for (int i = 0; i < patterns.length; ++i) {
            boolean negate = false;
            String regex = glob[i];
            if (glob[i].charAt(0) == '!') {
                negate = true;
                regex = glob[i].substring(1);
            }
            patterns[i] = Pattern.compile((negate ? "^(?!" : "") + regex.replace(".", "\\.").replace("*", "[^\\.]+").replace("[^\\.]+[^\\.]+", ".*").replace("?", "\\w") + (negate ? "$).*$" : ""));
        }
        return patterns;
    }

    public ECMAEngine(Vertx vertx) {
        this.vertx = vertx;
        ConsoleHandler logHandler = new ConsoleHandler();
        logHandler.setFormatter(new ANSIFormatter());
        this.engine = Engine.newBuilder().logHandler((Handler)logHandler).build();
        if (!this.engine.getLanguages().containsKey("js")) {
            throw new IllegalStateException("A language with id 'js' is not installed");
        }
        this.polyglotAccess = Boolean.getBoolean("es4x.no-polyglot-access") ? PolyglotAccess.NONE : PolyglotAccess.ALL;
        this.objLookup = Source.newBuilder((String)"js", (CharSequence)"(function (fn) { fn({}); })", (String)"<cache#objLookup>").cached(true).internal(true).buildLiteral();
        this.arrLookup = Source.newBuilder((String)"js", (CharSequence)"(function (fn) { fn([]); })", (String)"<cache#arrLookup>").cached(true).internal(true).buildLiteral();
        this.hostAccess = HostAccess.newBuilder((HostAccess)HostAccess.ALL).targetTypeMapping(List.class, Object.class, Objects::nonNull, v -> v, HostAccess.TargetMappingPrecedence.HIGHEST).targetTypeMapping(Number.class, Byte.class, Objects::nonNull, Number::byteValue, HostAccess.TargetMappingPrecedence.HIGHEST).targetTypeMapping(Value.class, JsonArray.class, Value::hasArrayElements, v -> {
            Proxy p;
            if (v.isProxyObject() && (p = v.asProxyObject()) instanceof JsonArray) {
                return (JsonArray)p;
            }
            return new JsonArray((List)v.as(List.class));
        }, HostAccess.TargetMappingPrecedence.HIGH).targetTypeMapping(Map.class, Future.class, v -> v.get("then") instanceof Function, v -> {
            PromiseInternal promise = ((VertxInternal)vertx).promise();
            Object[] objectArray = new Object[2];
            objectArray[0] = arg_0 -> ((Promise)promise).complete(arg_0);
            objectArray[1] = arg_0 -> ECMAEngine.lambda$new$3((Promise)promise, arg_0);
            ((Function)v.get("then")).apply(objectArray);
            return promise.future();
        }, HostAccess.TargetMappingPrecedence.HIGH).targetTypeMapping(Value.class, JsonObject.class, v -> v.hasMembers() && !v.hasArrayElements(), v -> {
            Proxy p;
            if (v.isProxyObject() && (p = v.asProxyObject()) instanceof JsonObject) {
                return (JsonObject)p;
            }
            return new JsonObject((Map)v.as(Map.class));
        }, HostAccess.TargetMappingPrecedence.HIGH).targetTypeMapping(Value.class, Buffer.class, Value::hasBufferElements, v -> {
            if (v.hasMember("__jbuffer")) {
                return Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)((ByteBuffer)v.getMember("__jbuffer").as(ByteBuffer.class))));
            }
            long size = v.getBufferSize();
            Buffer b = Buffer.buffer((int)((int)size));
            for (long i = 0L; i < size; ++i) {
                b.appendByte(v.readBufferByte(i));
            }
            return b;
        }, HostAccess.TargetMappingPrecedence.LOW).targetTypeMapping(Value.class, Set.class, Value::hasArrayElements, v -> new SetContainer((List)v.as(List.class)), HostAccess.TargetMappingPrecedence.LOW).targetTypeMapping(Value.class, Throwable.class, v -> v.hasMember("name") && v.hasMember("message"), v -> {
            if (v.hasMember("stack")) {
                return ECMAEngine.wrap(v.getMember("name").asString(), v.getMember("message").asString(), v.getMember("stack").asString());
            }
            return ECMAEngine.wrap(v.getMember("name").asString(), v.getMember("message").asString(), null);
        }, HostAccess.TargetMappingPrecedence.LOW).build();
    }

    private static Throwable wrap(String name, String message, String stack) {
        Throwable t = new Throwable("".equals(message) ? name : message);
        if (stack != null) {
            String[] sel = stack.split("\n");
            StackTraceElement[] elements = new StackTraceElement[sel.length - 1];
            for (int i = 1; i < sel.length; ++i) {
                elements[i - 1] = AsyncError.parseStrackTraceElement(sel[i]);
            }
            t.setStackTrace(elements);
        }
        return t;
    }

    private void registerCodec(Class className) {
        this.vertx.eventBus().unregisterDefaultCodec(className).registerDefaultCodec(className, (MessageCodec)new JSObjectMessageCodec(className.getName()));
    }

    public synchronized Runtime newContext(FileSystem fileSystem, Source ... scripts) {
        Pattern[] allowedHostAccessClassFilters = ECMAEngine.allowedHostClassFilters();
        Context.Builder builder = Context.newBuilder((String[])new String[]{"js"}).engine(this.engine).fileSystem(fileSystem).allowIO(true).allowCreateThread(false).allowHostClassLookup(fqcn -> {
            if (allowedHostAccessClassFilters == null) {
                return true;
            }
            for (Pattern filter : allowedHostAccessClassFilters) {
                if (!filter.matcher((CharSequence)fqcn).matches()) continue;
                return true;
            }
            return false;
        }).allowHostAccess(this.hostAccess).allowPolyglotAccess(this.polyglotAccess).allowEnvironmentAccess(EnvironmentAccess.INHERIT).option("js.foreign-object-prototype", "true");
        Context context = builder.build();
        if (this.codecInstalled.compareAndSet(false, true)) {
            Consumer<Object> callback = value -> this.registerCodec(value.getClass());
            context.eval(this.objLookup).execute(new Object[]{callback});
            context.eval(this.arrLookup).execute(new Object[]{callback});
        }
        return new Runtime(this.vertx, context, scripts);
    }

    public void close() {
        this.engine.close();
    }

    private static /* synthetic */ void lambda$new$3(Promise promise, Object failure) {
        if (failure instanceof Throwable) {
            promise.fail((Throwable)failure);
        } else if (failure instanceof Map) {
            Map map = (Map)failure;
            if (map.containsKey("name") && map.containsKey("message")) {
                promise.fail(ECMAEngine.wrap((String)map.get("name"), (String)map.get("message"), (String)map.get("stack")));
            } else {
                promise.fail(failure.toString());
            }
        } else {
            promise.fail(failure == null ? null : failure.toString());
        }
    }
}

