/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.docgen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.reactiverse.es4x.codetrans.EcmaScript;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.docgen.DocGenerator;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ES4XDocGenerator
implements DocGenerator {
    private CodeTranslator translator;
    private Elements elementUtils;
    private Types typeUtils;

    public void init(ProcessingEnvironment processingEnv) {
        this.translator = new CodeTranslator(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    public String getName() {
        return "js";
    }

    public String renderSource(ExecutableElement elt, String source) {
        try {
            return this.translator.translate(elt, (Lang)new EcmaScript());
        }
        catch (Exception e) {
            System.out.println("Cannot generate " + elt.getEnclosingElement().getSimpleName() + "#" + elt.getSimpleName() + " : " + e.getMessage());
            return "Code not translatable";
        }
    }

    public String resolveTypeLink(TypeElement elt) {
        try {
            String kind;
            TypeMirrorFactory factory = new TypeMirrorFactory(this.elementUtils, this.typeUtils);
            TypeInfo type = factory.create(elt.asType());
            String baselink = Util.getNPMScope(type.getRaw().getModule());
            switch (type.getKind()) {
                case ENUM: {
                    kind = "enums";
                    break;
                }
                case HANDLER: 
                case ASYNC_RESULT: {
                    kind = "interfaces";
                    break;
                }
                case API: {
                    boolean concrete;
                    boolean bl = concrete = elt.getAnnotation(VertxGen.class) == null || elt.getAnnotation(VertxGen.class).concrete();
                    if (concrete) {
                        kind = "classes";
                        break;
                    }
                    kind = "interfaces";
                    break;
                }
                case OTHER: {
                    if (type.isVariable()) {
                        kind = "classes";
                        break;
                    }
                    return null;
                }
                default: {
                    System.err.println("Could not resolve doc link for kind " + type.getKind());
                    return null;
                }
            }
            return "/es4x/" + baselink + "/" + kind + "/" + elt.getSimpleName().toString().toLowerCase() + ".html";
        }
        catch (Exception e) {
            System.out.println("Could not resolve doc link for type " + elt.getQualifiedName() + ": " + e.getMessage());
            return null;
        }
    }

    public String resolveMethodLink(ExecutableElement elt) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt);
        if (link != null) {
            link = link + '#' + elt.getSimpleName().toString().toLowerCase();
        }
        return link;
    }

    public String resolveLabel(Element elt, String defaultLabel) {
        return defaultLabel;
    }

    public String resolveConstructorLink(ExecutableElement elt) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt);
        if (link != null) {
            link = link + '#' + elt.getSimpleName().toString().toLowerCase();
        }
        return link;
    }

    public String resolveFieldLink(VariableElement elt) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt);
        if (link != null) {
            link = link + '#' + elt.getSimpleName().toString().toLowerCase();
        }
        return link;
    }
}

