/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.EnumModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Model;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.Map;

public class PackageJSON
extends Generator<Model> {
    public PackageJSON() {
        this.kinds = new HashSet();
        this.kinds.add("class");
        this.kinds.add("enum");
        this.kinds.add("dataObject");
        this.kinds.add("module");
        this.name = "es4x-generator (package.json)";
        this.incremental = true;
    }

    public String filename(Model model) {
        return "npm/package.json";
    }

    public String render(Model model, int index, int size, Map<String, Object> session) {
        if (model instanceof EnumModel) {
            session.putIfAbsent("enums", "seen");
        }
        if (model instanceof ClassModel) {
            session.putIfAbsent("index", "seen");
        }
        if (model instanceof DataObjectModel) {
            session.putIfAbsent("options", "seen");
        }
        if (index != size - 1) {
            return "";
        }
        JsonObject json = new JsonObject(System.getProperty("package-json", "{\"version\": \"0.0.0\", \"private\": true, \"name\": \"noname\"}"));
        if (json.getString("name") == null || json.getString("name").equals("")) {
            json.put("name", (Object)Util.getNPMScope(model.getModule()));
        }
        if (session.containsKey("index")) {
            json.put("main", (Object)"index.js");
            json.put("types", (Object)"index.d.ts");
        }
        boolean isModule = false;
        if (session.containsKey("index") || session.containsKey("enums") || session.containsKey("options")) {
            isModule = true;
            JsonObject exports = new JsonObject();
            if (session.containsKey("index")) {
                exports.put(".", (Object)"./index.mjs");
                exports.put("./index", (Object)"./index.mjs");
            }
            if (session.containsKey("enums")) {
                exports.put("./enums", (Object)"./enums.mjs");
            }
            if (session.containsKey("options")) {
                exports.put("./options", (Object)"./options.mjs");
            }
            json.put("exports", (Object)exports);
        }
        if (isModule) {
            json.put("type", (Object)"module");
        }
        json.put("sideEffects", (Object)false);
        String url = System.getProperty("git-url");
        if (url != null && url.length() > 0) {
            String directory = System.getProperty("git-directory");
            if (directory != null && directory.length() > 0) {
                json.put("repository", (Object)new JsonObject().put("type", (Object)"git").put("url", (Object)url).put("directory", (Object)directory));
            } else {
                json.put("repository", (Object)new JsonObject().put("type", (Object)"git").put("url", (Object)url));
            }
        }
        json.put("version", (Object)this.toSemVer(json.getString("version")));
        if (json.containsKey("dependencies")) {
            for (Map.Entry kv : json.getJsonObject("dependencies")) {
                kv.setValue(this.toSemVer((String)kv.getValue()));
            }
        }
        if (json.containsKey("devDependencies")) {
            if (json.getJsonObject("devDependencies") != null) {
                JsonObject deps = json.getJsonObject("devDependencies");
                if (deps.size() == 0) {
                    json.remove("devDependencies");
                } else {
                    for (Map.Entry kv : deps) {
                        kv.setValue(this.toSemVer((String)kv.getValue()));
                    }
                }
            } else {
                json.remove("devDependencies");
            }
        }
        return json.encodePrettily();
    }

    private String toSemVer(String string) {
        String base = "0.0.0";
        char[] version = string.toCharArray();
        int dots = 0;
        for (int i = 0; i < version.length && version[i] != '-'; ++i) {
            if (version[i] != '.' || ++dots <= 2) continue;
            version[i] = 45;
        }
        if (dots == 2) {
            return string;
        }
        if (dots > 2) {
            return new String(version);
        }
        return base.substring(0, 2 * dots) + new String(version);
    }
}

