/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.JVMClass;
import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.core.json.JsonObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class OptionsDTS
extends Generator<DataObjectModel> {
    public OptionsDTS() {
        this.incremental = true;
        this.kinds = new HashSet();
        this.kinds.add("dataObject");
        this.name = "es4x-generator (options.d.ts)";
    }

    public String filename(DataObjectModel model) {
        return "npm/options.d.ts";
    }

    private Collection<ClassTypeInfo> filterImports(Map<String, PropertyInfo> properties) {
        HashSet<ClassTypeInfo> result = new HashSet<ClassTypeInfo>();
        for (PropertyInfo p : properties.values()) {
            p.getType().collectImports(result);
        }
        return result;
    }

    public String render(DataObjectModel model, int index, int size, Map<String, Object> session) {
        String string;
        String selfScope;
        if (Util.isExcludedClass(model.getType().getName())) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        if (index == 0) {
            Util.generateLicense(writer);
            Util.registerJvmClasses();
            for (Object fqcn : Util.jvmClasses("dataObject")) {
                JVMClass.generateDTS(writer, fqcn.toString());
            }
            writer.print(Util.includeFileIfPresent("options.header.d.ts"));
        } else {
            writer.print("\n");
        }
        boolean imports = false;
        JsonObject includes = Util.getIncludes(model.getType().getSimpleName());
        if (includes.containsKey("import<d.ts>")) {
            writer.printf("%s\n", includes.getString("import<d.ts>"));
        }
        for (ClassTypeInfo classTypeInfo : this.filterImports(model.getPropertyMap())) {
            if (classTypeInfo.getKind() == ClassKind.ENUM) {
                if (classTypeInfo.getRaw().getModuleName() == null) {
                    System.err.println("@@@ Missing module for ENUM: " + classTypeInfo);
                    continue;
                }
                if (Util.sameModule(model.getType(), classTypeInfo.getRaw())) {
                    Util.importType(writer, session, (TypeInfo)classTypeInfo, classTypeInfo.getSimpleName(), "./enums");
                    imports = true;
                } else {
                    Util.importType(writer, session, (TypeInfo)classTypeInfo, classTypeInfo.getSimpleName(), Util.getNPMScope(classTypeInfo.getRaw().getModule()) + "/enums");
                    imports = true;
                }
            }
            if (classTypeInfo.getKind() == ClassKind.OTHER && classTypeInfo.getDataObject() != null && !Util.sameModule(model.getType(), classTypeInfo.getRaw())) {
                Util.importType(writer, session, (TypeInfo)classTypeInfo, classTypeInfo.getSimpleName(), Util.getNPMScope(classTypeInfo.getRaw().getModule()) + "/options");
                imports = true;
            }
            if (classTypeInfo.getKind() != ClassKind.API) continue;
            if (Util.sameModule(model.getType(), classTypeInfo.getRaw())) {
                Util.importType(writer, session, (TypeInfo)classTypeInfo, classTypeInfo.getSimpleName(), "./index");
                imports = true;
                continue;
            }
            Util.importType(writer, session, (TypeInfo)classTypeInfo, classTypeInfo.getSimpleName(), Util.getNPMScope(classTypeInfo.getRaw().getModule()));
            imports = true;
        }
        if (model.getSuperType() != null && !(selfScope = Util.getNPMScope(model.getModule())).equals(string = Util.getNPMScope(model.getSuperType().getModule()))) {
            ClassTypeInfo referencedType = model.getSuperType();
            String suffix = "";
            if (referencedType.getKind() == ClassKind.ENUM) {
                suffix = "/enums";
            }
            if (referencedType.getKind() == ClassKind.OTHER && referencedType.getDataObject() != null) {
                suffix = "/options";
            }
            Util.importType(writer, session, (TypeInfo)referencedType, referencedType.getSimpleName(), Util.getNPMScope(referencedType.getRaw().getModule()) + suffix);
            imports = true;
        }
        if (imports) {
            writer.print("\n");
        }
        Util.generateDoc(writer, model.getDoc(), "");
        writer.printf("export %sclass %s%s%s {\n\n", model.isConcrete() ? "" : "abstract ", model.getType().getRaw().getSimpleName(), model.getSuperType() != null ? " extends " + model.getSuperType().getRaw().getSimpleName() : "", includes.containsKey("dataObjectImplements<d.ts>") ? " implements " + includes.getString("dataObjectImplements<d.ts>") : "");
        if (model.hasEmptyConstructor()) {
            writer.print("  constructor();\n\n");
        }
        writer.printf("  constructor(obj: %s%s%s);\n\n", model.getType().getRaw().getSimpleName(), model.hasStringConstructor() ? " | string" : "", model.hasJsonConstructor() ? " | { [key: string]: any }" : "");
        for (Map.Entry entry : model.getPropertyMap().entrySet()) {
            PropertyInfo property = (PropertyInfo)entry.getValue();
            if (property.getGetterMethod() != null) {
                Util.generateDoc(writer, property.getDoc(), "  ");
                writer.printf("  %s%s(): %s;\n\n", this.getOverride(property), property.getGetterMethod(), OptionsDTS.genCollectionAwareType(property, false));
            }
            if (property.isSetter()) {
                Util.generateDoc(writer, property.getDoc(), "  ");
                writer.printf("  %s%s(%s: %s%s): %s;\n\n", this.getOverride(property), property.getSetterMethod(), Util.cleanReserved(property.getName()), OptionsDTS.genCollectionAwareType(property, true), property.getType().isNullable() ? " | null | undefined" : "", model.getType().getRaw().getSimpleName());
            }
            if (!property.isAdder()) continue;
            Util.generateDoc(writer, property.getDoc(), "  ");
            if (property.getKind() == PropertyKind.MAP) {
                writer.printf("  %s%s(key: string, %s: %s%s): %s;\n\n", this.getOverride(property), property.getAdderMethod(), Util.cleanReserved(property.getName()), Util.genType(property.getType(), true), property.getType().isNullable() ? " | null | undefined" : "", model.getType().getRaw().getSimpleName());
                continue;
            }
            writer.printf("  %s%s(%s: %s%s): %s;\n\n", this.getOverride(property), property.getAdderMethod(), Util.cleanReserved(property.getName()), Util.genType(property.getType(), true), property.getType().isNullable() ? " | null | undefined" : "", model.getType().getRaw().getSimpleName());
        }
        if (model.hasToJsonMethod()) {
            writer.print("\n  toJson(): { [key: string]: any };\n");
        }
        if (includes.containsKey("d.ts")) {
            writer.printf("%s\n", includes.getString("d.ts"));
        }
        writer.print("}\n");
        if (index == size - 1) {
            writer.print(Util.includeFileIfPresent("options.footer.d.ts"));
        }
        return sw.toString();
    }

    private String getOverride(PropertyInfo property) {
        if (property.getAnnotation("java.lang.Override") != null) {
            return "/* override */ ";
        }
        return "";
    }

    private static String genCollectionAwareType(PropertyInfo propertyInfo, boolean parameter) {
        if (propertyInfo.isList() || propertyInfo.isSet()) {
            return Util.genType(propertyInfo.getType(), parameter) + "[]";
        }
        if (propertyInfo.isMap()) {
            return "{ [key: string]: " + Util.genType(propertyInfo.getType(), parameter) + " }";
        }
        return Util.genType(propertyInfo.getType(), parameter);
    }
}

