/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.core.json.JsonObject;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;

public class JVMClass {
    private static String getSimpleName(Class<?> clazz) {
        String name = clazz.getName();
        int idx = name.lastIndexOf(46);
        return name.substring(idx + 1);
    }

    public static void generateJS(PrintWriter writer, String fqcn) {
        Class<?> clazz;
        try {
            clazz = Class.forName(fqcn);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Can't process: " + fqcn);
            return;
        }
        writer.printf("  %s: Java.type('%s'),\n", JVMClass.getSimpleName(clazz), clazz.getName());
    }

    public static void generateMJS(PrintWriter writer, String fqcn) {
        Class<?> clazz;
        try {
            clazz = Class.forName(fqcn);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Can't process: " + fqcn);
            return;
        }
        writer.printf("export const %s = Java.type('%s');\n", JVMClass.getSimpleName(clazz), clazz.getName());
    }

    public static void generateDTS(PrintWriter writer, String fqcn) {
        boolean isAbstract;
        Class<?> clazz;
        try {
            clazz = Class.forName(fqcn);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Can't process: " + fqcn);
            return;
        }
        JsonObject includes = Util.getIncludes(JVMClass.getSimpleName(clazz));
        if (includes.containsKey("import<d.ts>")) {
            writer.printf("%s\n", includes.getString("import<d.ts>"));
        }
        boolean isInterface = clazz.isInterface();
        boolean bl = isAbstract = !clazz.isInterface() && Modifier.isAbstract(clazz.getModifiers());
        if (isInterface) {
            for (Method method : clazz.getMethods()) {
                if (Util.isExcluded(JVMClass.getSimpleName(clazz), method.getName(), Arrays.asList(method.getParameterTypes())) || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) continue;
                isInterface = false;
                isAbstract = true;
                break;
            }
        }
        writer.printf("/** Auto-generated from %s %s %s %s\n", Modifier.toString(clazz.getModifiers()), clazz.getName(), clazz.isInterface() ? "" : "extends", clazz.getSuperclass() != null ? clazz.getSuperclass().getName() : "");
        Class<?>[] clazzInterfaces = clazz.getInterfaces();
        for (Class<?> clazz2 : clazzInterfaces) {
            writer.printf(" * implements %s\n", clazz2.getName());
        }
        if (clazz.isAnnotationPresent(Deprecated.class)) {
            writer.println(" * @deprecated");
        }
        writer.println(" */");
        writer.printf("export %s%s %s {\n", isAbstract ? "abstract " : "", isInterface ? "interface" : "class", JVMClass.getSimpleName(clazz));
        writer.println();
        for (AnnotatedElement annotatedElement : clazz.getFields()) {
            if (Util.isExcluded(JVMClass.getSimpleName(clazz), ((Field)annotatedElement).getName(), null) || !Modifier.isPublic(((Field)annotatedElement).getModifiers())) continue;
            if (((AccessibleObject)annotatedElement).isAnnotationPresent(Deprecated.class)) {
                writer.println("  /** @deprecated */");
            }
            writer.printf("  %s%s : %s;\n", Modifier.isStatic(((Field)annotatedElement).getModifiers()) ? "static " : "", ((Field)annotatedElement).getName(), Util.genType(((Field)annotatedElement).getGenericType().getTypeName()));
            writer.println();
        }
        for (AnnotatedElement annotatedElement : clazz.getConstructors()) {
            if (Util.isExcluded(JVMClass.getSimpleName(clazz), "<ctor>", Arrays.asList(((Constructor)annotatedElement).getParameterTypes())) || !Modifier.isPublic(((Constructor)annotatedElement).getModifiers())) continue;
            writer.printf("  /** Auto-generated from %s#%s\n", clazz.getName(), ((Constructor)annotatedElement).getName());
            for (Class<?> exception : ((Constructor)annotatedElement).getExceptionTypes()) {
                writer.printf("   * @throws %s\n", exception.getName());
            }
            if (((AccessibleObject)annotatedElement).isAnnotationPresent(Deprecated.class)) {
                writer.println("   * @deprecated");
            }
            writer.println("   */");
            writer.printf("  constructor(%s);\n", JVMClass.getParamDefinition(((Constructor)annotatedElement).getGenericParameterTypes()));
            writer.println();
        }
        for (AnnotatedElement annotatedElement : clazz.getMethods()) {
            if (Util.isExcluded(JVMClass.getSimpleName(clazz), ((Method)annotatedElement).getName(), Arrays.asList(((Method)annotatedElement).getParameterTypes())) || !Modifier.isPublic(((Method)annotatedElement).getModifiers())) continue;
            writer.printf("  /** Auto-generated from %s#%s\n", clazz.getName(), ((Method)annotatedElement).getName());
            for (Class<?> exception : ((Method)annotatedElement).getExceptionTypes()) {
                writer.printf("   * @throws %s\n", exception.getName());
            }
            if (((AccessibleObject)annotatedElement).isAnnotationPresent(Deprecated.class)) {
                writer.println("   * @deprecated");
            }
            writer.println("   */");
            writer.printf("  %s%s(%s) : %s;\n", Modifier.isStatic(((Method)annotatedElement).getModifiers()) ? "static " : "", ((Method)annotatedElement).getName(), JVMClass.getParamDefinition(((Method)annotatedElement).getParameterTypes()), Util.genType(((Method)annotatedElement).getGenericReturnType().getTypeName()));
            writer.println();
        }
        writer.println("}");
        writer.println();
    }

    private static CharSequence getParamDefinition(Type[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            Type param = params[i];
            sb.append("arg");
            sb.append(i);
            sb.append(": ");
            sb.append(Util.genType(param.getTypeName()));
        }
        return sb;
    }
}

