/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.JVMClass;
import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.core.json.JsonObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IndexDTS
extends Generator<ClassModel> {
    public IndexDTS() {
        this.incremental = true;
        this.kinds = new HashSet();
        this.kinds.add("class");
        this.name = "es4x-generator (index.d.ts)";
    }

    public String filename(ClassModel model) {
        return "npm/index.d.ts";
    }

    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        boolean hasConstantInInterface;
        if (Util.isExcludedClass(model.getType().getName())) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        ClassTypeInfo type = model.getType();
        if (index == 0) {
            Util.generateLicense(writer);
            Util.registerJvmClasses();
            for (Object fqcn : Util.jvmClasses("api")) {
                JVMClass.generateDTS(writer, fqcn.toString());
            }
            writer.print(Util.includeFileIfPresent("index.header.d.ts"));
            if (!type.getModuleName().equals("vertx")) {
                if (Util.isOptionalModule("@vertx/core")) {
                    writer.println("// @ts-ignore");
                }
                writer.print("import { Handler, AsyncResult } from '@vertx/core';\n\n");
            }
        } else {
            writer.print("\n");
        }
        boolean imports = false;
        JsonObject includes = Util.getIncludes(type.getSimpleName());
        if (includes.containsKey("import<d.ts>")) {
            writer.printf("%s\n", includes.getString("import<d.ts>"));
        }
        Map aliasMap = (Map)session.computeIfAbsent("aliasMap", a -> new HashMap());
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (Util.sameModule(type, referencedType.getRaw())) continue;
            String simpleName = referencedType.getSimpleName();
            if (simpleName.equals(model.getIfaceSimpleName())) {
                String aliasName = simpleName + "Super";
                simpleName = simpleName + " as " + (String)aliasName;
                aliasMap.put(referencedType.getName(), aliasName);
            }
            Util.importType(writer, session, (TypeInfo)referencedType, simpleName, Util.getNPMScope(referencedType.getRaw().getModule()));
            imports = true;
        }
        for (ClassTypeInfo dataObjectType : model.getReferencedDataObjectTypes()) {
            if (Util.sameModule(type, dataObjectType.getRaw())) {
                Util.importType(writer, session, (TypeInfo)dataObjectType, dataObjectType.getSimpleName(), "./options");
                imports = true;
                continue;
            }
            Util.importType(writer, session, (TypeInfo)dataObjectType, dataObjectType.getSimpleName(), Util.getNPMScope(dataObjectType.getRaw().getModule()) + "/options");
            imports = true;
        }
        for (EnumTypeInfo enumType : model.getReferencedEnumTypes()) {
            if (enumType.getRaw().getModuleName() == null) {
                System.err.println("@@@ Missing module for ENUM: " + enumType);
                continue;
            }
            if (Util.sameModule(type, enumType.getRaw())) {
                Util.importType(writer, session, (TypeInfo)enumType, enumType.getSimpleName(), "./enums");
                imports = true;
                continue;
            }
            Util.importType(writer, session, (TypeInfo)enumType, enumType.getSimpleName(), Util.getNPMScope(enumType.getRaw().getModule()) + "/enums");
            imports = true;
        }
        HashSet<String> superTypes = new HashSet<String>();
        model.getAbstractSuperTypes().forEach(ti -> {
            if (!Util.sameModule(type, ti.getRaw())) {
                Util.importType(writer, session, ti, ti.getSimpleName(), Util.getNPMScope(ti.getRaw().getModule()));
            }
            superTypes.add(Util.genType(ti));
        });
        imports |= superTypes.size() > 0;
        if (model.isHandler() && model.isConcrete()) {
            TypeInfo ti2 = model.getHandlerArg();
            if (!Util.sameModule(type, ti2.getRaw())) {
                Util.importType(writer, session, ti2, ti2.getSimpleName(), Util.getNPMScope(ti2.getRaw().getModule()) + (ti2.isDataObjectHolder() ? "/options" : ""));
                imports = true;
            }
            superTypes.add("Handler<" + Util.genType(ti2) + ">");
        }
        if (imports) {
            writer.print("\n");
        }
        Util.generateDoc(writer, model.getDoc(), "");
        writer.printf("export %s %s%s", model.isConcrete() ? "abstract class" : "interface", type.getSimpleName(), Util.genGeneric(type.getParams()));
        if (model.isConcrete()) {
            if (model.getConcreteSuperType() != null) {
                String simpleName = (String)aliasMap.get(model.getConcreteSuperType().getName());
                writer.printf(" extends %s", simpleName != null ? simpleName : Util.genType(model.getConcreteSuperType()));
            }
            if (!superTypes.isEmpty()) {
                writer.printf(" implements %s", String.join((CharSequence)", ", superTypes));
            }
        } else if (model.isHandler()) {
            writer.printf(" extends Handler<%s>", Util.genType(model.getHandlerArg()));
            if (!superTypes.isEmpty()) {
                writer.printf(", %s", String.join((CharSequence)", ", superTypes));
            }
        } else if (!superTypes.isEmpty()) {
            writer.printf(" extends %s", String.join((CharSequence)", ", superTypes));
        }
        writer.print(" {\n");
        boolean moreConstants = false;
        boolean bl = hasConstantInInterface = !model.isConcrete() && model.getConstants().size() > 0;
        if (model.isConcrete()) {
            for (ConstantInfo constant : model.getConstants()) {
                if (moreConstants) {
                    writer.print("\n");
                }
                Util.generateDoc(writer, constant.getDoc(), "  ");
                writer.printf("  static readonly %s : %s;\n", constant.getName(), Util.genType(constant.getType()));
                moreConstants = true;
            }
        }
        boolean moreMethods = false;
        boolean hasStaticMethodsInInterface = false;
        if (includes.containsKey("d.ts")) {
            writer.printf("%s\n", includes.getString("d.ts"));
        }
        for (MethodInfo method : model.getMethods()) {
            if (Util.isExcluded(type.getSimpleName(), method.getName(), method.getParams())) continue;
            if (!model.isConcrete() && method.isStaticMethod()) {
                hasStaticMethodsInInterface = true;
                continue;
            }
            if (moreMethods || moreConstants) {
                writer.print("\n");
            }
            this.generateMethod(writer, type, method);
            moreMethods = true;
        }
        for (MethodInfo method : model.getAnyJavaTypeMethods()) {
            if (Util.isExcluded(type.getSimpleName(), method.getName(), method.getParams())) continue;
            if (moreMethods || moreConstants) {
                writer.print("\n");
            }
            this.generateMethod(writer, type, method);
            moreMethods = true;
        }
        writer.print("}\n");
        if (hasConstantInInterface || hasStaticMethodsInInterface) {
            writer.print("\n");
            writer.printf("export abstract class %s%s implements %s%s {\n", type.getSimpleName(), Util.genGeneric(type.getParams()), type.getSimpleName(), Util.genGeneric(type.getParams()));
            moreConstants = false;
            for (ConstantInfo constant : model.getConstants()) {
                if (moreConstants) {
                    writer.print("\n");
                }
                Util.generateDoc(writer, constant.getDoc(), "  ");
                writer.printf("  static readonly %s : %s;\n", constant.getName(), Util.genType(constant.getType()));
                moreConstants = true;
            }
            moreMethods = false;
            if (includes.containsKey("d.ts")) {
                writer.printf("%s\n", includes.getString("d.ts"));
            }
            for (MethodInfo method : model.getMethods()) {
                if (Util.isExcluded(type.getSimpleName(), method.getName(), method.getParams()) || !method.isStaticMethod()) continue;
                if (moreMethods || moreConstants) {
                    writer.print("\n");
                }
                this.generateMethod(writer, type, method);
                moreMethods = true;
            }
            writer.print("}\n");
        }
        if (index == size - 1) {
            writer.print(Util.includeFileIfPresent("index.footer.d.ts"));
        }
        return sw.toString();
    }

    private void generateMethod(PrintWriter writer, ClassTypeInfo type, MethodInfo method) {
        if (method.getKind() == MethodKind.CALLBACK) {
            ArrayList<ParamInfo> params = new ArrayList<ParamInfo>(method.getParams());
            ParamInfo lastParam = (ParamInfo)params.remove(params.size() - 1);
            TypeInfo arg = ((ParameterizedTypeInfo)lastParam.getType()).getArg(0);
            this.generateMethod(writer, type, method, params, lastParam.isNullable(), "PromiseLike<" + (arg.isParameterized() ? Util.genType(((ParameterizedTypeInfo)arg).getArg(0)) : "any") + ">");
            writer.print("\n");
        }
        this.generateMethod(writer, type, method, method.getParams(), method.getReturnType().isNullable(), Util.genType(method.getReturnType()));
    }

    private void generateMethod(PrintWriter writer, ClassTypeInfo type, MethodInfo method, List<ParamInfo> params, boolean returnTypeNullable, String returnOverride) {
        Util.generateDoc(writer, method.getDoc(), "  ");
        if (method.isMethodOverride()) {
            writer.print("  /* override */ ");
        } else {
            writer.print("  ");
        }
        if (Util.getOverrideArgs(type.getSimpleName(), method.getName()) != null) {
            writer.printf("%s%s%s(%s", method.isStaticMethod() ? "static " : "", method.getName(), Util.genGeneric(method.getTypeParams()), Util.getOverrideArgs(type.getSimpleName(), method.getName()));
        } else {
            writer.printf("%s%s%s(", method.isStaticMethod() ? "static " : "", method.getName(), Util.genGeneric(method.getTypeParams()));
            boolean more = false;
            for (ParamInfo param : params) {
                if (more) {
                    writer.print(", ");
                }
                writer.printf("%s: %s%s", Util.cleanReserved(param.getName()), Util.genType(param.getType(), true), param.getType().isNullable() ? " | null | undefined" : "");
                more = true;
            }
        }
        if (Util.getOverrideReturn(type.getSimpleName(), method.getName()) != null) {
            writer.printf(") : %s%s;\n", Util.getOverrideReturn(type.getSimpleName(), method.getName()), returnTypeNullable ? " | null" : "");
        } else {
            writer.printf(") : %s%s;\n", returnOverride, returnTypeNullable ? " | null" : "");
        }
    }
}

