/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codetrans;

import com.sun.source.tree.LambdaExpressionTree;
import io.reactiverse.es4x.codetrans.EcmaScriptCodeBuilder;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.Helper;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.TypeArg;
import io.vertx.codetrans.expression.BinaryExpressionModel;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.IdentifierModel;
import io.vertx.codetrans.expression.JsonArrayLiteralModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.JsonObjectModel;
import io.vertx.codetrans.expression.Member;
import io.vertx.codetrans.expression.NullLiteralModel;
import io.vertx.codetrans.expression.ThisModel;
import io.vertx.codetrans.statement.StatementModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import javax.lang.model.element.TypeElement;

class EcmaScriptWriter
extends CodeWriter {
    final EcmaScriptCodeBuilder builder;

    EcmaScriptWriter(EcmaScriptCodeBuilder builder) {
        super((CodeBuilder)builder);
        this.builder = builder;
    }

    private String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public void renderBinary(BinaryExpressionModel expression) {
        String op;
        ExpressionModel left = expression.getLeft();
        ExpressionModel right = expression.getRight();
        switch (op = expression.getOp()) {
            case "==": {
                op = "===";
                if (right instanceof NullLiteralModel) {
                    ExpressionModel tmp = right;
                    right = left;
                    left = tmp;
                }
                if (!(left instanceof NullLiteralModel)) break;
                this.append("(");
                right.render((CodeWriter)this);
                this.append(" === null || ");
                right.render((CodeWriter)this);
                this.append(" === undefined)");
                return;
            }
            case "!=": {
                if (right instanceof NullLiteralModel) {
                    ExpressionModel tmp = right;
                    right = left;
                    left = tmp;
                }
                if (left instanceof NullLiteralModel) {
                    this.append("(");
                    right.render((CodeWriter)this);
                    this.append(" !== null && ");
                    right.render((CodeWriter)this);
                    this.append(" !== undefined)");
                    return;
                }
                op = "!==";
            }
        }
        super.renderBinary(new BinaryExpressionModel((CodeBuilder)this.builder, expression.getLeft(), op, expression.getRight()));
    }

    public void renderStatement(StatementModel statement) {
        statement.render((CodeWriter)this);
        if (statement instanceof StatementModel.Expression) {
            this.append(";");
        }
        this.append("\n");
    }

    public void renderTryCatch(StatementModel tryBlock, StatementModel catchBlock) {
        this.append("try {\n");
        this.indent();
        tryBlock.render((CodeWriter)this);
        this.unindent();
        this.append("} catch(err) {\n");
        this.indent();
        catchBlock.render((CodeWriter)this);
        this.unindent();
        this.append("}\n");
    }

    public void renderThis() {
        this.append("this");
    }

    public void renderNewMap() {
        this.append("{}");
    }

    public void renderNewList() {
        this.append("[]");
    }

    public void renderDataObject(DataObjectLiteralModel model) {
        this.append("new ").append((CharSequence)model.getType().getSimpleName()).append((CharSequence)"()");
        boolean dataModelHasMembers = model.getMembers().iterator().hasNext();
        if (dataModelHasMembers) {
            this.append("\n");
            this.indent();
        }
        AtomicBoolean needsNL = new AtomicBoolean();
        model.getMembers().forEach(member -> {
            if (needsNL.get()) {
                this.append("\n");
            }
            this.append(".set").append((CharSequence)this.capitalize(member.getName())).append((CharSequence)"(");
            if (member instanceof Member.Single) {
                ((Member.Single)member).getValue().render((CodeWriter)this);
            } else if (member instanceof Member.Sequence) {
                this.append("[");
                IntStream.range(0, ((Member.Sequence)member).getValues().size()).forEach(i -> {
                    if (i > 0) {
                        this.append(", ");
                    }
                    ((ExpressionModel)((Member.Sequence)member).getValues().get(i)).render((CodeWriter)this);
                });
                this.append("]");
            } else if (member instanceof Member.Entries) {
                this.append("todo-renderDataObject-entries");
            }
            this.append(")");
            needsNL.set(true);
        });
        if (dataModelHasMembers) {
            this.unindent();
        }
    }

    public void renderDataObjectToJson(IdentifierModel model) {
        model.render((CodeWriter)this);
    }

    public void renderToDataObject(JsonObjectModel model, ClassTypeInfo type) {
        model.render((CodeWriter)this);
    }

    public void renderJsonObject(JsonObjectLiteralModel jsonObject) {
        this.renderJsonObject(jsonObject.getMembers());
    }

    public void renderJsonArray(JsonArrayLiteralModel jsonArray) {
        this.renderJsonArray(jsonArray.getValues());
    }

    private void renderJsonObject(Iterable<Member> members) {
        this.append("{\n");
        this.indent();
        Iterator<Member> iterator = members.iterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            String name = member.getName();
            this.append("\"");
            this.renderChars(name);
            this.append("\" : ");
            if (member instanceof Member.Single) {
                ((Member.Single)member).getValue().render((CodeWriter)this);
            } else if (member instanceof Member.Sequence) {
                this.renderJsonArray(((Member.Sequence)member).getValues());
            } else if (member instanceof Member.Entries) {
                this.renderJsonObject(((Member.Entries)member).entries());
            }
            if (iterator.hasNext()) {
                this.append(',');
            }
            this.append('\n');
        }
        this.unindent().append((CharSequence)"}");
    }

    private void renderJsonArray(List<ExpressionModel> values) {
        this.append("[\n").indent();
        for (int i = 0; i < values.size(); ++i) {
            values.get(i).render((CodeWriter)this);
            if (i < values.size() - 1) {
                this.append(',');
            }
            this.append('\n');
        }
        this.unindent().append(']');
    }

    public void renderJsonObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        expression.render((CodeWriter)this);
        this.append('.');
        this.append(name);
        this.append(" = ");
        value.render((CodeWriter)this);
    }

    public void renderJsonArrayAdd(ExpressionModel expression, ExpressionModel value) {
        expression.render((CodeWriter)this);
        this.append(".push(");
        value.render((CodeWriter)this);
        this.append(")");
    }

    public void renderDataObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        this.renderJsonObjectAssign(expression, name, value);
    }

    public void renderJsonObjectMemberSelect(ExpressionModel expression, Class<?> type, String name) {
        expression.render((CodeWriter)this);
        this.append('.');
        this.append(name);
    }

    public void renderJsonObjectToString(ExpressionModel expression) {
        this.append("JSON.stringify(");
        expression.render((CodeWriter)this);
        this.append(")");
    }

    public void renderJsonArrayToString(ExpressionModel expression) {
        this.append("JSON.stringify(");
        expression.render((CodeWriter)this);
        this.append(")");
    }

    public void renderDataObjectMemberSelect(ExpressionModel expression, String name) {
        this.renderJsonObjectMemberSelect(expression, Object.class, name);
    }

    public void renderJsonObjectSize(ExpressionModel expression) {
        this.append("Object.keys(");
        expression.render((CodeWriter)this);
        this.append(").length");
    }

    public void renderJsonArraySize(ExpressionModel expression) {
        expression.render((CodeWriter)this);
        this.append(".length");
    }

    public void renderLambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        this.append("(");
        for (int i = 0; i < parameterNames.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            this.append(parameterNames.get(i));
        }
        this.append(") => {\n");
        this.indent();
        body.render((CodeWriter)this);
        if (bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            this.append(";\n");
        }
        this.unindent();
        this.append("}");
    }

    public void renderEnumConstant(EnumTypeInfo type, String constant) {
        this.append('\'').append((CharSequence)constant).append('\'');
    }

    public void renderThrow(String throwableType, ExpressionModel reason) {
        if (reason == null) {
            this.append("throw ").append((CharSequence)"\"an error occured\"");
        } else {
            this.append("throw ");
            reason.render((CodeWriter)this);
        }
    }

    public void renderSystemOutPrintln(ExpressionModel expression) {
        this.append("console.log(");
        expression.render((CodeWriter)this);
        this.append(")");
    }

    public void renderSystemErrPrintln(ExpressionModel expression) {
        this.append("console.error(");
        expression.render((CodeWriter)this);
        this.append(")");
    }

    public void renderListAdd(ExpressionModel list, ExpressionModel value) {
        list.render((CodeWriter)this);
        this.append(".push(");
        value.render((CodeWriter)this);
        this.append(")");
    }

    public void renderListSize(ExpressionModel list) {
        list.render((CodeWriter)this);
        this.append(".length");
    }

    public void renderListGet(ExpressionModel list, ExpressionModel index) {
        list.render((CodeWriter)this);
        this.append("[");
        index.render((CodeWriter)this);
        this.append("]");
    }

    public void renderListLiteral(List<ExpressionModel> arguments) {
        this.append("[");
        Iterator<ExpressionModel> it = arguments.iterator();
        while (it.hasNext()) {
            it.next().render((CodeWriter)this);
            if (!it.hasNext()) continue;
            this.append(", ");
        }
        this.append("]");
    }

    public void renderMapGet(ExpressionModel map, ExpressionModel key) {
        map.render((CodeWriter)this);
        this.append('[');
        key.render((CodeWriter)this);
        this.append(']');
    }

    public void renderMapPut(ExpressionModel map, ExpressionModel key, ExpressionModel value) {
        map.render((CodeWriter)this);
        this.append('[');
        key.render((CodeWriter)this);
        this.append("] = ");
        value.render((CodeWriter)this);
    }

    public void renderMapForEach(ExpressionModel map, String keyName, TypeInfo keyType, String valueName, TypeInfo valueType, LambdaExpressionTree.BodyKind bodyKind, CodeModel block) {
        map.render((CodeWriter)this);
        this.append(".forEach(");
        this.renderLambda(bodyKind, Arrays.asList(valueType, keyType), Arrays.asList(valueName, keyName), block);
        this.append(")");
    }

    public void renderMethodReference(ExpressionModel expression, MethodSignature signature) {
        if (!(expression instanceof ThisModel)) {
            expression.render((CodeWriter)this);
            this.append('.');
        }
        this.append(signature.getName());
    }

    public void renderApiType(ApiTypeInfo apiType) {
        this.append(apiType.getSimpleName());
    }

    public void renderJavaType(ClassTypeInfo javaType) {
        this.append("Java.type(\"").append((CharSequence)javaType.getName()).append((CharSequence)"\")");
    }

    public void renderAsyncResultSucceeded(TypeInfo resultType, String name) {
        this.append(name).append((CharSequence)".succeeded()");
    }

    public void renderAsyncResultFailed(TypeInfo resultType, String name) {
        this.append(name).append((CharSequence)".failed()");
    }

    public void renderAsyncResultCause(TypeInfo resultType, String name) {
        this.append(name).append((CharSequence)".cause()");
    }

    public void renderAsyncResultValue(TypeInfo resultType, String name) {
        this.append(name).append((CharSequence)".result()");
    }

    public void renderMethodInvocation(ExpressionModel expression, TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<TypeArg> typeArguments, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        int i;
        List parameterTypes = method.getParameterTypes();
        for (i = 0; i < parameterTypes.size(); ++i) {
            TypeInfo parameterType = (TypeInfo)parameterTypes.get(i);
            TypeInfo argumentType = argumentTypes.get(i);
            if (!Helper.isHandler((TypeInfo)parameterType) || !Helper.isInstanceOfHandler((TypeInfo)argumentType)) continue;
            ExpressionModel expressionModel = argumentModels.get(i);
            argumentModels.set(i, this.builder.render(arg_0 -> ((ExpressionModel)expressionModel).render(arg_0)));
        }
        if (!(expression instanceof ThisModel)) {
            expression.render((CodeWriter)this);
            this.append('.');
        }
        this.append(method.getName());
        this.append('(');
        for (i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render((CodeWriter)this);
        }
        this.append(')');
    }

    public void renderNew(ExpressionModel expression, TypeInfo type, List<ExpressionModel> argumentModels) {
        this.append("new (");
        expression.render((CodeWriter)this);
        this.append(")");
        this.append('(');
        for (int i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render((CodeWriter)this);
        }
        this.append(')');
    }

    public void renderInstanceOf(ExpressionModel expression, TypeElement type) {
        expression.render((CodeWriter)this);
        this.append(" instanceof ");
        this.append(type.getSimpleName());
    }
}

