/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.DataObjectModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.PropertyInfo;
import io.vertx.codegen.PropertyKind;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class OptionsDTS
extends Generator<DataObjectModel> {
    public OptionsDTS() {
        this.incremental = true;
        this.kinds = new HashSet();
        this.kinds.add("dataObject");
        this.name = "es4x-generator (options.d.ts)";
    }

    public String filename(DataObjectModel model) {
        return "npm/options.d.ts";
    }

    private Collection<ClassTypeInfo> filterImports(Map<String, PropertyInfo> properties) {
        HashSet<ClassTypeInfo> result = new HashSet<ClassTypeInfo>();
        for (PropertyInfo p : properties.values()) {
            p.getType().collectImports(result);
        }
        return result;
    }

    public String render(DataObjectModel model, int index, int size, Map<String, Object> session) {
        if (Util.isBlacklistedClass(model.getType().getName())) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        boolean imports = false;
        if (index == 0) {
            Util.generateLicense(writer);
        } else {
            writer.print("\n");
        }
        for (ClassTypeInfo classTypeInfo : this.filterImports(model.getPropertyMap())) {
            if (Util.isImported((TypeInfo)classTypeInfo, session)) continue;
            if (classTypeInfo.getKind() == ClassKind.ENUM) {
                if (classTypeInfo.getRaw().getModuleName().equals(model.getType().getRaw().getModuleName())) {
                    writer.printf("import { %s } from './enums';\n", classTypeInfo.getSimpleName());
                    imports = true;
                } else {
                    if (Util.isOptionalModule(Util.getNPMScope(classTypeInfo.getRaw().getModule()))) {
                        writer.println("// @ts-ignore");
                    }
                    writer.printf("import { %s } from '%s/enums';\n", classTypeInfo.getSimpleName(), Util.getNPMScope(classTypeInfo.getRaw().getModule()));
                    imports = true;
                }
            }
            if (classTypeInfo.getKind() == ClassKind.DATA_OBJECT && !classTypeInfo.getRaw().getModuleName().equals(model.getType().getRaw().getModuleName())) {
                if (Util.isOptionalModule(Util.getNPMScope(classTypeInfo.getRaw().getModule()))) {
                    writer.println("// @ts-ignore");
                }
                writer.printf("import { %s } from '%s/options';\n", classTypeInfo.getSimpleName(), Util.getNPMScope(classTypeInfo.getRaw().getModule()));
                imports = true;
            }
            if (classTypeInfo.getKind() != ClassKind.API) continue;
            if (classTypeInfo.getRaw().getModuleName().equals(model.getType().getRaw().getModuleName())) {
                writer.printf("import { %s } from './index';\n", classTypeInfo.getSimpleName());
                imports = true;
                continue;
            }
            if (Util.isOptionalModule(Util.getNPMScope(classTypeInfo.getRaw().getModule()))) {
                writer.println("// @ts-ignore");
            }
            writer.printf("import { %s } from '%s';\n", classTypeInfo.getSimpleName(), Util.getNPMScope(classTypeInfo.getRaw().getModule()));
            imports = true;
        }
        if (imports) {
            writer.print("\n");
        }
        Util.generateDoc(writer, model.getDoc(), "");
        writer.printf("export %sclass %s {\n", model.isConcrete() ? "" : "abstract ", model.getType().getRaw().getSimpleName());
        writer.print("\n");
        if (model.hasEmptyConstructor()) {
            writer.print("  constructor();\n\n");
        }
        writer.printf("  constructor(obj: %s);\n\n", model.getType().getRaw().getSimpleName());
        for (Map.Entry entry : model.getPropertyMap().entrySet()) {
            PropertyInfo property = (PropertyInfo)entry.getValue();
            if (property.getGetterMethod() != null) {
                Util.generateDoc(writer, property.getDoc(), "  ");
                writer.printf("  %s(): %s;\n\n", property.getGetterMethod(), Util.genType(property.getType()));
            }
            if (property.isSetter()) {
                Util.generateDoc(writer, property.getDoc(), "  ");
                writer.printf("  %s(%s: %s%s): %s;\n\n", property.getSetterMethod(), Util.cleanReserved(property.getName()), Util.genType(property.getType(), true), property.getType().isNullable() ? " | null | undefined" : "", model.getType().getRaw().getSimpleName());
            }
            if (!property.isAdder()) continue;
            Util.generateDoc(writer, property.getDoc(), "  ");
            if (property.getKind() == PropertyKind.MAP) {
                writer.printf("  %s(key: string, %s: %s%s): %s;\n\n", property.getAdderMethod(), Util.cleanReserved(property.getName()), Util.genType(property.getType(), true), property.getType().isNullable() ? " | null | undefined" : "", model.getType().getRaw().getSimpleName());
                continue;
            }
            writer.printf("  %s(%s: %s%s): %s;\n\n", property.getAdderMethod(), Util.cleanReserved(property.getName()), Util.genType(property.getType(), true), property.getType().isNullable() ? " | null | undefined" : "", model.getType().getRaw().getSimpleName());
        }
        writer.print("}\n");
        return sw.toString();
    }
}

