/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class IndexDTS
extends Generator<ClassModel> {
    public IndexDTS() {
        this.incremental = true;
        this.kinds = new HashSet();
        this.kinds.add("class");
        this.name = "es4x-generator (index.d.ts)";
    }

    public String filename(ClassModel model) {
        return "npm/index.d.ts";
    }

    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        boolean hasConstantInInterface;
        if (Util.isBlacklistedClass(model.getType().getName())) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        ClassTypeInfo type = model.getType();
        if (index == 0) {
            Util.generateLicense(writer);
            writer.print(Util.includeFileIfPresent("index.include.d.ts"));
            if (!type.getModuleName().equals("vertx")) {
                if (Util.isOptionalModule("@vertx/core")) {
                    writer.println("// @ts-ignore");
                }
                writer.print("import { Handler, AsyncResult } from '@vertx/core';\n\n");
            }
        } else {
            writer.print("\n");
        }
        boolean imports = false;
        Map aliasMap = (Map)session.computeIfAbsent("aliasMap", a -> new HashMap());
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (Util.isImported((TypeInfo)referencedType, session) || referencedType.getRaw().getModuleName().equals(type.getModuleName())) continue;
            String simpleName = referencedType.getSimpleName();
            if (simpleName.equals(model.getIfaceSimpleName())) {
                String aliasName = simpleName + "Super";
                simpleName = simpleName + " as " + (String)aliasName;
                aliasMap.put(referencedType.getName(), aliasName);
            }
            if (Util.isOptionalModule(Util.getNPMScope(referencedType.getRaw().getModule()))) {
                writer.println("// @ts-ignore");
            }
            writer.printf("import { %s } from '%s';\n", simpleName, Util.getNPMScope(referencedType.getRaw().getModule()));
            imports = true;
        }
        for (ClassTypeInfo dataObjectType : model.getReferencedDataObjectTypes()) {
            if (Util.isImported((TypeInfo)dataObjectType, session)) continue;
            if (dataObjectType.getRaw().getModuleName().equals(type.getModuleName())) {
                writer.printf("import { %s } from './options';\n", dataObjectType.getSimpleName());
                imports = true;
                continue;
            }
            writer.printf("import { %s } from '%s/options';\n", dataObjectType.getSimpleName(), Util.getNPMScope(dataObjectType.getRaw().getModule()));
            imports = true;
        }
        for (EnumTypeInfo enumType : model.getReferencedEnumTypes()) {
            if (Util.isImported((TypeInfo)enumType, session)) continue;
            if (enumType.getRaw().getModuleName().equals(type.getModuleName())) {
                writer.printf("import { %s } from './enums';\n", enumType.getSimpleName());
                imports = true;
                continue;
            }
            writer.printf("import { %s } from '%s/enums';\n", enumType.getSimpleName(), Util.getNPMScope(enumType.getRaw().getModule()));
            imports = true;
        }
        if (imports) {
            writer.print("\n");
        }
        HashSet<String> superTypes = new HashSet<String>();
        model.getAbstractSuperTypes().forEach(ti -> superTypes.add(Util.genType(ti)));
        if ("io.vertx.core.Future".equals(type.getName())) {
            superTypes.add("PromiseLike" + Util.genGeneric(type.getParams()));
        }
        if (model.isHandler() && model.isConcrete()) {
            superTypes.add("Handler<" + Util.genType(model.getHandlerArg()) + ">");
        }
        Util.generateDoc(writer, model.getDoc(), "");
        writer.printf("export %s %s%s", model.isConcrete() ? "abstract class" : "interface", type.getSimpleName(), Util.genGeneric(type.getParams()));
        if (model.isConcrete()) {
            if (model.getConcreteSuperType() != null) {
                String simpleName = (String)aliasMap.get(model.getConcreteSuperType().getName());
                writer.printf(" extends %s", simpleName != null ? simpleName : Util.genType(model.getConcreteSuperType()));
            }
            if (!superTypes.isEmpty()) {
                writer.printf(" implements %s", String.join((CharSequence)", ", superTypes));
            }
        } else if (model.isHandler()) {
            writer.printf(" extends Handler<%s>", Util.genType(model.getHandlerArg()));
            if (!superTypes.isEmpty()) {
                writer.printf(", %s", String.join((CharSequence)", ", superTypes));
            }
        } else if (!superTypes.isEmpty()) {
            writer.printf(" extends %s", String.join((CharSequence)", ", superTypes));
        }
        writer.print(" {\n");
        boolean moreConstants = false;
        boolean bl = hasConstantInInterface = !model.isConcrete() && model.getConstants().size() > 0;
        if (model.isConcrete()) {
            for (ConstantInfo constant : model.getConstants()) {
                if (moreConstants) {
                    writer.print("\n");
                }
                Util.generateDoc(writer, constant.getDoc(), "  ");
                writer.printf("  static readonly %s : %s;\n", constant.getName(), Util.genType(constant.getType()));
                moreConstants = true;
            }
        }
        boolean moreMethods = false;
        boolean hasStaticMethodsInInterface = false;
        for (MethodInfo method : model.getMethods()) {
            if (!model.isConcrete() && method.isStaticMethod()) {
                hasStaticMethodsInInterface = true;
                continue;
            }
            if (moreMethods || moreConstants) {
                writer.print("\n");
            }
            this.generateMethod(writer, type, method);
            moreMethods = true;
        }
        for (MethodInfo method : model.getAnyJavaTypeMethods()) {
            if (moreMethods || moreConstants) {
                writer.print("\n");
            }
            this.generateMethod(writer, type, method);
            moreMethods = true;
        }
        if ("io.vertx.core.Future".equals(type.getName())) {
            if (moreMethods || moreConstants) {
                writer.print("\n");
            }
            writer.println("  /**");
            writer.println("   * Attaches callbacks for the resolution and/or rejection of the Future.");
            writer.println("   * @param onfulfilled The callback to execute when the Future is resolved.");
            writer.println("   * @param onrejected The callback to execute when the Future is rejected.");
            writer.println("   * @returns A Promise for the completion of which ever callback is executed.");
            writer.println("   */");
            writer.println("   then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): PromiseLike<TResult1 | TResult2>;");
        }
        writer.print("}\n");
        if (hasConstantInInterface || hasStaticMethodsInInterface) {
            writer.print("\n");
            writer.printf("export abstract class %s%s implements %s%s {\n", type.getSimpleName(), Util.genGeneric(type.getParams()), type.getSimpleName(), Util.genGeneric(type.getParams()));
            moreConstants = false;
            for (ConstantInfo constant : model.getConstants()) {
                if (moreConstants) {
                    writer.print("\n");
                }
                Util.generateDoc(writer, constant.getDoc(), "  ");
                writer.printf("  static readonly %s : %s;\n", constant.getName(), Util.genType(constant.getType()));
                moreConstants = true;
            }
            moreMethods = false;
            for (MethodInfo method : model.getMethods()) {
                if (!method.isStaticMethod()) continue;
                if (moreMethods || moreConstants) {
                    writer.print("\n");
                }
                this.generateMethod(writer, type, method);
                moreMethods = true;
            }
            writer.print("}\n");
        }
        return sw.toString();
    }

    private void generateMethod(PrintWriter writer, ClassTypeInfo type, MethodInfo method) {
        Util.generateDoc(writer, method.getDoc(), "  ");
        if (Util.getOverrideArgs(type.getSimpleName(), method.getName()) != null) {
            writer.printf("  %s%s%s(%s", method.isStaticMethod() ? "static " : "", method.getName(), Util.genGeneric(method.getTypeParams()), Util.getOverrideArgs(type.getSimpleName(), method.getName()));
        } else {
            writer.printf("  %s%s%s(", method.isStaticMethod() ? "static " : "", method.getName(), Util.genGeneric(method.getTypeParams()));
            boolean more = false;
            for (ParamInfo param : method.getParams()) {
                if (more) {
                    writer.print(", ");
                }
                writer.printf("%s: %s%s", Util.cleanReserved(param.getName()), Util.genType(param.getType(), true), param.getType().isNullable() ? " | null | undefined" : "");
                more = true;
            }
        }
        if (Util.getOverrideReturn(type.getSimpleName(), method.getName()) != null) {
            writer.printf(") : %s%s;\n", Util.getOverrideReturn(type.getSimpleName(), method.getName()), method.getReturnType().isNullable() ? " | null" : "");
        } else {
            writer.printf(") : %s%s;\n", Util.genType(method.getReturnType()), method.getReturnType().isNullable() ? " | null" : "");
        }
    }
}

