/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.es4x.codegen.generator;

import io.reactiverse.es4x.codegen.generator.Util;
import io.vertx.codegen.EnumModel;
import io.vertx.codegen.EnumValueInfo;
import io.vertx.codegen.Generator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Map;

public class EnumDTS
extends Generator<EnumModel> {
    public EnumDTS() {
        this.incremental = true;
        this.kinds = new HashSet();
        this.kinds.add("enum");
        this.name = "es4x-generator (enum.d.ts)";
    }

    public String filename(EnumModel model) {
        return "npm/enums.d.ts";
    }

    public String render(EnumModel model, int index, int size, Map<String, Object> session) {
        if (Util.isBlacklistedClass(model.getType().getName())) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        if (index == 0) {
            Util.generateLicense(writer);
        } else {
            writer.print("\n");
        }
        Util.generateDoc(writer, model.getDoc(), "");
        writer.printf("export enum %s {\n", model.getType().getRaw().getSimpleName());
        for (int i = 0; i < model.getValues().size(); ++i) {
            EnumValueInfo value = (EnumValueInfo)model.getValues().get(i);
            writer.printf("  %s", value.getIdentifier());
            if (i != model.getValues().size() - 1) {
                writer.print(",");
            }
            writer.print("\n");
        }
        writer.print("}\n");
        return sw.toString();
    }
}

