/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import io.quarkus.oidc.client.runtime.OidcClientImpl;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.client.runtime.OidcClientsImpl;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@Recorder
public class OidcClientRecorder {
    private static final Logger LOG = Logger.getLogger(OidcClientRecorder.class);
    private static final String DEFAULT_OIDC_CLIENT_ID = "Default";
    private static final Duration CONNECTION_BACKOFF_DURATION = Duration.ofSeconds(2L);

    public OidcClients setup(OidcClientsConfig oidcClientsConfig, final TlsConfig tlsConfig, final Supplier<Vertx> vertx) {
        String defaultClientId = oidcClientsConfig.defaultClient.getId().orElse(DEFAULT_OIDC_CLIENT_ID);
        OidcClient defaultClient = OidcClientRecorder.createOidcClient(oidcClientsConfig.defaultClient, defaultClientId, tlsConfig, vertx);
        HashMap<String, OidcClient> staticOidcClients = new HashMap<String, OidcClient>();
        for (Map.Entry<String, OidcClientConfig> config : oidcClientsConfig.namedClients.entrySet()) {
            OidcCommonUtils.verifyConfigurationId((String)defaultClientId, (String)config.getKey(), config.getValue().getId());
            staticOidcClients.put(config.getKey(), OidcClientRecorder.createOidcClient(config.getValue(), config.getKey(), tlsConfig, vertx));
        }
        return new OidcClientsImpl(defaultClient, staticOidcClients, new Function<OidcClientConfig, Uni<OidcClient>>(){

            @Override
            public Uni<OidcClient> apply(OidcClientConfig config) {
                return OidcClientRecorder.createOidcClientUni(config, config.getId().get(), tlsConfig, vertx);
            }
        });
    }

    public Supplier<OidcClient> createOidcClientBean(final OidcClients clients) {
        return new Supplier<OidcClient>(){

            @Override
            public OidcClient get() {
                return clients.getClient();
            }
        };
    }

    public Supplier<OidcClient> createOidcClientBean(final OidcClients clients, final String clientName) {
        return new Supplier<OidcClient>(){

            @Override
            public OidcClient get() {
                return clients.getClient(clientName);
            }
        };
    }

    public Supplier<OidcClients> createOidcClientsBean(final OidcClients clients) {
        return new Supplier<OidcClients>(){

            @Override
            public OidcClients get() {
                return clients;
            }
        };
    }

    protected static OidcClient createOidcClient(OidcClientConfig oidcConfig, String oidcClientId, TlsConfig tlsConfig, Supplier<Vertx> vertx) {
        return (OidcClient)OidcClientRecorder.createOidcClientUni(oidcConfig, oidcClientId, tlsConfig, vertx).await().indefinitely();
    }

    protected static Uni<OidcClient> createOidcClientUni(final OidcClientConfig oidcConfig, String oidcClientId, TlsConfig tlsConfig, Supplier<Vertx> vertx) {
        if (!oidcConfig.isClientEnabled()) {
            String message = String.format("'%s' client configuration is disabled", oidcClientId);
            LOG.debug((Object)message);
            return Uni.createFrom().item((Object)new DisabledOidcClient(message));
        }
        if (!oidcConfig.getId().isPresent()) {
            oidcConfig.setId(oidcClientId);
        }
        try {
            OidcCommonUtils.verifyCommonConfiguration((OidcCommonConfig)oidcConfig, (boolean)false, (boolean)false);
        }
        catch (Throwable t) {
            LOG.debug((Object)t.getMessage());
            String message = String.format("'%s' client configuration is not initialized", oidcClientId);
            return Uni.createFrom().item((Object)new DisabledOidcClient(message));
        }
        final String authServerUriString = OidcCommonUtils.getAuthServerUrl((OidcCommonConfig)oidcConfig);
        WebClientOptions options = new WebClientOptions();
        OidcCommonUtils.setHttpClientOptions((OidcCommonConfig)oidcConfig, (TlsConfig)tlsConfig, (HttpClientOptions)options);
        final WebClient client = WebClient.create((io.vertx.mutiny.core.Vertx)new io.vertx.mutiny.core.Vertx(vertx.get()), (WebClientOptions)options);
        Uni tokenRequestUriUni = null;
        tokenRequestUriUni = !oidcConfig.discoveryEnabled ? Uni.createFrom().item((Object)OidcCommonUtils.getOidcEndpointUrl((String)authServerUriString, (Optional)oidcConfig.tokenPath)) : OidcClientRecorder.discoverTokenRequestUri(client, authServerUriString.toString(), oidcConfig);
        return tokenRequestUriUni.onItemOrFailure().transform((BiFunction)new BiFunction<String, Throwable, OidcClient>(){

            @Override
            public OidcClient apply(String tokenRequestUri, Throwable t) {
                if (t != null) {
                    throw OidcClientRecorder.toOidcClientException(authServerUriString, t);
                }
                if (tokenRequestUri == null) {
                    throw new ConfigurationException("OpenId Connect Provider token endpoint URL is not configured and can not be discovered");
                }
                String grantType = oidcConfig.grant.getType().getGrantType();
                MultiMap tokenGrantParams = null;
                if (oidcConfig.grant.getType() != OidcClientConfig.Grant.Type.REFRESH) {
                    Map<String, String> grantOptions;
                    tokenGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
                    OidcClientRecorder.setGrantClientParams(oidcConfig, tokenGrantParams, grantType);
                    if (oidcConfig.getGrantOptions() != null && (grantOptions = oidcConfig.getGrantOptions().get(oidcConfig.grant.getType().name().toLowerCase())) != null) {
                        if (oidcConfig.grant.getType() == OidcClientConfig.Grant.Type.PASSWORD) {
                            tokenGrantParams.add("username", grantOptions.get("username"));
                            tokenGrantParams.add("password", grantOptions.get("password"));
                        } else {
                            tokenGrantParams.addAll(grantOptions);
                        }
                    }
                }
                MultiMap commonRefreshGrantParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
                OidcClientRecorder.setGrantClientParams(oidcConfig, commonRefreshGrantParams, "refresh_token");
                return new OidcClientImpl(client, tokenRequestUri, grantType, tokenGrantParams, commonRefreshGrantParams, oidcConfig);
            }
        });
    }

    private static void setGrantClientParams(OidcClientConfig oidcConfig, MultiMap grantParams, String grantType) {
        grantParams.add("grant_type", grantType);
        OidcCommonConfig.Credentials creds = oidcConfig.getCredentials();
        if (OidcCommonUtils.isClientSecretPostAuthRequired((OidcCommonConfig.Credentials)creds)) {
            grantParams.add("client_id", (String)oidcConfig.clientId.get());
            grantParams.add("client_secret", OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)creds));
        }
        if (oidcConfig.getScopes().isPresent()) {
            grantParams.add("scope", oidcConfig.getScopes().get().stream().collect(Collectors.joining(" ")));
        }
    }

    private static Uni<String> discoverTokenRequestUri(WebClient client, String authServerUrl, OidcClientConfig oidcConfig) {
        long connectionDelayInMillisecs = OidcCommonUtils.getConnectionDelayInMillis((OidcCommonConfig)oidcConfig);
        return OidcCommonUtils.discoverMetadata((WebClient)client, (String)authServerUrl, (long)connectionDelayInMillisecs).onItem().transform(json -> json.getString("token_endpoint"));
    }

    protected static OidcClientException toOidcClientException(String authServerUrlString, Throwable cause) {
        return new OidcClientException(OidcCommonUtils.formatConnectionErrorMessage((String)authServerUrlString), cause);
    }

    private static class DisabledOidcClient
    implements OidcClient {
        String message;

        DisabledOidcClient(String message) {
            this.message = message;
        }

        @Override
        public Uni<Tokens> getTokens(Map<String, String> grantParameters) {
            throw new DisabledOidcClientException(this.message);
        }

        @Override
        public Uni<Tokens> refreshTokens(String refreshToken) {
            throw new DisabledOidcClientException(this.message);
        }

        @Override
        public void close() throws IOException {
            throw new DisabledOidcClientException(this.message);
        }
    }
}

