/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

public class OidcClientImpl
implements OidcClient {
    private static final Logger LOG = Logger.getLogger(OidcClientImpl.class);
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private final WebClient client;
    private final String tokenRequestUri;
    private final MultiMap tokenGrantParams;
    private final MultiMap commonRefreshGrantParams;
    private final String grantType;
    private final String clientSecretBasicAuthScheme;
    private final Key clientJwtKey;
    private final OidcClientConfig oidcConfig;
    private volatile boolean closed;

    public OidcClientImpl(WebClient client, String tokenRequestUri, String grantType, MultiMap tokenGrantParams, MultiMap commonRefreshGrantParams, OidcClientConfig oidcClientConfig) {
        this.client = client;
        this.tokenRequestUri = tokenRequestUri;
        this.tokenGrantParams = tokenGrantParams;
        this.commonRefreshGrantParams = commonRefreshGrantParams;
        this.grantType = grantType;
        this.oidcConfig = oidcClientConfig;
        this.clientSecretBasicAuthScheme = OidcCommonUtils.initClientSecretBasicAuth((OidcCommonConfig)oidcClientConfig);
        this.clientJwtKey = OidcCommonUtils.initClientJwtKey((OidcCommonConfig)oidcClientConfig);
    }

    @Override
    public Uni<Tokens> getTokens(Map<String, String> additionalGrantParameters) {
        this.checkClosed();
        if (this.tokenGrantParams == null) {
            throw new OidcClientException("Only 'refresh_token' grant is supported, please call OidcClient#refreshTokens method instead");
        }
        return this.getJsonResponse(this.tokenGrantParams, additionalGrantParameters, false);
    }

    @Override
    public Uni<Tokens> refreshTokens(String refreshToken) {
        this.checkClosed();
        if (refreshToken == null) {
            throw new OidcClientException("Refresh token is null");
        }
        MultiMap refreshGrantParams = OidcClientImpl.copyMultiMap(this.commonRefreshGrantParams);
        refreshGrantParams.add("refresh_token", refreshToken);
        return this.getJsonResponse(refreshGrantParams, Collections.emptyMap(), true);
    }

    private Uni<Tokens> getJsonResponse(final MultiMap formBody, final Map<String, String> additionalGrantParameters, final boolean refresh) {
        return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends Tokens>>(){

            @Override
            public Uni<Tokens> get() {
                MultiMap body = formBody;
                HttpRequest request = OidcClientImpl.this.client.postAbs(OidcClientImpl.this.tokenRequestUri);
                request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
                if (OidcClientImpl.this.clientSecretBasicAuthScheme != null) {
                    request.putHeader(AUTHORIZATION_HEADER, OidcClientImpl.this.clientSecretBasicAuthScheme);
                } else if (OidcClientImpl.this.clientJwtKey != null) {
                    body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
                    body.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                    body.add("client_assertion", OidcCommonUtils.signJwtWithKey((OidcCommonConfig)OidcClientImpl.this.oidcConfig, (Key)OidcClientImpl.this.clientJwtKey));
                }
                if (!additionalGrantParameters.isEmpty()) {
                    body = OidcClientImpl.copyMultiMap(body);
                    for (Map.Entry entry : additionalGrantParameters.entrySet()) {
                        body.add((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                Uni response = request.sendBuffer(OidcCommonUtils.encodeForm((MultiMap)body)).onFailure(ConnectException.class).retry().atMost((long)OidcClientImpl.this.oidcConfig.connectionRetryCount).onFailure().transform(t -> t.getCause());
                return response.onItem().transform(resp -> OidcClientImpl.this.emitGrantTokens((HttpResponse<Buffer>)resp, refresh));
            }
        });
    }

    private Tokens emitGrantTokens(HttpResponse<Buffer> resp, boolean refresh) {
        if (resp.statusCode() == 200) {
            Long accessTokenExpiresAt;
            LOG.debugf("%s OidcClient has %s the tokens", (Object)this.oidcConfig.getId().get(), (Object)(refresh ? "refreshed" : "acquired"));
            JsonObject json = resp.bodyAsJsonObject();
            String accessToken = json.getString(this.oidcConfig.grant.accessTokenProperty);
            String refreshToken = json.getString(this.oidcConfig.grant.refreshTokenProperty);
            Object expiresInValue = json.getValue(this.oidcConfig.grant.expiresInProperty);
            if (expiresInValue != null) {
                long accessTokenExpiresIn = expiresInValue instanceof Number ? ((Number)expiresInValue).longValue() : Long.parseLong(expiresInValue.toString());
                accessTokenExpiresAt = Instant.now().getEpochSecond() + accessTokenExpiresIn;
            } else {
                accessTokenExpiresAt = OidcClientImpl.getExpiresJwtClaim(accessToken);
            }
            return new Tokens(accessToken, accessTokenExpiresAt, this.oidcConfig.refreshTokenTimeSkew.orElse(null), refreshToken, json);
        }
        String errorMessage = resp.bodyAsString();
        LOG.debugf("%s OidcClient has failed to complete the %s grant request:  status: %d, error message: %s", new Object[]{this.oidcConfig.getId().get(), refresh ? "refresh_token" : this.grantType, resp.statusCode(), errorMessage});
        throw new OidcClientException(errorMessage);
    }

    private static Long getExpiresJwtClaim(String accessToken) {
        JsonObject claims = OidcClientImpl.decodeJwtToken(accessToken);
        if (claims != null) {
            try {
                return claims.getLong(Claims.exp.name());
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"JWT expiry claim can not be converted to Long");
            }
        }
        return null;
    }

    private static JsonObject decodeJwtToken(String accessToken) {
        String[] parts = accessToken.split("\\.");
        if (parts.length == 3) {
            try {
                return new JsonObject(new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"JWT token can not be decoded using the Base64Url encoding scheme");
            }
        } else {
            LOG.debug((Object)"Access token is not formatted as the encoded JWT token");
        }
        return null;
    }

    private static MultiMap copyMultiMap(MultiMap oldMap) {
        MultiMap newMap = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        newMap.addAll(oldMap);
        return newMap;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.client.close();
            this.closed = true;
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("OidcClient " + this.oidcConfig.getId().get() + " is closed");
        }
    }
}

