/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client;

import io.vertx.core.json.JsonObject;
import java.time.Duration;

public class Tokens {
    private final String accessToken;
    private final Long accessTokenExpiresAt;
    private final Long refreshTokenTimeSkew;
    private final String refreshToken;
    private final JsonObject grantResponse;

    public Tokens(String accessToken, Long accessTokenExpiresAt, Duration refreshTokenTimeSkewDuration, String refreshToken, JsonObject grantResponse) {
        this.accessToken = accessToken;
        this.accessTokenExpiresAt = accessTokenExpiresAt;
        this.refreshTokenTimeSkew = refreshTokenTimeSkewDuration == null ? null : Long.valueOf(refreshTokenTimeSkewDuration.getSeconds());
        this.refreshToken = refreshToken;
        this.grantResponse = grantResponse;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String get(String propertyName) {
        return this.grantResponse.getString(propertyName);
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Long getAccessTokenExpiresAt() {
        return this.accessTokenExpiresAt;
    }

    public Long getRefreshTokenTimeSkew() {
        return this.refreshTokenTimeSkew;
    }

    public boolean isAccessTokenExpired() {
        if (this.accessTokenExpiresAt == null) {
            return false;
        }
        long nowSecs = System.currentTimeMillis() / 1000L;
        return nowSecs > this.accessTokenExpiresAt;
    }

    public boolean isAccessTokenWithinRefreshInterval() {
        if (this.accessTokenExpiresAt == null || this.refreshTokenTimeSkew == null) {
            return false;
        }
        long nowSecs = System.currentTimeMillis() / 1000L;
        return nowSecs + this.refreshTokenTimeSkew > this.accessTokenExpiresAt;
    }
}

