/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.runtime;

import io.quarkus.kubernetes.service.binding.runtime.KubernetesServiceBindingConfig;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class KubernetesServiceBindingConfigSourceFactory
implements ConfigSourceFactory {
    private static final Logger log = Logger.getLogger(KubernetesServiceBindingConfigSourceFactory.class);

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSourceContext.ConfigSourceContextConfigSource(context)}).withMapping(KubernetesServiceBindingConfig.class).withMappingIgnore("quarkus.**").build();
        KubernetesServiceBindingConfig kubernetesServiceBindingConfig = (KubernetesServiceBindingConfig)config.getConfigMapping(KubernetesServiceBindingConfig.class);
        if (!kubernetesServiceBindingConfig.enabled()) {
            log.debug((Object)"No attempt will be made to bind configuration based on Kubernetes ServiceBinding because the feature was not enabled.");
            return Collections.emptyList();
        }
        if (kubernetesServiceBindingConfig.root().isEmpty()) {
            log.debug((Object)"No attempt will be made to bind configuration based on Kubernetes Service Binding because the binding root was not specified.");
            return Collections.emptyList();
        }
        List<ServiceBinding> serviceBindings = KubernetesServiceBindingConfigSourceFactory.getServiceBindings(kubernetesServiceBindingConfig.root().get());
        if (serviceBindings.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getConfigSources(serviceBindings, KubernetesServiceBindingConfigSourceFactory.determineConverters());
    }

    Iterable<ConfigSource> getConfigSources(List<ServiceBinding> serviceBindings, List<ServiceBindingConverter> serviceBindingConverters) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        for (ServiceBindingConverter converter : serviceBindingConverters) {
            Optional<ServiceBindingConfigSource> optional = converter.convert(serviceBindings);
            if (!optional.isPresent()) continue;
            result.add((ConfigSource)optional.get());
        }
        for (ServiceBinding serviceBinding : serviceBindings) {
            Map<String, String> serviceBindingProperties = serviceBinding.getProperties();
            HashMap<String, String> rawConfigSourceProperties = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : serviceBindingProperties.entrySet()) {
                rawConfigSourceProperties.put("quarkus.service-binding." + serviceBinding.getName() + "." + entry.getKey(), entry.getValue());
            }
            result.add((ConfigSource)new ServiceBindingConfigSource("service-binding-" + serviceBinding.getName() + "-raw", rawConfigSourceProperties));
        }
        return result;
    }

    static List<ServiceBinding> getServiceBindings(String bindingRoot) {
        Path p = Paths.get(bindingRoot, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            log.warn((Object)("Service Binding root '" + p.toAbsolutePath() + "' does not exist"));
            return Collections.emptyList();
        }
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new IllegalArgumentException("Service Binding root '" + p + "' is not a directory");
        }
        File[] files = p.toFile().listFiles();
        if (files == null) {
            log.warn((Object)("Service Binding root '" + p.toAbsolutePath() + "' does not contain any sub-directories"));
            return Collections.emptyList();
        }
        log.debug((Object)("Found " + files.length + " potential Service Binding directories"));
        ArrayList<ServiceBinding> serviceBindings = new ArrayList<ServiceBinding>(files.length);
        for (File f : files) {
            ServiceBinding sb = new ServiceBinding(f.toPath());
            serviceBindings.add(sb);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Directory '%s' contains %d %s and will be used as Service Binding %s", f.toPath().toAbsolutePath(), sb.getProperties().size(), sb.getProperties().size() == 1 ? "property" : "properties", sb));
        }
        serviceBindings.sort(new Comparator<ServiceBinding>(){

            @Override
            public int compare(ServiceBinding o1, ServiceBinding o2) {
                if (!o1.getName().equals(o2.getName())) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o1.getProvider().compareTo(o2.getProvider());
            }
        });
        return serviceBindings;
    }

    static List<ServiceBindingConverter> determineConverters() {
        ArrayList<ServiceBindingConverter> result = new ArrayList<ServiceBindingConverter>();
        ServiceLoader<ServiceBindingConverter> loader = ServiceLoader.load(ServiceBindingConverter.class, Thread.currentThread().getContextClassLoader());
        for (ServiceBindingConverter c : loader) {
            result.add(c);
        }
        return result;
    }
}

