/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import io.quarkus.kubernetes.client.runtime.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.client.runtime.KubernetesClientProducer;
import io.quarkus.kubernetes.client.runtime.KubernetesClientRecorder;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class KubernetesClientProcessor {
    private static final DotName WATCHER = DotName.createSimple((String)"io.fabric8.kubernetes.client.Watcher");
    private static final DotName KUBERNETES_RESOURCE = DotName.createSimple((String)"io.fabric8.kubernetes.api.model.KubernetesResource");
    private static final Logger log = Logger.getLogger((String)KubernetesClientProcessor.class.getName());
    @Inject
    BuildProducer<FeatureBuildItem> featureProducer;
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClasses;
    @Inject
    BuildProducer<IgnoreJsonDeserializeClassBuildItem> ignoredJsonDeserializationClasses;
    KubernetesClientBuildConfig buildConfig;

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public void process(ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<BeanContainerListenerBuildItem> beanContainerListenerBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildItem, KubernetesClientRecorder recorder) {
        this.featureProducer.produce((BuildItem)new FeatureBuildItem("kubernetes-client"));
        HashSet watchedClasses = new HashSet();
        applicationIndex.getIndex().getAllKnownImplementors(WATCHER).forEach(c -> {
            block3: {
                try {
                    List watcherGenericTypes = JandexUtil.resolveTypeParameters((DotName)c.name(), (DotName)WATCHER, (IndexView)combinedIndexBuildItem.getIndex());
                    if (watcherGenericTypes.size() == 1) {
                        watchedClasses.add(((Type)watcherGenericTypes.get(0)).name().toString());
                    }
                }
                catch (IllegalStateException ignored) {
                    if (!applicationIndex.getIndex().getAllKnownSubclasses(c.name()).isEmpty()) break block3;
                    log.warn((Object)("Watcher '" + c.name() + "' will most likely not work correctly in native mode. Consider specifying the generic type of 'io.fabric8.kubernetes.client.Watcher' that this class handles. See https://quarkus.io/guides/kubernetes-client#note-on-implementing-the-watcher-interface for more details"));
                }
            }
        });
        if (!watchedClasses.isEmpty()) {
            this.reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, watchedClasses.toArray(new String[0])));
        }
        String[] modelClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownImplementors(KUBERNETES_RESOURCE).stream().peek(c -> this.ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(c.name()))).map(c -> c.name().toString()).filter(c -> !watchedClasses.contains(c)).toArray(String[]::new);
        this.reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.weakClass((String[])modelClasses));
        this.ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(DotName.createSimple((String)"io.fabric8.kubernetes.api.model.KubeSchema")));
        this.ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBERNETES_RESOURCE));
        String[] doneables = (String[])combinedIndexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)"io.fabric8.kubernetes.api.model.Doneable")).stream().map(c -> c.name().toString()).toArray(String[]::new);
        this.reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.weakClass((String[])doneables));
        String[] deserializerClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonDeserializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        this.reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, deserializerClasses));
        String[] serializerClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonSerializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        this.reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, serializerClasses));
        this.reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"io.fabric8.kubernetes.api.model.IntOrString"}));
        this.reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"io.fabric8.kubernetes.internal.KubernetesDeserializer"}));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("kubernetes-client"));
        additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientProducer.class));
        beanContainerListenerBuildItem.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.setBuildConfig(this.buildConfig)));
    }
}

