/*
 * Decompiled with CFR 0.152.
 */
package io.qt.sql.jdbc;

import io.qt.core.QMetaType;
import java.util.HashMap;

class QJdbcSqlVariantUtil {
    private static HashMap<String, QMetaType.Type> javaToVariant = new HashMap();

    QJdbcSqlVariantUtil() {
    }

    static QMetaType javaTypeToVariantType(String javaType) {
        QMetaType.Type variantType = javaToVariant.get(javaType);
        if (variantType == null) {
            return new QMetaType();
        }
        return new QMetaType(variantType);
    }

    static QMetaType javaTypeIdToVariantType(int variantType) {
        switch (variantType) {
            case 1: 
            case 12: {
                return new QMetaType(QMetaType.Type.QString);
            }
            case -6: 
            case 4: 
            case 5: {
                return new QMetaType(QMetaType.Type.Int);
            }
            case -7: 
            case 16: {
                return new QMetaType(QMetaType.Type.Bool);
            }
            case -5: 
            case 3: {
                return new QMetaType(QMetaType.Type.LongLong);
            }
            case 91: {
                return new QMetaType(QMetaType.Type.QDate);
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return new QMetaType(QMetaType.Type.Double);
            }
            case 92: {
                return new QMetaType(QMetaType.Type.QTime);
            }
            case 93: {
                return new QMetaType(QMetaType.Type.QDateTime);
            }
        }
        return new QMetaType();
    }

    static {
        javaToVariant.put(null, QMetaType.Type.UnknownType);
        javaToVariant.put("java.lang.String", QMetaType.Type.QString);
        javaToVariant.put("java.lang.Integer", QMetaType.Type.Int);
        javaToVariant.put("java.lang.Short", QMetaType.Type.Int);
        javaToVariant.put("java.lang.Byte", QMetaType.Type.Int);
        javaToVariant.put("java.lang.Boolean", QMetaType.Type.Bool);
        javaToVariant.put("java.lang.Byte[]", QMetaType.Type.QByteArray);
        javaToVariant.put("java.util.Date", QMetaType.Type.QDate);
        javaToVariant.put("java.sql.Date", QMetaType.Type.QDate);
        javaToVariant.put("java.lang.Float", QMetaType.Type.Double);
        javaToVariant.put("java.lang.Double", QMetaType.Type.Double);
        javaToVariant.put("java.lang.Long", QMetaType.Type.LongLong);
        javaToVariant.put("java.sql.Time", QMetaType.Type.QTime);
        javaToVariant.put("java.sql.TimeStamp", QMetaType.Type.QDateTime);
        javaToVariant.put("java.net.Url", QMetaType.Type.QUrl);
    }
}

