package io.qt.opengl;

import io.qt.*;


/**
 * <p>Enables painting to an OpenGL context using QPainter</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html">QOpenGLPaintDevice</a></code></p>
 */
public class QOpenGLPaintDevice extends QtObject
    implements io.qt.gui.QPaintDevice
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#QOpenGLPaintDevice">QOpenGLPaintDevice::<wbr/>QOpenGLPaintDevice()</a></code></p>
     */
    public QOpenGLPaintDevice(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLPaintDevice instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#QOpenGLPaintDevice-1">QOpenGLPaintDevice::<wbr/>QOpenGLPaintDevice(QSize)</a></code></p>
     * @param size
     */
    public QOpenGLPaintDevice(io.qt.core.@NonNull QSize size){
        super((QPrivateConstructor)null);
        initialize_native(this, size);
    }
    
    private native static void initialize_native(QOpenGLPaintDevice instance, io.qt.core.QSize size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#QOpenGLPaintDevice-2">QOpenGLPaintDevice::<wbr/>QOpenGLPaintDevice(int,<wbr/>int)</a></code></p>
     * @param width
     * @param height
     */
    public QOpenGLPaintDevice(int width, int height){
        super((QPrivateConstructor)null);
        initialize_native(this, width, height);
    }
    
    private native static void initialize_native(QOpenGLPaintDevice instance, int width, int height);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#colorCount">QPaintDevice::<wbr/>colorCount()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int colorCount(){
        return colorCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int colorCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#context">QOpenGLPaintDevice::<wbr/>context()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.gui.@Nullable QOpenGLContext context(){
        return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QOpenGLContext context_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#depth">QPaintDevice::<wbr/>depth()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#devicePixelRatio">QPaintDevice::<wbr/>devicePixelRatio()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final double devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#devicePixelRatioF">QPaintDevice::<wbr/>devicePixelRatioF()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final double devicePixelRatioF(){
        return devicePixelRatioF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatioF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#dotsPerMeterX">QOpenGLPaintDevice::<wbr/>dotsPerMeterX()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final double dotsPerMeterX(){
        return dotsPerMeterX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double dotsPerMeterX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#dotsPerMeterY">QOpenGLPaintDevice::<wbr/>dotsPerMeterY()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final double dotsPerMeterY(){
        return dotsPerMeterY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double dotsPerMeterY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#height">QPaintDevice::<wbr/>height()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#heightMM">QPaintDevice::<wbr/>heightMM()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int heightMM(){
        return heightMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int heightMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#logicalDpiX">QPaintDevice::<wbr/>logicalDpiX()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int logicalDpiX(){
        return logicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#logicalDpiY">QPaintDevice::<wbr/>logicalDpiY()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int logicalDpiY(){
        return logicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#paintFlipped">QOpenGLPaintDevice::<wbr/>paintFlipped()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean paintFlipped(){
        return paintFlipped_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean paintFlipped_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#paintingActive">QPaintDevice::<wbr/>paintingActive()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean paintingActive(){
        return paintingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean paintingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#physicalDpiX">QPaintDevice::<wbr/>physicalDpiX()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int physicalDpiX(){
        return physicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#physicalDpiY">QPaintDevice::<wbr/>physicalDpiY()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int physicalDpiY(){
        return physicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setDevicePixelRatio">QOpenGLPaintDevice::<wbr/>setDevicePixelRatio(qreal)</a></code></p>
     * @param devicePixelRatio
     */
    @QtUninvokable
    public final void setDevicePixelRatio(double devicePixelRatio){
        setDevicePixelRatio_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), devicePixelRatio);
    }
    
    @QtUninvokable
    private native void setDevicePixelRatio_native_qreal(long __this__nativeId, double devicePixelRatio);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setDotsPerMeterX">QOpenGLPaintDevice::<wbr/>setDotsPerMeterX(qreal)</a></code></p>
     * @param arg__1
     */
    @QtUninvokable
    public final void setDotsPerMeterX(double arg__1){
        setDotsPerMeterX_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setDotsPerMeterX_native_qreal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setDotsPerMeterY">QOpenGLPaintDevice::<wbr/>setDotsPerMeterY(qreal)</a></code></p>
     * @param arg__1
     */
    @QtUninvokable
    public final void setDotsPerMeterY(double arg__1){
        setDotsPerMeterY_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setDotsPerMeterY_native_qreal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setPaintFlipped">QOpenGLPaintDevice::<wbr/>setPaintFlipped(bool)</a></code></p>
     * @param flipped
     */
    @QtUninvokable
    public final void setPaintFlipped(boolean flipped){
        setPaintFlipped_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), flipped);
    }
    
    @QtUninvokable
    private native void setPaintFlipped_native_bool(long __this__nativeId, boolean flipped);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setSize">QOpenGLPaintDevice::<wbr/>setSize(QSize)</a></code></p>
     * @param size
     */
    @QtUninvokable
    public final void setSize(io.qt.core.@NonNull QSize size){
        setSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @QtUninvokable
    private native void setSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#size">QOpenGLPaintDevice::<wbr/>size()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#width">QPaintDevice::<wbr/>width()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#widthMM">QPaintDevice::<wbr/>widthMM()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int widthMM(){
        return widthMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int widthMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpaintdevice.html#ensureActiveTarget">QOpenGLPaintDevice::<wbr/>ensureActiveTarget()</a></code></p>
     */
    @QtUninvokable
    public void ensureActiveTarget(){
        ensureActiveTarget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void ensureActiveTarget_native(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr/>initPainter(QPainter*)const</code></p>
     * @param painter
     */
    @QtUninvokable
    protected void initPainter(io.qt.gui.@Nullable QPainter painter){
        initPainter_native_QPainter_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
    }
    
    private native static void initPainter_native_QPainter_ptr_constfct(long __this__nativeId, long painter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#metric">QPaintDevice::<wbr/>metric(QPaintDevice::PaintDeviceMetric)const</a></code></p>
     * @param metric
     * @return
     */
    @QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#paintEngine">QPaintDevice::<wbr/>paintEngine()const</a></code></p>
     * @return
     */
    @QtUninvokable
    @Override
    public io.qt.gui.@Nullable QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr/>redirected(QPoint*)const</code></p>
     * @param offset
     * @return
     */
    @QtUninvokable
    protected io.qt.gui.@Nullable QPaintDevice redirected(io.qt.core.@Nullable QPoint offset){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(offset));
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, long offset);
    
    /**
     * <p>See <code>QPaintDevice::<wbr/>sharedPainter()const</code></p>
     * @return
     */
    @QtUninvokable
    protected io.qt.gui.@Nullable QPainter sharedPainter(){
        return sharedPainter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPainter sharedPainter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QPaintDevice::<wbr/>devicePixelRatioFScale()</code></p>
     * @return
     */
    public native static double devicePixelRatioFScale();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qpaintdevice.html#encodeMetricF">QPaintDevice::<wbr/>encodeMetricF(QPaintDevice::PaintDeviceMetric,<wbr/>double)</a></code></p>
     * @since This function was introduced in Qt 6.8.
     * @param metric
     * @param value
     * @return
     */
    public static int encodeMetricF(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric metric, double value){
        return encodeMetricF_native_QPaintDevice_PaintDeviceMetric_double(metric.value(), value);
    }
    
    private native static int encodeMetricF_native_QPaintDevice_PaintDeviceMetric_double(int metric, double value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLPaintDevice(QPrivateConstructor p) { super(p); } 
    
}
