package io.qt.opengl;

import io.qt.*;
import static io.qt.QtUtilities.*;

/**
 * @hidden
 */
@ModuleVersion(major=QtJambi_LibraryUtilities.qtMajorVersion, minor=QtJambi_LibraryUtilities.qtMinorVersion, patch=QtJambi_LibraryUtilities.qtJambiPatch)
final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 6;

    final static int qtMinorVersion = 8;

    final static int qtJambiPatch = 3;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.core");
            loadQtLibrary("DBus", LibraryRequirementMode.ProvideOnly, "macos", "linux");
            loadQtLibrary("EglFSDeviceIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Network", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Pdf", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Svg", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WaylandClient", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WaylandEglClientHwIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WlShellIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("XcbQpa", LibraryRequirementMode.ProvideOnly, "linux");
            loadUtilityLibrary("d3dcompiler_47", LibraryRequirementMode.ProvideOnly, "windows");
            loadUtilityLibrary("opengl32sw", LibraryRequirementMode.ProvideOnly, "windows");
            loadQtLibrary("Gui", LibraryRequirementMode.Mandatory);
            loadQtLibrary("OpenGL", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("OpenGL");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

