package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL 2.0 specification</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglfunctions-2-0.html">QOpenGLFunctions_2_0</a></code></p>
 */
public class QOpenGLFunctions_2_0 extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>QOpenGLFunctions_2_0()</code></p>
     */
    public QOpenGLFunctions_2_0(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_2_0 instance);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glAccum(GLenum,<wbr/>GLfloat)</code></p>
     * @param op
     * @param value
     */
    @QtUninvokable
    public final void glAccum(int op, float value){
        glAccum_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), op, value);
    }
    
    @QtUninvokable
    private native void glAccum_native_GLenum_GLfloat(long __this__nativeId, int op, float value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glActiveTexture(GLenum)</code></p>
     * @param texture
     */
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glAlphaFunc(GLenum,<wbr/>GLfloat)</code></p>
     * @param func
     * @param ref
     */
    @QtUninvokable
    public final void glAlphaFunc(int func, float ref){
        glAlphaFunc_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref);
    }
    
    @QtUninvokable
    private native void glAlphaFunc_native_GLenum_GLfloat(long __this__nativeId, int func, float ref);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glAreTexturesResident(GLsizei,<wbr/>const GLuint*,<wbr/>GLboolean*)</code></p>
     * @param textures
     * @param residences
     * @return
     */
    @QtUninvokable
    public final boolean glAreTexturesResident(java.nio.@Nullable IntBuffer textures, boolean[] residences){
        return glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), textures, residences);
    }
    
    @QtUninvokable
    private native boolean glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(long __this__nativeId, java.nio.IntBuffer textures, boolean[] residences);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glArrayElement(GLint)</code></p>
     * @param i
     */
    @QtUninvokable
    public final void glArrayElement(int i){
        glArrayElement_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glArrayElement_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glAttachShader(GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param shader
     */
    @QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBegin(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glBegin(int mode){
        glBegin_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBegin_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBeginQuery(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param id
     */
    @QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBindAttribLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param index
     * @param name
     */
    @QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.@Nullable CharBuffer name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBindBuffer(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param buffer
     */
    @QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBindTexture(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param texture
     */
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBitmap(GLsizei,<wbr/>GLsizei,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>const GLubyte*)</code></p>
     * @param width
     * @param height
     * @param xorig
     * @param yorig
     * @param xmove
     * @param ymove
     * @param bitmap
     */
    @QtUninvokable
    public final void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.@Nullable ByteBuffer bitmap){
        glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, xorig, yorig, xmove, ymove, bitmap);
    }
    
    @QtUninvokable
    private native void glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(long __this__nativeId, int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.ByteBuffer bitmap);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBlendColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBlendEquation(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBlendEquationSeparate(GLenum,<wbr/>GLenum)</code></p>
     * @param modeRGB
     * @param modeAlpha
     */
    @QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBlendFunc(GLenum,<wbr/>GLenum)</code></p>
     * @param sfactor
     * @param dfactor
     */
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBlendFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param sfactorRGB
     * @param dfactorRGB
     * @param sfactorAlpha
     * @param dfactorAlpha
     */
    @QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBufferData(GLenum,<wbr/>GLsizeiptr,<wbr/>const GLvoid*,<wbr/>GLenum)</code></p>
     * @param target
     * @param size
     * @param data
     * @param usage
     */
    @QtUninvokable
    public final void glBufferData(int target, long size, java.nio.@Nullable Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param offset
     * @param size
     * @param data
     */
    @QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCallList(GLuint)</code></p>
     * @param list
     */
    @QtUninvokable
    public final void glCallList(int list){
        glCallList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native void glCallList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCallLists(GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param n
     * @param type
     * @param lists
     */
    @QtUninvokable
    public final void glCallLists(int n, int type, java.nio.@Nullable Buffer lists){
        glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, type, lists);
    }
    
    @QtUninvokable
    private native void glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int n, int type, java.nio.Buffer lists);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClear(GLbitfield)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClearAccum(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glClearAccum(float red, float green, float blue, float alpha){
        glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClearColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClearDepth(GLdouble)</code></p>
     * @param depth
     */
    @QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClearIndex(GLfloat)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glClearIndex(float c){
        glClearIndex_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glClearIndex_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClearStencil(GLint)</code></p>
     * @param s
     */
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClientActiveTexture(GLenum)</code></p>
     * @param texture
     */
    @QtUninvokable
    public final void glClientActiveTexture(int texture){
        glClientActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glClientActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glClipPlane(GLenum,<wbr/>const GLdouble*)</code></p>
     * @param plane
     * @param equation
     */
    @QtUninvokable
    public final void glClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glClipPlane_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glClipPlane_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glColor3b(byte red, byte green, byte blue){
        glColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3bv(const GLbyte*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glColor3d(double red, double green, double blue){
        glColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glColor3f(float red, float green, float blue){
        glColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glColor3i(int red, int green, int blue){
        glColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glColor3s(short red, short green, short blue){
        glColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor3sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColor4b(byte red, byte green, byte blue, byte alpha){
        glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue, byte alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4bv(const GLbyte*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor4bv(byte[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColor4d(double red, double green, double blue, double alpha){
        glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue, double alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColor4f(float red, float green, float blue, float alpha){
        glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColor4i(int red, int green, int blue, int alpha){
        glColor4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue, int alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColor4s(short red, short green, short blue, short alpha){
        glColor4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue, short alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColor4sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glColor4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColorMask(GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColorMaterial(GLenum,<wbr/>GLenum)</code></p>
     * @param face
     * @param mode
     */
    @QtUninvokable
    public final void glColorMaterial(int face, int mode){
        glColorMaterial_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glColorMaterial_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColorPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param size
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glColorPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColorSubTable(GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param start
     * @param count
     * @param format
     * @param type
     * @param data
     */
    @QtUninvokable
    public final void glColorSubTable(int target, int start, int count, int format, int type, java.nio.@Nullable Buffer data){
        glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, count, format, type, data);
    }
    
    @QtUninvokable
    private native void glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int start, int count, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColorTable(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param internalformat
     * @param width
     * @param format
     * @param type
     * @param table
     */
    @QtUninvokable
    public final void glColorTable(int target, int internalformat, int width, int format, int type, java.nio.@Nullable Buffer table){
        glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, table);
    }
    
    @QtUninvokable
    private native void glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColorTableParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glColorTableParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glColorTableParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glColorTableParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCompileShader(GLuint)</code></p>
     * @param shader
     */
    @QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCompressedTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param border
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCompressedTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param border
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCompressedTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param depth
     * @param border
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCompressedTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param width
     * @param format
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCompressedTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param width
     * @param height
     * @param format
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCompressedTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param zoffset
     * @param width
     * @param height
     * @param depth
     * @param format
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glConvolutionFilter1D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param internalformat
     * @param width
     * @param format
     * @param type
     * @param image
     */
    @QtUninvokable
    public final void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, java.nio.@Nullable Buffer image){
        glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glConvolutionFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param internalformat
     * @param width
     * @param height
     * @param format
     * @param type
     * @param image
     */
    @QtUninvokable
    public final void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.@Nullable Buffer image){
        glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glConvolutionParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glConvolutionParameterf(int target, int pname, float params){
        glConvolutionParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glConvolutionParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glConvolutionParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glConvolutionParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glConvolutionParameteri(int target, int pname, int params){
        glConvolutionParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glConvolutionParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glConvolutionParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyColorSubTable(GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param target
     * @param start
     * @param x
     * @param y
     * @param width
     */
    @QtUninvokable
    public final void glCopyColorSubTable(int target, int start, int x, int y, int width){
        glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(long __this__nativeId, int target, int start, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyColorTable(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param target
     * @param internalformat
     * @param x
     * @param y
     * @param width
     */
    @QtUninvokable
    public final void glCopyColorTable(int target, int internalformat, int x, int y, int width){
        glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyConvolutionFilter1D(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param target
     * @param internalformat
     * @param x
     * @param y
     * @param width
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter1D(int target, int internalformat, int x, int y, int width){
        glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyConvolutionFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param internalformat
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter2D(int target, int internalformat, int x, int y, int width, int height){
        glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     * @param type
     */
    @QtUninvokable
    public final void glCopyPixels(int x, int y, int width, int height, int type){
        glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, type);
    }
    
    @QtUninvokable
    private native void glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(long __this__nativeId, int x, int y, int width, int height, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param x
     * @param y
     * @param width
     * @param border
     */
    @QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param x
     * @param y
     * @param width
     * @param height
     * @param border
     */
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param x
     * @param y
     * @param width
     */
    @QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCopyTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param zoffset
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCreateProgram()</code></p>
     * @return
     */
    @QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCreateShader(GLenum)</code></p>
     * @param type
     * @return
     */
    @QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glCullFace(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDeleteBuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param buffers
     */
    @QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDeleteLists(GLuint,<wbr/>GLsizei)</code></p>
     * @param list
     * @param range
     */
    @QtUninvokable
    public final void glDeleteLists(int list, int range){
        glDeleteLists_native_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), list, range);
    }
    
    @QtUninvokable
    private native void glDeleteLists_native_GLuint_GLsizei(long __this__nativeId, int list, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDeleteProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDeleteQueries(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param ids
     */
    @QtUninvokable
    public final void glDeleteQueries(int n, java.nio.@Nullable IntBuffer ids){
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDeleteShader(GLuint)</code></p>
     * @param shader
     */
    @QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDeleteTextures(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param textures
     */
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.@Nullable IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDepthFunc(GLenum)</code></p>
     * @param func
     */
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDepthMask(GLboolean)</code></p>
     * @param flag
     */
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDepthRange(GLdouble,<wbr/>GLdouble)</code></p>
     * @param nearVal
     * @param farVal
     */
    @QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDetachShader(GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param shader
     */
    @QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDisable(GLenum)</code></p>
     * @param cap
     */
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDisableClientState(GLenum)</code></p>
     * @param array
     */
    @QtUninvokable
    public final void glDisableClientState(int array){
        glDisableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glDisableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDisableVertexAttribArray(GLuint)</code></p>
     * @param index
     */
    @QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDrawArrays(GLenum,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param first
     * @param count
     */
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDrawBuffer(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glDrawBuffer(int mode){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDrawBuffers(GLsizei,<wbr/>const GLenum*)</code></p>
     * @param n
     * @param bufs
     */
    @QtUninvokable
    public final void glDrawBuffers(int n, java.nio.@Nullable IntBuffer bufs){
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDrawElements(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     */
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDrawPixels(GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param width
     * @param height
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glDrawPixels(int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glDrawRangeElements(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param mode
     * @param start
     * @param end
     * @param count
     * @param type
     * @param indices
     */
    @QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEdgeFlag(GLboolean)</code></p>
     * @param flag
     */
    @QtUninvokable
    public final void glEdgeFlag(boolean flag){
        glEdgeFlag_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glEdgeFlag_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEdgeFlagPointer(GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glEdgeFlagPointer(int stride, java.nio.@Nullable Buffer pointer){
        glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), stride, pointer);
    }
    
    @QtUninvokable
    private native void glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(long __this__nativeId, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEnable(GLenum)</code></p>
     * @param cap
     */
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEnableClientState(GLenum)</code></p>
     * @param array
     */
    @QtUninvokable
    public final void glEnableClientState(int array){
        glEnableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glEnableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEnableVertexAttribArray(GLuint)</code></p>
     * @param index
     */
    @QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEnd()</code></p>
     */
    @QtUninvokable
    public final void glEnd(){
        glEnd_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEnd_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEndList()</code></p>
     */
    @QtUninvokable
    public final void glEndList(){
        glEndList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndList_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEndQuery(GLenum)</code></p>
     * @param target
     */
    @QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord1d(GLdouble)</code></p>
     * @param u
     */
    @QtUninvokable
    public final void glEvalCoord1d(double u){
        glEvalCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1d_native_GLdouble(long __this__nativeId, double u);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord1dv(const GLdouble*)</code></p>
     * @param u
     */
    @QtUninvokable
    public final void glEvalCoord1dv(double[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord1f(GLfloat)</code></p>
     * @param u
     */
    @QtUninvokable
    public final void glEvalCoord1f(float u){
        glEvalCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1f_native_GLfloat(long __this__nativeId, float u);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord1fv(const GLfloat*)</code></p>
     * @param u
     */
    @QtUninvokable
    public final void glEvalCoord1fv(float[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord2d(GLdouble,<wbr/>GLdouble)</code></p>
     * @param u
     * @param v
     */
    @QtUninvokable
    public final void glEvalCoord2d(double u, double v){
        glEvalCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double u, double v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord2dv(const GLdouble*)</code></p>
     * @param u
     */
    @QtUninvokable
    public final void glEvalCoord2dv(double[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord2f(GLfloat,<wbr/>GLfloat)</code></p>
     * @param u
     * @param v
     */
    @QtUninvokable
    public final void glEvalCoord2f(float u, float v){
        glEvalCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float u, float v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalCoord2fv(const GLfloat*)</code></p>
     * @param u
     */
    @QtUninvokable
    public final void glEvalCoord2fv(float[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalMesh1(GLenum,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param mode
     * @param i1
     * @param i2
     */
    @QtUninvokable
    public final void glEvalMesh1(int mode, int i1, int i2){
        glEvalMesh1_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2);
    }
    
    @QtUninvokable
    private native void glEvalMesh1_native_GLenum_GLint_GLint(long __this__nativeId, int mode, int i1, int i2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalMesh2(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param mode
     * @param i1
     * @param i2
     * @param j1
     * @param j2
     */
    @QtUninvokable
    public final void glEvalMesh2(int mode, int i1, int i2, int j1, int j2){
        glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2, j1, j2);
    }
    
    @QtUninvokable
    private native void glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int mode, int i1, int i2, int j1, int j2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalPoint1(GLint)</code></p>
     * @param i
     */
    @QtUninvokable
    public final void glEvalPoint1(int i){
        glEvalPoint1_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glEvalPoint1_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glEvalPoint2(GLint,<wbr/>GLint)</code></p>
     * @param i
     * @param j
     */
    @QtUninvokable
    public final void glEvalPoint2(int i, int j){
        glEvalPoint2_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i, j);
    }
    
    @QtUninvokable
    private native void glEvalPoint2_native_GLint_GLint(long __this__nativeId, int i, int j);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFeedbackBuffer(GLsizei,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param type
     * @param buffer
     */
    @QtUninvokable
    public final void glFeedbackBuffer(int type, java.nio.@Nullable FloatBuffer buffer){
        glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, buffer);
    }
    
    @QtUninvokable
    private native void glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(long __this__nativeId, int type, java.nio.FloatBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFinish()</code></p>
     */
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFlush()</code></p>
     */
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogCoordPointer(GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glFogCoordPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glFogCoordPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glFogCoordPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogCoordd(GLdouble)</code></p>
     * @param coord
     */
    @QtUninvokable
    public final void glFogCoordd(double coord){
        glFogCoordd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordd_native_GLdouble(long __this__nativeId, double coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogCoorddv(const GLdouble*)</code></p>
     * @param coord
     */
    @QtUninvokable
    public final void glFogCoorddv(java.nio.@Nullable DoubleBuffer coord){
        glFogCoorddv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoorddv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogCoordf(GLfloat)</code></p>
     * @param coord
     */
    @QtUninvokable
    public final void glFogCoordf(float coord){
        glFogCoordf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordf_native_GLfloat(long __this__nativeId, float coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogCoordfv(const GLfloat*)</code></p>
     * @param coord
     */
    @QtUninvokable
    public final void glFogCoordfv(java.nio.@Nullable FloatBuffer coord){
        glFogCoordfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordfv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogf(GLenum,<wbr/>GLfloat)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glFogf(int pname, float param){
        glFogf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogfv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glFogfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogi(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glFogi(int pname, int param){
        glFogi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFogiv(GLenum,<wbr/>const GLint*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glFogiv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogiv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogiv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFrontFace(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glFrustum(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param left
     * @param right
     * @param bottom
     * @param top
     * @param zNear
     * @param zFar
     */
    @QtUninvokable
    public final void glFrustum(double left, double right, double bottom, double top, double zNear, double zFar){
        glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGenBuffers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param buffers
     */
    @QtUninvokable
    public final void glGenBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGenLists(GLsizei)</code></p>
     * @param range
     * @return
     */
    @QtUninvokable
    public final int glGenLists(int range){
        return glGenLists_native_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), range);
    }
    
    @QtUninvokable
    private native int glGenLists_native_GLsizei(long __this__nativeId, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGenQueries(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param ids
     */
    @QtUninvokable
    public final void glGenQueries(int n, java.nio.@Nullable IntBuffer ids){
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGenTextures(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param textures
     */
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.@Nullable IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetActiveAttrib(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param index
     * @param bufSize
     * @param length
     * @param size
     * @param type
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetActiveUniform(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param index
     * @param bufSize
     * @param length
     * @param size
     * @param type
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetAttachedShaders(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLuint*)</code></p>
     * @param program
     * @param maxCount
     * @param count
     * @param obj
     */
    @QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.@Nullable IntBuffer count, java.nio.@Nullable IntBuffer obj){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, obj);
    }
    
    @QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetAttribLocation(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetBooleanv(GLenum,<wbr/>GLboolean*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetBufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetBufferPointerv(GLenum,<wbr/>GLenum,<wbr/>GLvoid**)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.@Nullable Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param offset
     * @param size
     * @param data
     */
    @QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetClipPlane(GLenum,<wbr/>GLdouble*)</code></p>
     * @param plane
     * @param equation
     */
    @QtUninvokable
    public final void glGetClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glGetClipPlane_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glGetClipPlane_native_GLenum_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetColorTable(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param format
     * @param type
     * @param table
     */
    @QtUninvokable
    public final void glGetColorTable(int target, int format, int type, java.nio.@Nullable Buffer table){
        glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, table);
    }
    
    @QtUninvokable
    private native void glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetColorTableParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetColorTableParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetColorTableParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetColorTableParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetCompressedTexImage(GLenum,<wbr/>GLint,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param level
     * @param img
     */
    @QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.@Nullable Buffer img){
        glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetConvolutionFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param format
     * @param type
     * @param image
     */
    @QtUninvokable
    public final void glGetConvolutionFilter(int target, int format, int type, java.nio.@Nullable Buffer image){
        glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, image);
    }
    
    @QtUninvokable
    private native void glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetConvolutionParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetConvolutionParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetConvolutionParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetConvolutionParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetDoublev(GLenum,<wbr/>GLdouble*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetDoublev(int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetError()</code></p>
     * @return
     */
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetFloatv(GLenum,<wbr/>GLfloat*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetFloatv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetHistogram(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param reset
     * @param format
     * @param type
     * @param values
     */
    @QtUninvokable
    public final void glGetHistogram(int target, boolean reset, int format, int type, java.nio.@Nullable Buffer values){
        glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetHistogramParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetHistogramParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetHistogramParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetHistogramParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetIntegerv(GLenum,<wbr/>GLint*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetIntegerv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetLightfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param light
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetLightiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param light
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMapdv(GLenum,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     * @param target
     * @param query
     * @param v
     */
    @QtUninvokable
    public final void glGetMapdv(int target, int query, double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int target, int query, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMapfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param query
     * @param v
     */
    @QtUninvokable
    public final void glGetMapfv(int target, int query, float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int query, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMapiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param query
     * @param v
     */
    @QtUninvokable
    public final void glGetMapiv(int target, int query, int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int query, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMaterialfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param face
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMaterialiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param face
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMinmax(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param reset
     * @param format
     * @param type
     * @param values
     */
    @QtUninvokable
    public final void glGetMinmax(int target, boolean reset, int format, int type, java.nio.@Nullable Buffer values){
        glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMinmaxParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetMinmaxParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetMinmaxParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetMinmaxParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetPixelMapfv(GLenum,<wbr/>GLfloat*)</code></p>
     * @param map
     * @param values
     */
    @QtUninvokable
    public final void glGetPixelMapfv(int map, java.nio.@Nullable FloatBuffer values){
        glGetPixelMapfv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapfv_native_GLenum_GLfloat_ptr(long __this__nativeId, int map, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetPixelMapuiv(GLenum,<wbr/>GLuint*)</code></p>
     * @param map
     * @param values
     */
    @QtUninvokable
    public final void glGetPixelMapuiv(int map, java.nio.@Nullable IntBuffer values){
        glGetPixelMapuiv_native_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapuiv_native_GLenum_GLuint_ptr(long __this__nativeId, int map, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetPixelMapusv(GLenum,<wbr/>GLushort*)</code></p>
     * @param map
     * @param values
     */
    @QtUninvokable
    public final void glGetPixelMapusv(int map, java.nio.@Nullable ShortBuffer values){
        glGetPixelMapusv_native_GLenum_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapusv_native_GLenum_GLushort_ptr(long __this__nativeId, int map, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetPointerv(GLenum,<wbr/>GLvoid**)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetPointerv(int pname, java.nio.Buffer @StrictNonNull[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetPointerv_native_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetPointerv_native_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetPolygonStipple(GLubyte*)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glGetPolygonStipple(java.nio.@Nullable ByteBuffer mask){
        glGetPolygonStipple_native_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glGetPolygonStipple_native_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetProgramInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param bufSize
     * @param length
     * @param infoLog
     */
    @QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetProgramiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetQueryObjectiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param id
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetQueryObjectuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     * @param id
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetQueryiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetSeparableFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*,<wbr/>GLvoid*,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param format
     * @param type
     * @param row
     * @param column
     * @param span
     */
    @QtUninvokable
    public final void glGetSeparableFilter(int target, int format, int type, java.nio.@Nullable Buffer row, java.nio.@Nullable Buffer column, java.nio.@Nullable Buffer span){
        glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, row, column, span);
    }
    
    @QtUninvokable
    private native void glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer row, java.nio.Buffer column, java.nio.Buffer span);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetShaderInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param shader
     * @param bufSize
     * @param length
     * @param infoLog
     */
    @QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetShaderSource(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param shader
     * @param bufSize
     * @param length
     * @param source
     */
    @QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetShaderiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param shader
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.@Nullable IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetString(GLenum)</code></p>
     * @param name
     * @return
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetString_native_GLenum(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexEnvfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexEnvfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexEnviv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexEnviv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexGendv(GLenum,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     * @param coord
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexGendv(int coord, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int coord, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexGenfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param coord
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexGenfv(int coord, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int coord, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexGeniv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param coord
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexGeniv(int coord, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int coord, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexImage(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param target
     * @param level
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.@Nullable Buffer pixels){
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexLevelParameterfv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param level
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexLevelParameteriv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param level
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetUniformLocation(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetUniformfv(GLuint,<wbr/>GLint,<wbr/>GLfloat*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.@Nullable FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetUniformiv(GLuint,<wbr/>GLint,<wbr/>GLint*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetVertexAttribPointerv(GLuint,<wbr/>GLenum,<wbr/>GLvoid**)</code></p>
     * @param index
     * @param pname
     * @param pointer
     */
    @QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.@Nullable Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetVertexAttribdv(GLuint,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetVertexAttribfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.@Nullable FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glGetVertexAttribiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glHint(GLenum,<wbr/>GLenum)</code></p>
     * @param target
     * @param mode
     */
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glHistogram(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLboolean)</code></p>
     * @param target
     * @param width
     * @param internalformat
     * @param sink
     */
    @QtUninvokable
    public final void glHistogram(int target, int width, int internalformat, boolean sink){
        glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, width, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(long __this__nativeId, int target, int width, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexMask(GLuint)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glIndexMask(int mask){
        glIndexMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glIndexMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexPointer(GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glIndexPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexd(GLdouble)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexd(double c){
        glIndexd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexd_native_GLdouble(long __this__nativeId, double c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexdv(const GLdouble*)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexdv(double[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexdv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexdv_native_const_GLdouble_ptr(long __this__nativeId, double[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexf(GLfloat)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexf(float c){
        glIndexf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexf_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexfv(const GLfloat*)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexfv(float[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexfv_native_const_GLfloat_ptr(long __this__nativeId, float[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexi(GLint)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexi(int c){
        glIndexi_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexi_native_GLint(long __this__nativeId, int c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexiv(const GLint*)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexiv(int[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexiv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexiv_native_const_GLint_ptr(long __this__nativeId, int[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexs(GLshort)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexs(short c){
        glIndexs_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexs_native_GLshort(long __this__nativeId, short c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexsv(const GLshort*)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexsv(short[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexsv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexsv_native_const_GLshort_ptr(long __this__nativeId, short[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexub(GLubyte)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexub(byte c){
        glIndexub_native_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexub_native_GLubyte(long __this__nativeId, byte c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIndexubv(const GLubyte*)</code></p>
     * @param c
     */
    @QtUninvokable
    public final void glIndexubv(byte[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexubv_native_const_GLubyte_ptr(long __this__nativeId, byte[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glInitNames()</code></p>
     */
    @QtUninvokable
    public final void glInitNames(){
        glInitNames_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glInitNames_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glInterleavedArrays(GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param format
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glInterleavedArrays(int format, int stride, java.nio.@Nullable Buffer pointer){
        glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), format, stride, pointer);
    }
    
    @QtUninvokable
    private native void glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int format, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIsBuffer(GLuint)</code></p>
     * @param buffer
     * @return
     */
    @QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIsEnabled(GLenum)</code></p>
     * @param cap
     * @return
     */
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIsList(GLuint)</code></p>
     * @param list
     * @return
     */
    @QtUninvokable
    public final boolean glIsList(int list){
        return glIsList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native boolean glIsList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIsProgram(GLuint)</code></p>
     * @param program
     * @return
     */
    @QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIsQuery(GLuint)</code></p>
     * @param id
     * @return
     */
    @QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIsShader(GLuint)</code></p>
     * @param shader
     * @return
     */
    @QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glIsTexture(GLuint)</code></p>
     * @param texture
     * @return
     */
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLightModelf(GLenum,<wbr/>GLfloat)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glLightModelf(int pname, float param){
        glLightModelf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModelf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLightModelfv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glLightModelfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModelfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModelfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLightModeli(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glLightModeli(int pname, int param){
        glLightModeli_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModeli_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLightModeliv(GLenum,<wbr/>const GLint*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glLightModeliv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModeliv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModeliv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLightf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param light
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glLightf(int light, int pname, float param){
        glLightf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLightf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int light, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLightfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param light
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLighti(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param light
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glLighti(int light, int pname, int param){
        glLighti_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLighti_native_GLenum_GLenum_GLint(long __this__nativeId, int light, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLightiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param light
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLineStipple(GLint,<wbr/>GLushort)</code></p>
     * @param factor
     * @param pattern
     */
    @QtUninvokable
    public final void glLineStipple(int factor, short pattern){
        glLineStipple_native_GLint_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), factor, pattern);
    }
    
    @QtUninvokable
    private native void glLineStipple_native_GLint_GLushort(long __this__nativeId, int factor, short pattern);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLineWidth(GLfloat)</code></p>
     * @param width
     */
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLinkProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glListBase(GLuint)</code></p>
     * @param base
     */
    @QtUninvokable
    public final void glListBase(int base){
        glListBase_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), base);
    }
    
    @QtUninvokable
    private native void glListBase_native_GLuint(long __this__nativeId, int base);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLoadIdentity()</code></p>
     */
    @QtUninvokable
    public final void glLoadIdentity(){
        glLoadIdentity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glLoadIdentity_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLoadMatrixd(const GLdouble*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glLoadMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLoadMatrixf(const GLfloat*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glLoadMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLoadName(GLuint)</code></p>
     * @param name
     */
    @QtUninvokable
    public final void glLoadName(int name){
        glLoadName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glLoadName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLoadTransposeMatrixd(const GLdouble*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixd(java.nio.@Nullable DoubleBuffer m){
        glLoadTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLoadTransposeMatrixf(const GLfloat*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixf(java.nio.@Nullable FloatBuffer m){
        glLoadTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glLogicOp(GLenum)</code></p>
     * @param opcode
     */
    @QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMap1d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLdouble*)</code></p>
     * @param target
     * @param u1
     * @param u2
     * @param stride
     * @param order
     * @param points
     */
    @QtUninvokable
    public final void glMap1d(int target, double u1, double u2, int stride, int order, java.nio.@Nullable DoubleBuffer points){
        glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int stride, int order, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMap1f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param u1
     * @param u2
     * @param stride
     * @param order
     * @param points
     */
    @QtUninvokable
    public final void glMap1f(int target, float u1, float u2, int stride, int order, java.nio.@Nullable FloatBuffer points){
        glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int stride, int order, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMap2d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLdouble*)</code></p>
     * @param target
     * @param u1
     * @param u2
     * @param ustride
     * @param uorder
     * @param v1
     * @param v2
     * @param vstride
     * @param vorder
     * @param points
     */
    @QtUninvokable
    public final void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.@Nullable DoubleBuffer points){
        glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMap2f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param u1
     * @param u2
     * @param ustride
     * @param uorder
     * @param v1
     * @param v2
     * @param vstride
     * @param vorder
     * @param points
     */
    @QtUninvokable
    public final void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.@Nullable FloatBuffer points){
        glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMapBuffer(GLenum,<wbr/>GLenum)</code></p>
     * @param target
     * @param access
     * @return
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMapGrid1d(GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param un
     * @param u1
     * @param u2
     */
    @QtUninvokable
    public final void glMapGrid1d(int un, double u1, double u2){
        glMapGrid1d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMapGrid1f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param un
     * @param u1
     * @param u2
     */
    @QtUninvokable
    public final void glMapGrid1f(int un, float u1, float u2){
        glMapGrid1f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMapGrid2d(GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param un
     * @param u1
     * @param u2
     * @param vn
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2){
        glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2, int vn, double v1, double v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMapGrid2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param un
     * @param u1
     * @param u2
     * @param vn
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2){
        glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2, int vn, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMaterialf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param face
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glMaterialf(int face, int pname, float param){
        glMaterialf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMaterialf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int face, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMaterialfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param face
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMateriali(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param face
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glMateriali(int face, int pname, int param){
        glMateriali_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMateriali_native_GLenum_GLenum_GLint(long __this__nativeId, int face, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMaterialiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param face
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMatrixMode(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glMatrixMode(int mode){
        glMatrixMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glMatrixMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMinmax(GLenum,<wbr/>GLenum,<wbr/>GLboolean)</code></p>
     * @param target
     * @param internalformat
     * @param sink
     */
    @QtUninvokable
    public final void glMinmax(int target, int internalformat, boolean sink){
        glMinmax_native_GLenum_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glMinmax_native_GLenum_GLenum_GLboolean(long __this__nativeId, int target, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultMatrixd(const GLdouble*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glMultMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultMatrixf(const GLfloat*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glMultMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultTransposeMatrixd(const GLdouble*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glMultTransposeMatrixd(java.nio.@Nullable DoubleBuffer m){
        glMultTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultTransposeMatrixf(const GLfloat*)</code></p>
     * @param m
     */
    @QtUninvokable
    public final void glMultTransposeMatrixf(java.nio.@Nullable FloatBuffer m){
        glMultTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiDrawArrays(GLenum,<wbr/>const GLint*,<wbr/>const GLsizei*,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param first
     * @param count
     * @param drawcount
     */
    @QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.@Nullable IntBuffer first, java.nio.@Nullable IntBuffer count, int drawcount){
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiDrawElements(GLenum,<wbr/>const GLsizei*,<wbr/>GLenum,<wbr/>const GLvoid*const*,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     * @param drawcount
     */
    @QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.@Nullable IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1d(GLenum,<wbr/>GLdouble)</code></p>
     * @param target
     * @param s
     */
    @QtUninvokable
    public final void glMultiTexCoord1d(int target, double s){
        glMultiTexCoord1d_native_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1d_native_GLenum_GLdouble(long __this__nativeId, int target, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1dv(GLenum,<wbr/>const GLdouble*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord1dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1f(GLenum,<wbr/>GLfloat)</code></p>
     * @param target
     * @param s
     */
    @QtUninvokable
    public final void glMultiTexCoord1f(int target, float s){
        glMultiTexCoord1f_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1f_native_GLenum_GLfloat(long __this__nativeId, int target, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1fv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord1fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1i(GLenum,<wbr/>GLint)</code></p>
     * @param target
     * @param s
     */
    @QtUninvokable
    public final void glMultiTexCoord1i(int target, int s){
        glMultiTexCoord1i_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1i_native_GLenum_GLint(long __this__nativeId, int target, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1iv(GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord1iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1s(GLenum,<wbr/>GLshort)</code></p>
     * @param target
     * @param s
     */
    @QtUninvokable
    public final void glMultiTexCoord1s(int target, short s){
        glMultiTexCoord1s_native_GLenum_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1s_native_GLenum_GLshort(long __this__nativeId, int target, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord1sv(GLenum,<wbr/>const GLshort*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord1sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param target
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glMultiTexCoord2d(int target, double s, double t){
        glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2dv(GLenum,<wbr/>const GLdouble*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord2dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param target
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glMultiTexCoord2f(int target, float s, float t){
        glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2fv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord2fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2i(GLenum,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param target
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glMultiTexCoord2i(int target, int s, int t){
        glMultiTexCoord2i_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2i_native_GLenum_GLint_GLint(long __this__nativeId, int target, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2iv(GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord2iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2s(GLenum,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param target
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glMultiTexCoord2s(int target, short s, short t){
        glMultiTexCoord2s_native_GLenum_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2s_native_GLenum_GLshort_GLshort(long __this__nativeId, int target, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord2sv(GLenum,<wbr/>const GLshort*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord2sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glMultiTexCoord3d(int target, double s, double t, double r){
        glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3dv(GLenum,<wbr/>const GLdouble*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord3dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glMultiTexCoord3f(int target, float s, float t, float r){
        glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3fv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord3fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3i(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glMultiTexCoord3i(int target, int s, int t, int r){
        glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3iv(GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord3iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3s(GLenum,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glMultiTexCoord3s(int target, short s, short t, short r){
        glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord3sv(GLenum,<wbr/>const GLshort*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord3sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glMultiTexCoord4d(int target, double s, double t, double r, double q){
        glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4dv(GLenum,<wbr/>const GLdouble*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord4dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glMultiTexCoord4f(int target, float s, float t, float r, float q){
        glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4fv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord4fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4i(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glMultiTexCoord4i(int target, int s, int t, int r, int q){
        glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4iv(GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord4iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4s(GLenum,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param target
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glMultiTexCoord4s(int target, short s, short t, short r, short q){
        glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glMultiTexCoord4sv(GLenum,<wbr/>const GLshort*)</code></p>
     * @param target
     * @param v
     */
    @QtUninvokable
    public final void glMultiTexCoord4sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNewList(GLuint,<wbr/>GLenum)</code></p>
     * @param list
     * @param mode
     */
    @QtUninvokable
    public final void glNewList(int list, int mode){
        glNewList_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), list, mode);
    }
    
    @QtUninvokable
    private native void glNewList_native_GLuint_GLenum(long __this__nativeId, int list, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     * @param nx
     * @param ny
     * @param nz
     */
    @QtUninvokable
    public final void glNormal3b(byte nx, byte ny, byte nz){
        glNormal3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte nx, byte ny, byte nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3bv(const GLbyte*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glNormal3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param nx
     * @param ny
     * @param nz
     */
    @QtUninvokable
    public final void glNormal3d(double nx, double ny, double nz){
        glNormal3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double nx, double ny, double nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glNormal3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param nx
     * @param ny
     * @param nz
     */
    @QtUninvokable
    public final void glNormal3f(float nx, float ny, float nz){
        glNormal3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float nx, float ny, float nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glNormal3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param nx
     * @param ny
     * @param nz
     */
    @QtUninvokable
    public final void glNormal3i(int nx, int ny, int nz){
        glNormal3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3i_native_GLint_GLint_GLint(long __this__nativeId, int nx, int ny, int nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glNormal3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param nx
     * @param ny
     * @param nz
     */
    @QtUninvokable
    public final void glNormal3s(short nx, short ny, short nz){
        glNormal3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short nx, short ny, short nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormal3sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glNormal3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glNormalPointer(GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glNormalPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glOrtho(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param left
     * @param right
     * @param bottom
     * @param top
     * @param zNear
     * @param zFar
     */
    @QtUninvokable
    public final void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar){
        glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPassThrough(GLfloat)</code></p>
     * @param token
     */
    @QtUninvokable
    public final void glPassThrough(float token){
        glPassThrough_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), token);
    }
    
    @QtUninvokable
    private native void glPassThrough_native_GLfloat(long __this__nativeId, float token);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelMapfv(GLenum,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     * @param map
     * @param mapsize
     * @param values
     */
    @QtUninvokable
    public final void glPixelMapfv(int map, int mapsize, java.nio.@Nullable FloatBuffer values){
        glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int map, int mapsize, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelMapuiv(GLenum,<wbr/>GLint,<wbr/>const GLuint*)</code></p>
     * @param map
     * @param mapsize
     * @param values
     */
    @QtUninvokable
    public final void glPixelMapuiv(int map, int mapsize, java.nio.@Nullable IntBuffer values){
        glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int map, int mapsize, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelMapusv(GLenum,<wbr/>GLint,<wbr/>const GLushort*)</code></p>
     * @param map
     * @param mapsize
     * @param values
     */
    @QtUninvokable
    public final void glPixelMapusv(int map, int mapsize, java.nio.@Nullable ShortBuffer values){
        glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(long __this__nativeId, int map, int mapsize, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelStoref(GLenum,<wbr/>GLfloat)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelStorei(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelTransferf(GLenum,<wbr/>GLfloat)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPixelTransferf(int pname, float param){
        glPixelTransferf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelTransferi(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPixelTransferi(int pname, int param){
        glPixelTransferi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPixelZoom(GLfloat,<wbr/>GLfloat)</code></p>
     * @param xfactor
     * @param yfactor
     */
    @QtUninvokable
    public final void glPixelZoom(float xfactor, float yfactor){
        glPixelZoom_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), xfactor, yfactor);
    }
    
    @QtUninvokable
    private native void glPixelZoom_native_GLfloat_GLfloat(long __this__nativeId, float xfactor, float yfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPointParameterf(GLenum,<wbr/>GLfloat)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPointParameterfv(GLenum,<wbr/>const GLfloat*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.@Nullable FloatBuffer params){
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPointParameteri(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPointParameteriv(GLenum,<wbr/>const GLint*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.@Nullable IntBuffer params){
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPointSize(GLfloat)</code></p>
     * @param size
     */
    @QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPolygonMode(GLenum,<wbr/>GLenum)</code></p>
     * @param face
     * @param mode
     */
    @QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPolygonOffset(GLfloat,<wbr/>GLfloat)</code></p>
     * @param factor
     * @param units
     */
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPolygonStipple(const GLubyte*)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glPolygonStipple(java.nio.@Nullable ByteBuffer mask){
        glPolygonStipple_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPolygonStipple_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPopAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopAttrib(){
        glPopAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPopClientAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopClientAttrib(){
        glPopClientAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopClientAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPopMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPopMatrix(){
        glPopMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPopName()</code></p>
     */
    @QtUninvokable
    public final void glPopName(){
        glPopName_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopName_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPrioritizeTextures(GLsizei,<wbr/>const GLuint*,<wbr/>const GLfloat*)</code></p>
     * @param n
     * @param textures
     * @param priorities
     */
    @QtUninvokable
    public final void glPrioritizeTextures(int n, java.nio.@Nullable IntBuffer textures, java.nio.@Nullable FloatBuffer priorities){
        glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures, priorities);
    }
    
    @QtUninvokable
    private native void glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures, java.nio.FloatBuffer priorities);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPushAttrib(GLbitfield)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glPushAttrib(int mask){
        glPushAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPushClientAttrib(GLbitfield)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glPushClientAttrib(int mask){
        glPushClientAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushClientAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPushMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPushMatrix(){
        glPushMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPushMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glPushName(GLuint)</code></p>
     * @param name
     */
    @QtUninvokable
    public final void glPushName(int name){
        glPushName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glPushName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2d(GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glRasterPos2d(double x, double y){
        glRasterPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2f(GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glRasterPos2f(float x, float y){
        glRasterPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2i(GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glRasterPos2i(int x, int y){
        glRasterPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2s(GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glRasterPos2s(short x, short y){
        glRasterPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos2sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glRasterPos3d(double x, double y, double z){
        glRasterPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glRasterPos3f(float x, float y, float z){
        glRasterPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glRasterPos3i(int x, int y, int z){
        glRasterPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glRasterPos3s(short x, short y, short z){
        glRasterPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos3sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glRasterPos4d(double x, double y, double z, double w){
        glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glRasterPos4f(float x, float y, float z, float w){
        glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glRasterPos4i(int x, int y, int z, int w){
        glRasterPos4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glRasterPos4s(short x, short y, short z, short w){
        glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRasterPos4sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glRasterPos4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glReadBuffer(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glReadBuffer(int mode){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glReadPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRectd(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     */
    @QtUninvokable
    public final void glRectd(double x1, double y1, double x2, double y2){
        glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x1, double y1, double x2, double y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRectdv(const GLdouble*,<wbr/>const GLdouble*)</code></p>
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glRectdv(double[] v1, double[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(long __this__nativeId, double[] v1, double[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRectf(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     */
    @QtUninvokable
    public final void glRectf(float x1, float y1, float x2, float y2){
        glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x1, float y1, float x2, float y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRectfv(const GLfloat*,<wbr/>const GLfloat*)</code></p>
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glRectfv(float[] v1, float[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(long __this__nativeId, float[] v1, float[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRecti(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     */
    @QtUninvokable
    public final void glRecti(int x1, int y1, int x2, int y2){
        glRecti_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRecti_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x1, int y1, int x2, int y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRectiv(const GLint*,<wbr/>const GLint*)</code></p>
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glRectiv(int[] v1, int[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectiv_native_const_GLint_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectiv_native_const_GLint_ptr_const_GLint_ptr(long __this__nativeId, int[] v1, int[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRects(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     */
    @QtUninvokable
    public final void glRects(short x1, short y1, short x2, short y2){
        glRects_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRects_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x1, short y1, short x2, short y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRectsv(const GLshort*,<wbr/>const GLshort*)</code></p>
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glRectsv(short[] v1, short[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(long __this__nativeId, short[] v1, short[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRenderMode(GLenum)</code></p>
     * @param mode
     * @return
     */
    @QtUninvokable
    public final int glRenderMode(int mode){
        return glRenderMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native int glRenderMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glResetHistogram(GLenum)</code></p>
     * @param target
     */
    @QtUninvokable
    public final void glResetHistogram(int target){
        glResetHistogram_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetHistogram_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glResetMinmax(GLenum)</code></p>
     * @param target
     */
    @QtUninvokable
    public final void glResetMinmax(int target){
        glResetMinmax_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetMinmax_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRotated(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param angle
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glRotated(double angle, double x, double y, double z){
        glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double angle, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glRotatef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param angle
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glRotatef(float angle, float x, float y, float z){
        glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float angle, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSampleCoverage(GLfloat,<wbr/>GLboolean)</code></p>
     * @param value
     * @param invert
     */
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glScaled(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glScaled(double x, double y, double z){
        glScaled_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScaled_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glScalef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glScalef(float x, float y, float z){
        glScalef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScalef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glScissor(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3b(byte red, byte green, byte blue){
        glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3bv(const GLbyte*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3bv(java.nio.@Nullable ByteBuffer v){
        glSecondaryColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3bv_native_const_GLbyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3d(double red, double green, double blue){
        glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3dv(java.nio.@Nullable DoubleBuffer v){
        glSecondaryColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3f(float red, float green, float blue){
        glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3fv(java.nio.@Nullable FloatBuffer v){
        glSecondaryColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3i(int red, int green, int blue){
        glSecondaryColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3iv(java.nio.@Nullable IntBuffer v){
        glSecondaryColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3s(short red, short green, short blue){
        glSecondaryColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3sv(java.nio.@Nullable ShortBuffer v){
        glSecondaryColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3ub(GLubyte,<wbr/>GLubyte,<wbr/>GLubyte)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3ub(byte red, byte green, byte blue){
        glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3ubv(const GLubyte*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3ubv(java.nio.@Nullable ByteBuffer v){
        glSecondaryColor3ubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ubv_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3ui(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3ui(int red, int green, int blue){
        glSecondaryColor3ui_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ui_native_GLuint_GLuint_GLuint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3uiv(const GLuint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3uiv(java.nio.@Nullable IntBuffer v){
        glSecondaryColor3uiv_native_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3uiv_native_const_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3us(GLushort,<wbr/>GLushort,<wbr/>GLushort)</code></p>
     * @param red
     * @param green
     * @param blue
     */
    @QtUninvokable
    public final void glSecondaryColor3us(short red, short green, short blue){
        glSecondaryColor3us_native_GLushort_GLushort_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3us_native_GLushort_GLushort_GLushort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColor3usv(const GLushort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glSecondaryColor3usv(java.nio.@Nullable ShortBuffer v){
        glSecondaryColor3usv_native_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3usv_native_const_GLushort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSecondaryColorPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param size
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glSecondaryColorPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSelectBuffer(GLsizei,<wbr/>GLuint*)</code></p>
     * @param buffer
     */
    @QtUninvokable
    public final void glSelectBuffer(java.nio.@Nullable IntBuffer buffer){
        glSelectBuffer_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native void glSelectBuffer_native_GLsizei_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glSeparableFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param internalformat
     * @param width
     * @param height
     * @param format
     * @param type
     * @param row
     * @param column
     */
    @QtUninvokable
    public final void glSeparableFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.@Nullable Buffer row, java.nio.@Nullable Buffer column){
        glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, row, column);
    }
    
    @QtUninvokable
    private native void glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer row, java.nio.Buffer column);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glShadeModel(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glShadeModel(int mode){
        glShadeModel_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glShadeModel_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glShaderSource(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>const GLint*)</code></p>
     * @param shader
     * @param string
     * @param length
     */
    @QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.@Nullable IntBuffer length){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glStencilFunc(GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param func
     * @param ref
     * @param mask
     */
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glStencilFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param face
     * @param func
     * @param ref
     * @param mask
     */
    @QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glStencilMask(GLuint)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glStencilMaskSeparate(GLenum,<wbr/>GLuint)</code></p>
     * @param face
     * @param mask
     */
    @QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glStencilOp(GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param fail
     * @param zfail
     * @param zpass
     */
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glStencilOpSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param face
     * @param sfail
     * @param dpfail
     * @param dppass
     */
    @QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1d(GLdouble)</code></p>
     * @param s
     */
    @QtUninvokable
    public final void glTexCoord1d(double s){
        glTexCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1d_native_GLdouble(long __this__nativeId, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord1dv(double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1f(GLfloat)</code></p>
     * @param s
     */
    @QtUninvokable
    public final void glTexCoord1f(float s){
        glTexCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1f_native_GLfloat(long __this__nativeId, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord1fv(float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1i(GLint)</code></p>
     * @param s
     */
    @QtUninvokable
    public final void glTexCoord1i(int s){
        glTexCoord1i_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1i_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord1iv(int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1s(GLshort)</code></p>
     * @param s
     */
    @QtUninvokable
    public final void glTexCoord1s(short s){
        glTexCoord1s_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1s_native_GLshort(long __this__nativeId, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord1sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord1sv(short[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2d(GLdouble,<wbr/>GLdouble)</code></p>
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glTexCoord2d(double s, double t){
        glTexCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2f(GLfloat,<wbr/>GLfloat)</code></p>
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glTexCoord2f(float s, float t){
        glTexCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2i(GLint,<wbr/>GLint)</code></p>
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glTexCoord2i(int s, int t){
        glTexCoord2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2i_native_GLint_GLint(long __this__nativeId, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2s(GLshort,<wbr/>GLshort)</code></p>
     * @param s
     * @param t
     */
    @QtUninvokable
    public final void glTexCoord2s(short s, short t){
        glTexCoord2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2s_native_GLshort_GLshort(long __this__nativeId, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord2sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glTexCoord3d(double s, double t, double r){
        glTexCoord3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glTexCoord3f(float s, float t, float r){
        glTexCoord3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glTexCoord3i(int s, int t, int r){
        glTexCoord3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3i_native_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param s
     * @param t
     * @param r
     */
    @QtUninvokable
    public final void glTexCoord3s(short s, short t, short r){
        glTexCoord3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord3sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glTexCoord4d(double s, double t, double r, double q){
        glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glTexCoord4f(float s, float t, float r, float q){
        glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glTexCoord4i(int s, int t, int r, int q){
        glTexCoord4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param s
     * @param t
     * @param r
     * @param q
     */
    @QtUninvokable
    public final void glTexCoord4s(short s, short t, short r, short q){
        glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoord4sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glTexCoord4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexCoordPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param size
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glTexCoordPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexEnvf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexEnvf(int target, int pname, float param){
        glTexEnvf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexEnvfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexEnvfv(int target, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexEnvi(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexEnvi(int target, int pname, int param){
        glTexEnvi_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvi_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexEnviv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexEnviv(int target, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexGend(GLenum,<wbr/>GLenum,<wbr/>GLdouble)</code></p>
     * @param coord
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexGend(int coord, int pname, double param){
        glTexGend_native_GLenum_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGend_native_GLenum_GLenum_GLdouble(long __this__nativeId, int coord, int pname, double param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexGendv(GLenum,<wbr/>GLenum,<wbr/>const GLdouble*)</code></p>
     * @param coord
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexGendv(int coord, int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(long __this__nativeId, int coord, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexGenf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param coord
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexGenf(int coord, int pname, float param){
        glTexGenf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGenf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int coord, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexGenfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param coord
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexGenfv(int coord, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int coord, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexGeni(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param coord
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexGeni(int coord, int pname, int param){
        glTexGeni_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGeni_native_GLenum_GLenum_GLint(long __this__nativeId, int coord, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexGeniv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param coord
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexGeniv(int coord, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int coord, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param border
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param border
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param depth
     * @param border
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param width
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param width
     * @param height
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param zoffset
     * @param width
     * @param height
     * @param depth
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTranslated(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glTranslated(double x, double y, double z){
        glTranslated_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslated_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glTranslatef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glTranslatef(float x, float y, float z){
        glTranslatef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslatef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform1f(GLint,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform1fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform1i(GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     */
    @QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform1iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform2fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform2i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     * @param v1
     */
    @QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform2iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform3f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform3fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform3i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     */
    @QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform3iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform4f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform4fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param v0
     * @param v1
     * @param v2
     * @param v3
     */
    @QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniform4iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param value
     */
    @QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniformMatrix2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniformMatrix3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUniformMatrix4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUnmapBuffer(GLenum)</code></p>
     * @param target
     * @return
     */
    @QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glUseProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glValidateProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2d(GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertex2d(double x, double y){
        glVertex2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2f(GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertex2f(float x, float y){
        glVertex2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2i(GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertex2i(int x, int y){
        glVertex2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2s(GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertex2s(short x, short y){
        glVertex2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex2sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertex3d(double x, double y, double z){
        glVertex3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertex3f(float x, float y, float z){
        glVertex3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertex3i(int x, int y, int z){
        glVertex3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertex3s(short x, short y, short z){
        glVertex3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex3sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertex4d(double x, double y, double z, double w){
        glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertex4f(float x, float y, float z, float w){
        glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertex4i(int x, int y, int z, int w){
        glVertex4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertex4s(short x, short y, short z, short w){
        glVertex4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertex4sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glVertex4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib1d(GLuint,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     */
    @QtUninvokable
    public final void glVertexAttrib1d(int index, double x){
        glVertexAttrib1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib1dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib1dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib1f(GLuint,<wbr/>GLfloat)</code></p>
     * @param index
     * @param x
     */
    @QtUninvokable
    public final void glVertexAttrib1f(int index, float x){
        glVertexAttrib1f_native_GLuint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1f_native_GLuint_GLfloat(long __this__nativeId, int index, float x);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib1fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib1fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib1s(GLuint,<wbr/>GLshort)</code></p>
     * @param index
     * @param x
     */
    @QtUninvokable
    public final void glVertexAttrib1s(int index, short x){
        glVertexAttrib1s_native_GLuint_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1s_native_GLuint_GLshort(long __this__nativeId, int index, short x);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib1sv(GLuint,<wbr/>const GLshort*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib1sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib2d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertexAttrib2d(int index, double x, double y){
        glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib2dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib2dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib2f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param index
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertexAttrib2f(int index, float x, float y){
        glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib2fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib2fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib2s(GLuint,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param index
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertexAttrib2s(int index, short x, short y){
        glVertexAttrib2s_native_GLuint_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2s_native_GLuint_GLshort_GLshort(long __this__nativeId, int index, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib2sv(GLuint,<wbr/>const GLshort*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib2sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib3d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertexAttrib3d(int index, double x, double y, double z){
        glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib3dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib3dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib3f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertexAttrib3f(int index, float x, float y, float z){
        glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib3fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib3fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib3s(GLuint,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertexAttrib3s(int index, short x, short y, short z){
        glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib3sv(GLuint,<wbr/>const GLshort*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib3sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4Nbv(GLuint,<wbr/>const GLbyte*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4Nbv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4Niv(GLuint,<wbr/>const GLint*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4Niv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4Nsv(GLuint,<wbr/>const GLshort*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4Nsv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4Nub(GLuint,<wbr/>GLubyte,<wbr/>GLubyte,<wbr/>GLubyte,<wbr/>GLubyte)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w){
        glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(long __this__nativeId, int index, byte x, byte y, byte z, byte w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4Nubv(GLuint,<wbr/>const GLubyte*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4Nubv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4Nuiv(GLuint,<wbr/>const GLuint*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4Nuiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4Nusv(GLuint,<wbr/>const GLushort*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4Nusv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4bv(GLuint,<wbr/>const GLbyte*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4bv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4d(GLuint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertexAttrib4d(int index, double x, double y, double z, double w){
        glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4dv(GLuint,<wbr/>const GLdouble*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4dv(int index, java.nio.@Nullable DoubleBuffer v){
        glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertexAttrib4f(int index, float x, float y, float z, float w){
        glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4fv(int index, java.nio.@Nullable FloatBuffer v){
        glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4iv(GLuint,<wbr/>const GLint*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4iv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4s(GLuint,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param index
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertexAttrib4s(int index, short x, short y, short z, short w){
        glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4sv(GLuint,<wbr/>const GLshort*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4sv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4ubv(GLuint,<wbr/>const GLubyte*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4ubv(int index, java.nio.@Nullable ByteBuffer v){
        glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4uiv(GLuint,<wbr/>const GLuint*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4uiv(int index, java.nio.@Nullable IntBuffer v){
        glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttrib4usv(GLuint,<wbr/>const GLushort*)</code></p>
     * @param index
     * @param v
     */
    @QtUninvokable
    public final void glVertexAttrib4usv(int index, java.nio.@Nullable ShortBuffer v){
        glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexAttribPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param index
     * @param size
     * @param type
     * @param normalized
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glVertexPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param size
     * @param type
     * @param stride
     * @param pointer
     */
    @QtUninvokable
    public final void glVertexPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glViewport(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2d(GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glWindowPos2d(double x, double y){
        glWindowPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos2dv(java.nio.@Nullable DoubleBuffer v){
        glWindowPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2f(GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glWindowPos2f(float x, float y){
        glWindowPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos2fv(java.nio.@Nullable FloatBuffer v){
        glWindowPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2i(GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glWindowPos2i(int x, int y){
        glWindowPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos2iv(java.nio.@Nullable IntBuffer v){
        glWindowPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2s(GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glWindowPos2s(short x, short y){
        glWindowPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos2sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos2sv(java.nio.@Nullable ShortBuffer v){
        glWindowPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glWindowPos3d(double x, double y, double z){
        glWindowPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3dv(const GLdouble*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos3dv(java.nio.@Nullable DoubleBuffer v){
        glWindowPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glWindowPos3f(float x, float y, float z){
        glWindowPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3fv(const GLfloat*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos3fv(java.nio.@Nullable FloatBuffer v){
        glWindowPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glWindowPos3i(int x, int y, int z){
        glWindowPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3iv(const GLint*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos3iv(java.nio.@Nullable IntBuffer v){
        glWindowPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glWindowPos3s(short x, short y, short z){
        glWindowPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_2_0::<wbr/>glWindowPos3sv(const GLshort*)</code></p>
     * @param v
     */
    @QtUninvokable
    public final void glWindowPos3sv(java.nio.@Nullable ShortBuffer v){
        glWindowPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>initializeOpenGLFunctions()</code></p>
     * @return
     */
    @QtUninvokable
    @Override
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFunctions_2_0(QPrivateConstructor p) { super(p); } 
    
}
