package io.qt.opengl;

import io.qt.*;


/**
 * <p>The base class of a family of classes that expose all functions for each OpenGL version and profile</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstractopenglfunctions.html">QAbstractOpenGLFunctions</a></code></p>
 */
public class QAbstractOpenGLFunctions extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>isInitialized()const</code></p>
     * @return
     */
    @QtUninvokable
    protected final boolean isInitialized(){
        return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>owningContext()const</code></p>
     * @return
     */
    @QtUninvokable
    protected final io.qt.gui.@Nullable QOpenGLContext owningContext(){
        return owningContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QOpenGLContext owningContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>setOwningContext(const QOpenGLContext*)</code></p>
     * @param context
     */
    @QtUninvokable
    protected final void setOwningContext(io.qt.gui.@Nullable QOpenGLContext context){
        setOwningContext_native_const_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    @QtUninvokable
    private native void setOwningContext_native_const_QOpenGLContext_ptr(long __this__nativeId, long context);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>initializeOpenGLFunctions()</code></p>
     * @return
     */
    @QtUninvokable
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractOpenGLFunctions(QPrivateConstructor p) { super(p); } 
    
}
