package io.qt.opengl;

import io.qt.*;


/**
 * <p>Encapsulates an OpenGL texture object</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopengltexture.html">QOpenGLTexture</a></p>
 */
public class QOpenGLTexture extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLTexture.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget</a></p>
     */
    public enum BindingTarget implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget1D</a></p>
         */
        BindingTarget1D(32872),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget1DArray</a></p>
         */
        BindingTarget1DArray(35868),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget2D</a></p>
         */
        BindingTarget2D(32873),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget2DArray</a></p>
         */
        BindingTarget2DArray(35869),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget3D</a></p>
         */
        BindingTarget3D(32874),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTargetCubeMap</a></p>
         */
        BindingTargetCubeMap(34068),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTargetCubeMapArray</a></p>
         */
        BindingTargetCubeMapArray(36874),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget2DMultisample</a></p>
         */
        BindingTarget2DMultisample(37124),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTarget2DMultisampleArray</a></p>
         */
        BindingTarget2DMultisampleArray(37125),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTargetRectangle</a></p>
         */
        BindingTargetRectangle(34038),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#BindingTarget-enum">QOpenGLTexture::BindingTargetBuffer</a></p>
         */
        BindingTargetBuffer(35884);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private BindingTarget(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull BindingTarget resolve(int value) {
            switch (value) {
            case 32872: return BindingTarget1D;
            case 35868: return BindingTarget1DArray;
            case 32873: return BindingTarget2D;
            case 35869: return BindingTarget2DArray;
            case 32874: return BindingTarget3D;
            case 34068: return BindingTargetCubeMap;
            case 36874: return BindingTargetCubeMapArray;
            case 37124: return BindingTarget2DMultisample;
            case 37125: return BindingTarget2DMultisampleArray;
            case 34038: return BindingTargetRectangle;
            case 35884: return BindingTargetBuffer;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::ComparisonFunction</a></p>
     */
    @QtRejectedEntries({"CommpareNotEqual"})
    public enum ComparisonFunction implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareLessEqual</a></p>
         */
        CompareLessEqual(515),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareGreaterEqual</a></p>
         */
        CompareGreaterEqual(518),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareLess</a></p>
         */
        CompareLess(513),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareGreater</a></p>
         */
        CompareGreater(516),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareEqual</a></p>
         */
        CompareEqual(514),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareNotEqual</a></p>
         */
        CompareNotEqual(517),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareAlways</a></p>
         */
        CompareAlways(519),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CompareNever</a></p>
         */
        CompareNever(512),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonFunction-enum">QOpenGLTexture::CommpareNotEqual</a></p>
         * @deprecated Use CompareNotEqual instead.
         */
        @Deprecated
        CommpareNotEqual(517);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComparisonFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ComparisonFunction resolve(int value) {
            switch (value) {
            case 515: return CompareLessEqual;
            case 518: return CompareGreaterEqual;
            case 513: return CompareLess;
            case 516: return CompareGreater;
            case 514: return CompareEqual;
            case 517: return CompareNotEqual;
            case 519: return CompareAlways;
            case 512: return CompareNever;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonMode-enum">QOpenGLTexture::ComparisonMode</a></p>
     */
    public enum ComparisonMode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonMode-enum">QOpenGLTexture::CompareRefToTexture</a></p>
         */
        CompareRefToTexture(34894),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#ComparisonMode-enum">QOpenGLTexture::CompareNone</a></p>
         */
        CompareNone(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComparisonMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ComparisonMode resolve(int value) {
            switch (value) {
            case 34894: return CompareRefToTexture;
            case 0: return CompareNone;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#CoordinateDirection-enum">QOpenGLTexture::CoordinateDirection</a></p>
     */
    public enum CoordinateDirection implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CoordinateDirection-enum">QOpenGLTexture::DirectionS</a></p>
         */
        DirectionS(10242),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CoordinateDirection-enum">QOpenGLTexture::DirectionT</a></p>
         */
        DirectionT(10243),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CoordinateDirection-enum">QOpenGLTexture::DirectionR</a></p>
         */
        DirectionR(32882);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CoordinateDirection(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CoordinateDirection resolve(int value) {
            switch (value) {
            case 10242: return DirectionS;
            case 10243: return DirectionT;
            case 32882: return DirectionR;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#CubeMapFace-enum">QOpenGLTexture::CubeMapFace</a></p>
     */
    public enum CubeMapFace implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CubeMapFace-enum">QOpenGLTexture::CubeMapPositiveX</a></p>
         */
        CubeMapPositiveX(34069),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CubeMapFace-enum">QOpenGLTexture::CubeMapNegativeX</a></p>
         */
        CubeMapNegativeX(34070),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CubeMapFace-enum">QOpenGLTexture::CubeMapPositiveY</a></p>
         */
        CubeMapPositiveY(34071),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CubeMapFace-enum">QOpenGLTexture::CubeMapNegativeY</a></p>
         */
        CubeMapNegativeY(34072),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CubeMapFace-enum">QOpenGLTexture::CubeMapPositiveZ</a></p>
         */
        CubeMapPositiveZ(34073),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#CubeMapFace-enum">QOpenGLTexture::CubeMapNegativeZ</a></p>
         */
        CubeMapNegativeZ(34074);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CubeMapFace(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CubeMapFace resolve(int value) {
            switch (value) {
            case 34069: return CubeMapPositiveX;
            case 34070: return CubeMapNegativeX;
            case 34071: return CubeMapPositiveY;
            case 34072: return CubeMapNegativeY;
            case 34073: return CubeMapPositiveZ;
            case 34074: return CubeMapNegativeZ;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#DepthStencilMode-enum">QOpenGLTexture::DepthStencilMode</a></p>
     */
    public enum DepthStencilMode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#DepthStencilMode-enum">QOpenGLTexture::DepthMode</a></p>
         */
        DepthMode(6402),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#DepthStencilMode-enum">QOpenGLTexture::StencilMode</a></p>
         */
        StencilMode(6401);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DepthStencilMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DepthStencilMode resolve(int value) {
            switch (value) {
            case 6402: return DepthMode;
            case 6401: return StencilMode;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::Feature</a></p>
     * 
     * @see Features
     */
    public enum Feature implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::ImmutableStorage</a></p>
         */
        ImmutableStorage(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::ImmutableMultisampleStorage</a></p>
         */
        ImmutableMultisampleStorage(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::TextureRectangle</a></p>
         */
        TextureRectangle(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::TextureArrays</a></p>
         */
        TextureArrays(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::Texture3D</a></p>
         */
        Texture3D(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::TextureMultisample</a></p>
         */
        TextureMultisample(32),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::TextureBuffer</a></p>
         */
        TextureBuffer(64),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::TextureCubeMapArrays</a></p>
         */
        TextureCubeMapArrays(128),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::Swizzle</a></p>
         */
        Swizzle(256),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::StencilTexturing</a></p>
         */
        StencilTexturing(512),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::AnisotropicFiltering</a></p>
         */
        AnisotropicFiltering(1024),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::NPOTTextures</a></p>
         */
        NPOTTextures(2048),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::NPOTTextureRepeat</a></p>
         */
        NPOTTextureRepeat(4096),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::Texture1D</a></p>
         */
        Texture1D(8192),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::TextureComparisonOperators</a></p>
         */
        TextureComparisonOperators(16384),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::TextureMipMapLevel</a></p>
         */
        TextureMipMapLevel(32768),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Feature-enum">QOpenGLTexture::MaxFeatureFlag</a></p>
         */
        MaxFeatureFlag(65536);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Feature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull Features asFlags() {
            return new Features(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Features combined(@NonNull Feature e) {
            return new Features(this, e);
        }

        /**
         * Creates a new {@link Features} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Features flags(@Nullable Feature @NonNull... values) {
            return new Features(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Feature resolve(int value) {
            switch (value) {
            case 1: return ImmutableStorage;
            case 2: return ImmutableMultisampleStorage;
            case 4: return TextureRectangle;
            case 8: return TextureArrays;
            case 16: return Texture3D;
            case 32: return TextureMultisample;
            case 64: return TextureBuffer;
            case 128: return TextureCubeMapArrays;
            case 256: return Swizzle;
            case 512: return StencilTexturing;
            case 1024: return AnisotropicFiltering;
            case 2048: return NPOTTextures;
            case 4096: return NPOTTextureRepeat;
            case 8192: return Texture1D;
            case 16384: return TextureComparisonOperators;
            case 32768: return TextureMipMapLevel;
            case 65536: return MaxFeatureFlag;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Feature}
     */
    public static final class Features extends QFlags<Feature> implements Comparable<Features> {
        private static final long serialVersionUID = 0x169fb62bf9f4d5d0L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Features where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Features(@Nullable Feature @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Features with given <code>value</code>.
         * @param value
         */
        public Features(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Features
         */
        @Override
        public final @NonNull Features combined(@StrictNonNull Feature e){
            return new Features(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull Features setFlag(@Nullable Feature e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull Features setFlag(@Nullable Feature e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Features.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Feature @NonNull[] flags(){
            return super.flags(Feature.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Features clone(){
            return new Features(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Features other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#Filter-enum">QOpenGLTexture::Filter</a></p>
     */
    public enum Filter implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Filter-enum">QOpenGLTexture::Nearest</a></p>
         */
        Nearest(9728),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Filter-enum">QOpenGLTexture::Linear</a></p>
         */
        Linear(9729),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Filter-enum">QOpenGLTexture::NearestMipMapNearest</a></p>
         */
        NearestMipMapNearest(9984),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Filter-enum">QOpenGLTexture::NearestMipMapLinear</a></p>
         */
        NearestMipMapLinear(9986),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Filter-enum">QOpenGLTexture::LinearMipMapNearest</a></p>
         */
        LinearMipMapNearest(9985),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Filter-enum">QOpenGLTexture::LinearMipMapLinear</a></p>
         */
        LinearMipMapLinear(9987);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Filter(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Filter resolve(int value) {
            switch (value) {
            case 9728: return Nearest;
            case 9729: return Linear;
            case 9984: return NearestMipMapNearest;
            case 9986: return NearestMipMapLinear;
            case 9985: return LinearMipMapNearest;
            case 9987: return LinearMipMapLinear;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#MipMapGeneration-enum">QOpenGLTexture::MipMapGeneration</a></p>
     */
    public enum MipMapGeneration implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#MipMapGeneration-enum">QOpenGLTexture::GenerateMipMaps</a></p>
         */
        GenerateMipMaps(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#MipMapGeneration-enum">QOpenGLTexture::DontGenerateMipMaps</a></p>
         */
        DontGenerateMipMaps(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MipMapGeneration(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MipMapGeneration resolve(int value) {
            switch (value) {
            case 0: return GenerateMipMaps;
            case 1: return DontGenerateMipMaps;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::PixelFormat</a></p>
     */
    public enum PixelFormat implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::NoSourceFormat</a></p>
         */
        NoSourceFormat(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::Red</a></p>
         */
        Red(6403),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::RG</a></p>
         */
        RG(33319),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::RGB</a></p>
         */
        RGB(6407),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::BGR</a></p>
         */
        BGR(32992),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::RGBA</a></p>
         */
        RGBA(6408),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::BGRA</a></p>
         */
        BGRA(32993),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::Red_Integer</a></p>
         */
        Red_Integer(36244),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::RG_Integer</a></p>
         */
        RG_Integer(33320),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::RGB_Integer</a></p>
         */
        RGB_Integer(36248),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::BGR_Integer</a></p>
         */
        BGR_Integer(36250),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::RGBA_Integer</a></p>
         */
        RGBA_Integer(36249),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::BGRA_Integer</a></p>
         */
        BGRA_Integer(36251),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::Stencil</a></p>
         */
        Stencil(6401),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::Depth</a></p>
         */
        Depth(6402),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::DepthStencil</a></p>
         */
        DepthStencil(34041),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::Alpha</a></p>
         */
        Alpha(6406),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::Luminance</a></p>
         */
        Luminance(6409),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelFormat-enum">QOpenGLTexture::LuminanceAlpha</a></p>
         */
        LuminanceAlpha(6410);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PixelFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PixelFormat resolve(int value) {
            switch (value) {
            case 0: return NoSourceFormat;
            case 6403: return Red;
            case 33319: return RG;
            case 6407: return RGB;
            case 32992: return BGR;
            case 6408: return RGBA;
            case 32993: return BGRA;
            case 36244: return Red_Integer;
            case 33320: return RG_Integer;
            case 36248: return RGB_Integer;
            case 36250: return BGR_Integer;
            case 36249: return RGBA_Integer;
            case 36251: return BGRA_Integer;
            case 6401: return Stencil;
            case 6402: return Depth;
            case 34041: return DepthStencil;
            case 6406: return Alpha;
            case 6409: return Luminance;
            case 6410: return LuminanceAlpha;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::PixelType</a></p>
     */
    public enum PixelType implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::NoPixelType</a></p>
         */
        NoPixelType(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::Int8</a></p>
         */
        Int8(5120),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt8</a></p>
         */
        UInt8(5121),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::Int16</a></p>
         */
        Int16(5122),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt16</a></p>
         */
        UInt16(5123),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::Int32</a></p>
         */
        Int32(5124),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32</a></p>
         */
        UInt32(5125),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::Float16</a></p>
         */
        Float16(5131),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::Float16OES</a></p>
         */
        Float16OES(36193),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::Float32</a></p>
         */
        Float32(5126),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32_RGB9_E5</a></p>
         */
        UInt32_RGB9_E5(35902),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32_RG11B10F</a></p>
         */
        UInt32_RG11B10F(35899),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt8_RG3B2</a></p>
         */
        UInt8_RG3B2(32818),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt8_RG3B2_Rev</a></p>
         */
        UInt8_RG3B2_Rev(33634),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt16_RGB5A1</a></p>
         */
        UInt16_RGB5A1(32820),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt16_RGB5A1_Rev</a></p>
         */
        UInt16_RGB5A1_Rev(33638),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt16_R5G6B5</a></p>
         */
        UInt16_R5G6B5(33635),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt16_R5G6B5_Rev</a></p>
         */
        UInt16_R5G6B5_Rev(33636),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt16_RGBA4</a></p>
         */
        UInt16_RGBA4(32819),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt16_RGBA4_Rev</a></p>
         */
        UInt16_RGBA4_Rev(33637),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32_RGBA8</a></p>
         */
        UInt32_RGBA8(32821),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32_RGBA8_Rev</a></p>
         */
        UInt32_RGBA8_Rev(33639),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32_RGB10A2</a></p>
         */
        UInt32_RGB10A2(32822),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32_RGB10A2_Rev</a></p>
         */
        UInt32_RGB10A2_Rev(33640),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::UInt32_D24S8</a></p>
         */
        UInt32_D24S8(34042),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#PixelType-enum">QOpenGLTexture::Float32_D32_UInt32_S8_X24</a></p>
         */
        Float32_D32_UInt32_S8_X24(36269);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PixelType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PixelType resolve(int value) {
            switch (value) {
            case 0: return NoPixelType;
            case 5120: return Int8;
            case 5121: return UInt8;
            case 5122: return Int16;
            case 5123: return UInt16;
            case 5124: return Int32;
            case 5125: return UInt32;
            case 5131: return Float16;
            case 36193: return Float16OES;
            case 5126: return Float32;
            case 35902: return UInt32_RGB9_E5;
            case 35899: return UInt32_RG11B10F;
            case 32818: return UInt8_RG3B2;
            case 33634: return UInt8_RG3B2_Rev;
            case 32820: return UInt16_RGB5A1;
            case 33638: return UInt16_RGB5A1_Rev;
            case 33635: return UInt16_R5G6B5;
            case 33636: return UInt16_R5G6B5_Rev;
            case 32819: return UInt16_RGBA4;
            case 33637: return UInt16_RGBA4_Rev;
            case 32821: return UInt32_RGBA8;
            case 33639: return UInt32_RGBA8_Rev;
            case 32822: return UInt32_RGB10A2;
            case 33640: return UInt32_RGB10A2_Rev;
            case 34042: return UInt32_D24S8;
            case 36269: return Float32_D32_UInt32_S8_X24;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleComponent-enum">QOpenGLTexture::SwizzleComponent</a></p>
     */
    public enum SwizzleComponent implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleComponent-enum">QOpenGLTexture::SwizzleRed</a></p>
         */
        SwizzleRed(36418),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleComponent-enum">QOpenGLTexture::SwizzleGreen</a></p>
         */
        SwizzleGreen(36419),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleComponent-enum">QOpenGLTexture::SwizzleBlue</a></p>
         */
        SwizzleBlue(36420),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleComponent-enum">QOpenGLTexture::SwizzleAlpha</a></p>
         */
        SwizzleAlpha(36421);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SwizzleComponent(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SwizzleComponent resolve(int value) {
            switch (value) {
            case 36418: return SwizzleRed;
            case 36419: return SwizzleGreen;
            case 36420: return SwizzleBlue;
            case 36421: return SwizzleAlpha;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleValue-enum">QOpenGLTexture::SwizzleValue</a></p>
     */
    public enum SwizzleValue implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleValue-enum">QOpenGLTexture::RedValue</a></p>
         */
        RedValue(6403),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleValue-enum">QOpenGLTexture::GreenValue</a></p>
         */
        GreenValue(6404),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleValue-enum">QOpenGLTexture::BlueValue</a></p>
         */
        BlueValue(6405),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleValue-enum">QOpenGLTexture::AlphaValue</a></p>
         */
        AlphaValue(6406),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleValue-enum">QOpenGLTexture::ZeroValue</a></p>
         */
        ZeroValue(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#SwizzleValue-enum">QOpenGLTexture::OneValue</a></p>
         */
        OneValue(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SwizzleValue(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SwizzleValue resolve(int value) {
            switch (value) {
            case 6403: return RedValue;
            case 6404: return GreenValue;
            case 6405: return BlueValue;
            case 6406: return AlphaValue;
            case 0: return ZeroValue;
            case 1: return OneValue;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target</a></p>
     */
    public enum Target implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target1D</a></p>
         */
        Target1D(3552),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target1DArray</a></p>
         */
        Target1DArray(35864),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target2D</a></p>
         */
        Target2D(3553),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target2DArray</a></p>
         */
        Target2DArray(35866),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target3D</a></p>
         */
        Target3D(32879),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::TargetCubeMap</a></p>
         */
        TargetCubeMap(34067),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::TargetCubeMapArray</a></p>
         */
        TargetCubeMapArray(36873),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target2DMultisample</a></p>
         */
        Target2DMultisample(37120),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::Target2DMultisampleArray</a></p>
         */
        Target2DMultisampleArray(37122),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::TargetRectangle</a></p>
         */
        TargetRectangle(34037),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#Target-enum">QOpenGLTexture::TargetBuffer</a></p>
         */
        TargetBuffer(35882);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Target(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Target resolve(int value) {
            switch (value) {
            case 3552: return Target1D;
            case 35864: return Target1DArray;
            case 3553: return Target2D;
            case 35866: return Target2DArray;
            case 32879: return Target3D;
            case 34067: return TargetCubeMap;
            case 36873: return TargetCubeMapArray;
            case 37120: return Target2DMultisample;
            case 37122: return Target2DMultisampleArray;
            case 34037: return TargetRectangle;
            case 35882: return TargetBuffer;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::TextureFormat</a></p>
     */
    public enum TextureFormat implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::NoFormat</a></p>
         */
        NoFormat(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R8_UNorm</a></p>
         */
        R8_UNorm(33321),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG8_UNorm</a></p>
         */
        RG8_UNorm(33323),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB8_UNorm</a></p>
         */
        RGB8_UNorm(32849),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA8_UNorm</a></p>
         */
        RGBA8_UNorm(32856),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R16_UNorm</a></p>
         */
        R16_UNorm(33322),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG16_UNorm</a></p>
         */
        RG16_UNorm(33324),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB16_UNorm</a></p>
         */
        RGB16_UNorm(32852),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA16_UNorm</a></p>
         */
        RGBA16_UNorm(32859),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R8_SNorm</a></p>
         */
        R8_SNorm(36756),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG8_SNorm</a></p>
         */
        RG8_SNorm(36757),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB8_SNorm</a></p>
         */
        RGB8_SNorm(36758),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA8_SNorm</a></p>
         */
        RGBA8_SNorm(36759),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R16_SNorm</a></p>
         */
        R16_SNorm(36760),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG16_SNorm</a></p>
         */
        RG16_SNorm(36761),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB16_SNorm</a></p>
         */
        RGB16_SNorm(36762),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA16_SNorm</a></p>
         */
        RGBA16_SNorm(36763),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R8U</a></p>
         */
        R8U(33330),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG8U</a></p>
         */
        RG8U(33336),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB8U</a></p>
         */
        RGB8U(36221),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA8U</a></p>
         */
        RGBA8U(36220),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R16U</a></p>
         */
        R16U(33332),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG16U</a></p>
         */
        RG16U(33338),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB16U</a></p>
         */
        RGB16U(36215),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA16U</a></p>
         */
        RGBA16U(36214),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R32U</a></p>
         */
        R32U(33334),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG32U</a></p>
         */
        RG32U(33340),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB32U</a></p>
         */
        RGB32U(36209),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA32U</a></p>
         */
        RGBA32U(36208),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R8I</a></p>
         */
        R8I(33329),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG8I</a></p>
         */
        RG8I(33335),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB8I</a></p>
         */
        RGB8I(36239),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA8I</a></p>
         */
        RGBA8I(36238),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R16I</a></p>
         */
        R16I(33331),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG16I</a></p>
         */
        RG16I(33337),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB16I</a></p>
         */
        RGB16I(36233),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA16I</a></p>
         */
        RGBA16I(36232),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R32I</a></p>
         */
        R32I(33333),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG32I</a></p>
         */
        RG32I(33339),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB32I</a></p>
         */
        RGB32I(36227),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA32I</a></p>
         */
        RGBA32I(36226),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R16F</a></p>
         */
        R16F(33325),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG16F</a></p>
         */
        RG16F(33327),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB16F</a></p>
         */
        RGB16F(34843),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA16F</a></p>
         */
        RGBA16F(34842),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R32F</a></p>
         */
        R32F(33326),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG32F</a></p>
         */
        RG32F(33328),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB32F</a></p>
         */
        RGB32F(34837),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA32F</a></p>
         */
        RGBA32F(34836),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB9E5</a></p>
         */
        RGB9E5(35901),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG11B10F</a></p>
         */
        RG11B10F(35898),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG3B2</a></p>
         */
        RG3B2(10768),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R5G6B5</a></p>
         */
        R5G6B5(36194),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB5A1</a></p>
         */
        RGB5A1(32855),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA4</a></p>
         */
        RGBA4(32854),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB10A2</a></p>
         */
        RGB10A2(36975),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::D16</a></p>
         */
        D16(33189),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::D24</a></p>
         */
        D24(33190),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::D24S8</a></p>
         */
        D24S8(35056),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::D32</a></p>
         */
        D32(33191),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::D32F</a></p>
         */
        D32F(36012),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::D32FS8X24</a></p>
         */
        D32FS8X24(36013),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::S8</a></p>
         */
        S8(36168),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB_DXT1</a></p>
         */
        RGB_DXT1(33776),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_DXT1</a></p>
         */
        RGBA_DXT1(33777),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_DXT3</a></p>
         */
        RGBA_DXT3(33778),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_DXT5</a></p>
         */
        RGBA_DXT5(33779),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R_ATI1N_UNorm</a></p>
         */
        R_ATI1N_UNorm(36283),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R_ATI1N_SNorm</a></p>
         */
        R_ATI1N_SNorm(36284),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG_ATI2N_UNorm</a></p>
         */
        RG_ATI2N_UNorm(36285),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG_ATI2N_SNorm</a></p>
         */
        RG_ATI2N_SNorm(36286),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB_BP_UNSIGNED_FLOAT</a></p>
         */
        RGB_BP_UNSIGNED_FLOAT(36495),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB_BP_SIGNED_FLOAT</a></p>
         */
        RGB_BP_SIGNED_FLOAT(36494),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB_BP_UNorm</a></p>
         */
        RGB_BP_UNorm(36492),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R11_EAC_UNorm</a></p>
         */
        R11_EAC_UNorm(37488),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::R11_EAC_SNorm</a></p>
         */
        R11_EAC_SNorm(37489),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG11_EAC_UNorm</a></p>
         */
        RG11_EAC_UNorm(37490),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RG11_EAC_SNorm</a></p>
         */
        RG11_EAC_SNorm(37491),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB8_ETC2</a></p>
         */
        RGB8_ETC2(37492),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_ETC2</a></p>
         */
        SRGB8_ETC2(37493),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB8_PunchThrough_Alpha1_ETC2</a></p>
         */
        RGB8_PunchThrough_Alpha1_ETC2(37494),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_PunchThrough_Alpha1_ETC2</a></p>
         */
        SRGB8_PunchThrough_Alpha1_ETC2(37495),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA8_ETC2_EAC</a></p>
         */
        RGBA8_ETC2_EAC(37496),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ETC2_EAC</a></p>
         */
        SRGB8_Alpha8_ETC2_EAC(37497),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGB8_ETC1</a></p>
         */
        RGB8_ETC1(36196),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_4x4</a></p>
         */
        RGBA_ASTC_4x4(37808),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_5x4</a></p>
         */
        RGBA_ASTC_5x4(37809),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_5x5</a></p>
         */
        RGBA_ASTC_5x5(37810),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_6x5</a></p>
         */
        RGBA_ASTC_6x5(37811),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_6x6</a></p>
         */
        RGBA_ASTC_6x6(37812),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_8x5</a></p>
         */
        RGBA_ASTC_8x5(37813),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_8x6</a></p>
         */
        RGBA_ASTC_8x6(37814),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_8x8</a></p>
         */
        RGBA_ASTC_8x8(37815),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_10x5</a></p>
         */
        RGBA_ASTC_10x5(37816),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_10x6</a></p>
         */
        RGBA_ASTC_10x6(37817),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_10x8</a></p>
         */
        RGBA_ASTC_10x8(37818),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_10x10</a></p>
         */
        RGBA_ASTC_10x10(37819),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_12x10</a></p>
         */
        RGBA_ASTC_12x10(37820),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBA_ASTC_12x12</a></p>
         */
        RGBA_ASTC_12x12(37821),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_4x4</a></p>
         */
        SRGB8_Alpha8_ASTC_4x4(37840),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_5x4</a></p>
         */
        SRGB8_Alpha8_ASTC_5x4(37841),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_5x5</a></p>
         */
        SRGB8_Alpha8_ASTC_5x5(37842),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_6x5</a></p>
         */
        SRGB8_Alpha8_ASTC_6x5(37843),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_6x6</a></p>
         */
        SRGB8_Alpha8_ASTC_6x6(37844),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_8x5</a></p>
         */
        SRGB8_Alpha8_ASTC_8x5(37845),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_8x6</a></p>
         */
        SRGB8_Alpha8_ASTC_8x6(37846),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_8x8</a></p>
         */
        SRGB8_Alpha8_ASTC_8x8(37847),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_10x5</a></p>
         */
        SRGB8_Alpha8_ASTC_10x5(37848),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_10x6</a></p>
         */
        SRGB8_Alpha8_ASTC_10x6(37849),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_10x8</a></p>
         */
        SRGB8_Alpha8_ASTC_10x8(37850),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_10x10</a></p>
         */
        SRGB8_Alpha8_ASTC_10x10(37851),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_12x10</a></p>
         */
        SRGB8_Alpha8_ASTC_12x10(37852),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8_ASTC_12x12</a></p>
         */
        SRGB8_Alpha8_ASTC_12x12(37853),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8</a></p>
         */
        SRGB8(35905),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB8_Alpha8</a></p>
         */
        SRGB8_Alpha8(35907),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB_DXT1</a></p>
         */
        SRGB_DXT1(35916),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB_Alpha_DXT1</a></p>
         */
        SRGB_Alpha_DXT1(35917),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB_Alpha_DXT3</a></p>
         */
        SRGB_Alpha_DXT3(35918),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB_Alpha_DXT5</a></p>
         */
        SRGB_Alpha_DXT5(35919),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::SRGB_BP_UNorm</a></p>
         */
        SRGB_BP_UNorm(36493),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::DepthFormat</a></p>
         */
        DepthFormat(6402),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::AlphaFormat</a></p>
         */
        AlphaFormat(6406),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBFormat</a></p>
         */
        RGBFormat(6407),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::RGBAFormat</a></p>
         */
        RGBAFormat(6408),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::LuminanceFormat</a></p>
         */
        LuminanceFormat(6409),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureFormat-enum">QOpenGLTexture::LuminanceAlphaFormat</a></p>
         */
        LuminanceAlphaFormat(6410);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TextureFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TextureFormat resolve(int value) {
            switch (value) {
            case 0: return NoFormat;
            case 33321: return R8_UNorm;
            case 33323: return RG8_UNorm;
            case 32849: return RGB8_UNorm;
            case 32856: return RGBA8_UNorm;
            case 33322: return R16_UNorm;
            case 33324: return RG16_UNorm;
            case 32852: return RGB16_UNorm;
            case 32859: return RGBA16_UNorm;
            case 36756: return R8_SNorm;
            case 36757: return RG8_SNorm;
            case 36758: return RGB8_SNorm;
            case 36759: return RGBA8_SNorm;
            case 36760: return R16_SNorm;
            case 36761: return RG16_SNorm;
            case 36762: return RGB16_SNorm;
            case 36763: return RGBA16_SNorm;
            case 33330: return R8U;
            case 33336: return RG8U;
            case 36221: return RGB8U;
            case 36220: return RGBA8U;
            case 33332: return R16U;
            case 33338: return RG16U;
            case 36215: return RGB16U;
            case 36214: return RGBA16U;
            case 33334: return R32U;
            case 33340: return RG32U;
            case 36209: return RGB32U;
            case 36208: return RGBA32U;
            case 33329: return R8I;
            case 33335: return RG8I;
            case 36239: return RGB8I;
            case 36238: return RGBA8I;
            case 33331: return R16I;
            case 33337: return RG16I;
            case 36233: return RGB16I;
            case 36232: return RGBA16I;
            case 33333: return R32I;
            case 33339: return RG32I;
            case 36227: return RGB32I;
            case 36226: return RGBA32I;
            case 33325: return R16F;
            case 33327: return RG16F;
            case 34843: return RGB16F;
            case 34842: return RGBA16F;
            case 33326: return R32F;
            case 33328: return RG32F;
            case 34837: return RGB32F;
            case 34836: return RGBA32F;
            case 35901: return RGB9E5;
            case 35898: return RG11B10F;
            case 10768: return RG3B2;
            case 36194: return R5G6B5;
            case 32855: return RGB5A1;
            case 32854: return RGBA4;
            case 36975: return RGB10A2;
            case 33189: return D16;
            case 33190: return D24;
            case 35056: return D24S8;
            case 33191: return D32;
            case 36012: return D32F;
            case 36013: return D32FS8X24;
            case 36168: return S8;
            case 33776: return RGB_DXT1;
            case 33777: return RGBA_DXT1;
            case 33778: return RGBA_DXT3;
            case 33779: return RGBA_DXT5;
            case 36283: return R_ATI1N_UNorm;
            case 36284: return R_ATI1N_SNorm;
            case 36285: return RG_ATI2N_UNorm;
            case 36286: return RG_ATI2N_SNorm;
            case 36495: return RGB_BP_UNSIGNED_FLOAT;
            case 36494: return RGB_BP_SIGNED_FLOAT;
            case 36492: return RGB_BP_UNorm;
            case 37488: return R11_EAC_UNorm;
            case 37489: return R11_EAC_SNorm;
            case 37490: return RG11_EAC_UNorm;
            case 37491: return RG11_EAC_SNorm;
            case 37492: return RGB8_ETC2;
            case 37493: return SRGB8_ETC2;
            case 37494: return RGB8_PunchThrough_Alpha1_ETC2;
            case 37495: return SRGB8_PunchThrough_Alpha1_ETC2;
            case 37496: return RGBA8_ETC2_EAC;
            case 37497: return SRGB8_Alpha8_ETC2_EAC;
            case 36196: return RGB8_ETC1;
            case 37808: return RGBA_ASTC_4x4;
            case 37809: return RGBA_ASTC_5x4;
            case 37810: return RGBA_ASTC_5x5;
            case 37811: return RGBA_ASTC_6x5;
            case 37812: return RGBA_ASTC_6x6;
            case 37813: return RGBA_ASTC_8x5;
            case 37814: return RGBA_ASTC_8x6;
            case 37815: return RGBA_ASTC_8x8;
            case 37816: return RGBA_ASTC_10x5;
            case 37817: return RGBA_ASTC_10x6;
            case 37818: return RGBA_ASTC_10x8;
            case 37819: return RGBA_ASTC_10x10;
            case 37820: return RGBA_ASTC_12x10;
            case 37821: return RGBA_ASTC_12x12;
            case 37840: return SRGB8_Alpha8_ASTC_4x4;
            case 37841: return SRGB8_Alpha8_ASTC_5x4;
            case 37842: return SRGB8_Alpha8_ASTC_5x5;
            case 37843: return SRGB8_Alpha8_ASTC_6x5;
            case 37844: return SRGB8_Alpha8_ASTC_6x6;
            case 37845: return SRGB8_Alpha8_ASTC_8x5;
            case 37846: return SRGB8_Alpha8_ASTC_8x6;
            case 37847: return SRGB8_Alpha8_ASTC_8x8;
            case 37848: return SRGB8_Alpha8_ASTC_10x5;
            case 37849: return SRGB8_Alpha8_ASTC_10x6;
            case 37850: return SRGB8_Alpha8_ASTC_10x8;
            case 37851: return SRGB8_Alpha8_ASTC_10x10;
            case 37852: return SRGB8_Alpha8_ASTC_12x10;
            case 37853: return SRGB8_Alpha8_ASTC_12x12;
            case 35905: return SRGB8;
            case 35907: return SRGB8_Alpha8;
            case 35916: return SRGB_DXT1;
            case 35917: return SRGB_Alpha_DXT1;
            case 35918: return SRGB_Alpha_DXT3;
            case 35919: return SRGB_Alpha_DXT5;
            case 36493: return SRGB_BP_UNorm;
            case 6402: return DepthFormat;
            case 6406: return AlphaFormat;
            case 6407: return RGBFormat;
            case 6408: return RGBAFormat;
            case 6409: return LuminanceFormat;
            case 6410: return LuminanceAlphaFormat;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QOpenGLTexture::TextureFormatClass</p>
     */
    public enum TextureFormatClass implements QtEnumerator {
        /**
         * <p>Representing QOpenGLTexture::NoFormatClass</p>
         */
        NoFormatClass(0),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_128Bit</p>
         */
        FormatClass_128Bit(1),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_96Bit</p>
         */
        FormatClass_96Bit(2),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_64Bit</p>
         */
        FormatClass_64Bit(3),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_48Bit</p>
         */
        FormatClass_48Bit(4),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_32Bit</p>
         */
        FormatClass_32Bit(5),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_24Bit</p>
         */
        FormatClass_24Bit(6),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_16Bit</p>
         */
        FormatClass_16Bit(7),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_8Bit</p>
         */
        FormatClass_8Bit(8),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_RGTC1_R</p>
         */
        FormatClass_RGTC1_R(9),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_RGTC2_RG</p>
         */
        FormatClass_RGTC2_RG(10),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_BPTC_Unorm</p>
         */
        FormatClass_BPTC_Unorm(11),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_BPTC_Float</p>
         */
        FormatClass_BPTC_Float(12),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_S3TC_DXT1_RGB</p>
         */
        FormatClass_S3TC_DXT1_RGB(13),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_S3TC_DXT1_RGBA</p>
         */
        FormatClass_S3TC_DXT1_RGBA(14),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_S3TC_DXT3_RGBA</p>
         */
        FormatClass_S3TC_DXT3_RGBA(15),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_S3TC_DXT5_RGBA</p>
         */
        FormatClass_S3TC_DXT5_RGBA(16),
        /**
         * <p>Representing QOpenGLTexture::FormatClass_Unique</p>
         */
        FormatClass_Unique(17);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TextureFormatClass(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TextureFormatClass resolve(int value) {
            switch (value) {
            case 0: return NoFormatClass;
            case 1: return FormatClass_128Bit;
            case 2: return FormatClass_96Bit;
            case 3: return FormatClass_64Bit;
            case 4: return FormatClass_48Bit;
            case 5: return FormatClass_32Bit;
            case 6: return FormatClass_24Bit;
            case 7: return FormatClass_16Bit;
            case 8: return FormatClass_8Bit;
            case 9: return FormatClass_RGTC1_R;
            case 10: return FormatClass_RGTC2_RG;
            case 11: return FormatClass_BPTC_Unorm;
            case 12: return FormatClass_BPTC_Float;
            case 13: return FormatClass_S3TC_DXT1_RGB;
            case 14: return FormatClass_S3TC_DXT1_RGBA;
            case 15: return FormatClass_S3TC_DXT3_RGBA;
            case 16: return FormatClass_S3TC_DXT5_RGBA;
            case 17: return FormatClass_Unique;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#TextureUnitReset-enum">QOpenGLTexture::TextureUnitReset</a></p>
     */
    public enum TextureUnitReset implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureUnitReset-enum">QOpenGLTexture::ResetTextureUnit</a></p>
         */
        ResetTextureUnit(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#TextureUnitReset-enum">QOpenGLTexture::DontResetTextureUnit</a></p>
         */
        DontResetTextureUnit(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TextureUnitReset(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TextureUnitReset resolve(int value) {
            switch (value) {
            case 0: return ResetTextureUnit;
            case 1: return DontResetTextureUnit;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltexture.html#WrapMode-enum">QOpenGLTexture::WrapMode</a></p>
     */
    public enum WrapMode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#WrapMode-enum">QOpenGLTexture::Repeat</a></p>
         */
        Repeat(10497),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#WrapMode-enum">QOpenGLTexture::MirroredRepeat</a></p>
         */
        MirroredRepeat(33648),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#WrapMode-enum">QOpenGLTexture::ClampToEdge</a></p>
         */
        ClampToEdge(33071),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengltexture.html#WrapMode-enum">QOpenGLTexture::ClampToBorder</a></p>
         */
        ClampToBorder(33069);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WrapMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WrapMode resolve(int value) {
            switch (value) {
            case 10497: return Repeat;
            case 33648: return MirroredRepeat;
            case 33071: return ClampToEdge;
            case 33069: return ClampToBorder;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#QOpenGLTexture">QOpenGLTexture::QOpenGLTexture(QOpenGLTexture::Target)</a></p>
     */
    public QOpenGLTexture(io.qt.opengl.QOpenGLTexture.@NonNull Target target){
        super((QPrivateConstructor)null);
        initialize_native(this, target);
    }
    
    private native static void initialize_native(QOpenGLTexture instance, io.qt.opengl.QOpenGLTexture.Target target);
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLTexture(io.qt.gui.QImage, io.qt.opengl.QOpenGLTexture.MipMapGeneration)}
     *  with <code>genMipMaps = io.qt.opengl.QOpenGLTexture.MipMapGeneration.GenerateMipMaps</code>.</p>
     */
    public QOpenGLTexture(io.qt.gui.@NonNull QImage image) {
        this(image, io.qt.opengl.QOpenGLTexture.MipMapGeneration.GenerateMipMaps);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#QOpenGLTexture-1">QOpenGLTexture::QOpenGLTexture(QImage,QOpenGLTexture::MipMapGeneration)</a></p>
     */
    public QOpenGLTexture(io.qt.gui.@NonNull QImage image, io.qt.opengl.QOpenGLTexture.@NonNull MipMapGeneration genMipMaps){
        super((QPrivateConstructor)null);
        initialize_native(this, image, genMipMaps);
    }
    
    private native static void initialize_native(QOpenGLTexture instance, io.qt.gui.QImage image, io.qt.opengl.QOpenGLTexture.MipMapGeneration genMipMaps);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#allocateStorage">QOpenGLTexture::allocateStorage()</a></p>
     */
    @QtUninvokable
    public final void allocateStorage(){
        allocateStorage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void allocateStorage_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#allocateStorage-1">QOpenGLTexture::allocateStorage(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType)</a></p>
     */
    @QtUninvokable
    public final void allocateStorage(io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat pixelFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType pixelType){
        allocateStorage_native_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType(QtJambi_LibraryUtilities.internal.nativeId(this), pixelFormat.value(), pixelType.value());
    }
    
    @QtUninvokable
    private native void allocateStorage_native_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType(long __this__nativeId, int pixelFormat, int pixelType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#bind">QOpenGLTexture::bind()</a></p>
     */
    @QtUninvokable
    public final void bind(){
        bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void bind_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #bind(int, io.qt.opengl.QOpenGLTexture.TextureUnitReset)}
     *  with <code>reset = io.qt.opengl.QOpenGLTexture.TextureUnitReset.DontResetTextureUnit</code>.</p>
     */
    @QtUninvokable
    public final void bind(int unit) {
        bind(unit, io.qt.opengl.QOpenGLTexture.TextureUnitReset.DontResetTextureUnit);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#bind-1">QOpenGLTexture::bind(uint,QOpenGLTexture::TextureUnitReset)</a></p>
     */
    @QtUninvokable
    public final void bind(int unit, io.qt.opengl.QOpenGLTexture.@NonNull TextureUnitReset reset){
        bind_native_uint_QOpenGLTexture_TextureUnitReset(QtJambi_LibraryUtilities.internal.nativeId(this), unit, reset.value());
    }
    
    @QtUninvokable
    private native void bind_native_uint_QOpenGLTexture_TextureUnitReset(long __this__nativeId, int unit, int reset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#borderColor">QOpenGLTexture::borderColor()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor borderColor(){
        return borderColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor borderColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#comparisonFunction">QOpenGLTexture::comparisonFunction()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull ComparisonFunction comparisonFunction(){
        return io.qt.opengl.QOpenGLTexture.ComparisonFunction.resolve(comparisonFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#comparisonMode">QOpenGLTexture::comparisonMode()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull ComparisonMode comparisonMode(){
        return io.qt.opengl.QOpenGLTexture.ComparisonMode.resolve(comparisonMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#create">QOpenGLTexture::create()</a></p>
     */
    @QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#createTextureView">QOpenGLTexture::createTextureView(QOpenGLTexture::Target,QOpenGLTexture::TextureFormat,int,int,int,int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.@Nullable QOpenGLTexture createTextureView(io.qt.opengl.QOpenGLTexture.@NonNull Target target, io.qt.opengl.QOpenGLTexture.@NonNull TextureFormat viewFormat, int minimumMipmapLevel, int maximumMipmapLevel, int minimumLayer, int maximumLayer){
        return createTextureView_native_QOpenGLTexture_Target_QOpenGLTexture_TextureFormat_int_int_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), target.value(), viewFormat.value(), minimumMipmapLevel, maximumMipmapLevel, minimumLayer, maximumLayer);
    }
    
    @QtUninvokable
    private native io.qt.opengl.QOpenGLTexture createTextureView_native_QOpenGLTexture_Target_QOpenGLTexture_TextureFormat_int_int_int_int_constfct(long __this__nativeId, int target, int viewFormat, int minimumMipmapLevel, int maximumMipmapLevel, int minimumLayer, int maximumLayer);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#depth">QOpenGLTexture::depth()const</a></p>
     */
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#depthStencilMode">QOpenGLTexture::depthStencilMode()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull DepthStencilMode depthStencilMode(){
        return io.qt.opengl.QOpenGLTexture.DepthStencilMode.resolve(depthStencilMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int depthStencilMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#destroy">QOpenGLTexture::destroy()</a></p>
     */
    @QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#faces">QOpenGLTexture::faces()const</a></p>
     */
    @QtUninvokable
    public final int faces(){
        return faces_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int faces_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#format">QOpenGLTexture::format()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull TextureFormat format(){
        return io.qt.opengl.QOpenGLTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#generateMipMaps">QOpenGLTexture::generateMipMaps()</a></p>
     */
    @QtUninvokable
    public final void generateMipMaps(){
        generateMipMaps_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void generateMipMaps_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #generateMipMaps(int, boolean)}
     *  with <code>resetBaseLevel = true</code>.</p>
     */
    @QtUninvokable
    public final void generateMipMaps(int baseLevel) {
        generateMipMaps(baseLevel, (boolean)true);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#generateMipMaps-1">QOpenGLTexture::generateMipMaps(int,bool)</a></p>
     */
    @QtUninvokable
    public final void generateMipMaps(int baseLevel, boolean resetBaseLevel){
        generateMipMaps_native_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), baseLevel, resetBaseLevel);
    }
    
    @QtUninvokable
    private native void generateMipMaps_native_int_bool(long __this__nativeId, int baseLevel, boolean resetBaseLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#height">QOpenGLTexture::height()const</a></p>
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#isAutoMipMapGenerationEnabled">QOpenGLTexture::isAutoMipMapGenerationEnabled()const</a></p>
     */
    @QtUninvokable
    public final boolean isAutoMipMapGenerationEnabled(){
        return isAutoMipMapGenerationEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAutoMipMapGenerationEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#isBound">QOpenGLTexture::isBound()const</a></p>
     */
    @QtUninvokable
    public final boolean isBound(){
        return isBound_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isBound_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#isBound-1">QOpenGLTexture::isBound(uint)</a></p>
     */
    @QtUninvokable
    public final boolean isBound(int unit){
        return isBound_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), unit);
    }
    
    @QtUninvokable
    private native boolean isBound_native_uint(long __this__nativeId, int unit);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#isCreated">QOpenGLTexture::isCreated()const</a></p>
     */
    @QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#isFixedSamplePositions">QOpenGLTexture::isFixedSamplePositions()const</a></p>
     */
    @QtUninvokable
    public final boolean isFixedSamplePositions(){
        return isFixedSamplePositions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFixedSamplePositions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#isStorageAllocated">QOpenGLTexture::isStorageAllocated()const</a></p>
     */
    @QtUninvokable
    public final boolean isStorageAllocated(){
        return isStorageAllocated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isStorageAllocated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#isTextureView">QOpenGLTexture::isTextureView()const</a></p>
     */
    @QtUninvokable
    public final boolean isTextureView(){
        return isTextureView_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isTextureView_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#layers">QOpenGLTexture::layers()const</a></p>
     */
    @QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#levelOfDetailRange">QOpenGLTexture::levelOfDetailRange()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Float, java.lang.@QtPrimitiveType@NonNull Float> levelOfDetailRange(){
        return levelOfDetailRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPair<java.lang.@QtPrimitiveType Float, java.lang.@QtPrimitiveType Float> levelOfDetailRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#levelofDetailBias">QOpenGLTexture::levelofDetailBias()const</a></p>
     */
    @QtUninvokable
    public final float levelofDetailBias(){
        return levelofDetailBias_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float levelofDetailBias_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#magnificationFilter">QOpenGLTexture::magnificationFilter()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull Filter magnificationFilter(){
        return io.qt.opengl.QOpenGLTexture.Filter.resolve(magnificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int magnificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#maximumAnisotropy">QOpenGLTexture::maximumAnisotropy()const</a></p>
     */
    @QtUninvokable
    public final float maximumAnisotropy(){
        return maximumAnisotropy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maximumAnisotropy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#maximumLevelOfDetail">QOpenGLTexture::maximumLevelOfDetail()const</a></p>
     */
    @QtUninvokable
    public final float maximumLevelOfDetail(){
        return maximumLevelOfDetail_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maximumLevelOfDetail_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#maximumMipLevels">QOpenGLTexture::maximumMipLevels()const</a></p>
     */
    @QtUninvokable
    public final int maximumMipLevels(){
        return maximumMipLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maximumMipLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#minMagFilters">QOpenGLTexture::minMagFilters()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<io.qt.opengl.QOpenGLTexture.@NonNull Filter, io.qt.opengl.QOpenGLTexture.@NonNull Filter> minMagFilters(){
        return minMagFilters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPair<io.qt.opengl.QOpenGLTexture.Filter, io.qt.opengl.QOpenGLTexture.Filter> minMagFilters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#minificationFilter">QOpenGLTexture::minificationFilter()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull Filter minificationFilter(){
        return io.qt.opengl.QOpenGLTexture.Filter.resolve(minificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int minificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#minimumLevelOfDetail">QOpenGLTexture::minimumLevelOfDetail()const</a></p>
     */
    @QtUninvokable
    public final float minimumLevelOfDetail(){
        return minimumLevelOfDetail_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float minimumLevelOfDetail_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#mipBaseLevel">QOpenGLTexture::mipBaseLevel()const</a></p>
     */
    @QtUninvokable
    public final int mipBaseLevel(){
        return mipBaseLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipBaseLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#mipLevelRange">QOpenGLTexture::mipLevelRange()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> mipLevelRange(){
        return mipLevelRange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPair<java.lang.@QtPrimitiveType Integer, java.lang.@QtPrimitiveType Integer> mipLevelRange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#mipLevels">QOpenGLTexture::mipLevels()const</a></p>
     */
    @QtUninvokable
    public final int mipLevels(){
        return mipLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#mipMaxLevel">QOpenGLTexture::mipMaxLevel()const</a></p>
     */
    @QtUninvokable
    public final int mipMaxLevel(){
        return mipMaxLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipMaxLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#release">QOpenGLTexture::release()</a></p>
     */
    @QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #release(int, io.qt.opengl.QOpenGLTexture.TextureUnitReset)}
     *  with <code>reset = io.qt.opengl.QOpenGLTexture.TextureUnitReset.DontResetTextureUnit</code>.</p>
     */
    @QtUninvokable
    public final void release(int unit) {
        release(unit, io.qt.opengl.QOpenGLTexture.TextureUnitReset.DontResetTextureUnit);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#release-1">QOpenGLTexture::release(uint,QOpenGLTexture::TextureUnitReset)</a></p>
     */
    @QtUninvokable
    public final void release(int unit, io.qt.opengl.QOpenGLTexture.@NonNull TextureUnitReset reset){
        release_native_uint_QOpenGLTexture_TextureUnitReset(QtJambi_LibraryUtilities.internal.nativeId(this), unit, reset.value());
    }
    
    @QtUninvokable
    private native void release_native_uint_QOpenGLTexture_TextureUnitReset(long __this__nativeId, int unit, int reset);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#samples">QOpenGLTexture::samples()const</a></p>
     */
    @QtUninvokable
    public final int samples(){
        return samples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int samples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setAutoMipMapGenerationEnabled">QOpenGLTexture::setAutoMipMapGenerationEnabled(bool)</a></p>
     */
    @QtUninvokable
    public final void setAutoMipMapGenerationEnabled(boolean enabled){
        setAutoMipMapGenerationEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setAutoMipMapGenerationEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setBorderColor">QOpenGLTexture::setBorderColor(QColor)</a></p>
     */
    @QtUninvokable
    public final void setBorderColor(io.qt.gui.@NonNull QColor color){
        setBorderColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setBorderColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setBorderColor-1">QOpenGLTexture::setBorderColor(float,float,float,float)</a></p>
     */
    @QtUninvokable
    public final void setBorderColor(float r, float g, float b, float a){
        setBorderColor_native_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), r, g, b, a);
    }
    
    @QtUninvokable
    private native void setBorderColor_native_float_float_float_float(long __this__nativeId, float r, float g, float b, float a);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setBorderColor-2">QOpenGLTexture::setBorderColor(int,int,int,int)</a></p>
     */
    @QtUninvokable
    public final void setBorderColor(int r, int g, int b, int a){
        setBorderColor_native_int_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), r, g, b, a);
    }
    
    @QtUninvokable
    private native void setBorderColor_native_int_int_int_int(long __this__nativeId, int r, int g, int b, int a);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setComparisonFunction">QOpenGLTexture::setComparisonFunction(QOpenGLTexture::ComparisonFunction)</a></p>
     */
    @QtUninvokable
    public final void setComparisonFunction(io.qt.opengl.QOpenGLTexture.@NonNull ComparisonFunction function){
        setComparisonFunction_native_QOpenGLTexture_ComparisonFunction(QtJambi_LibraryUtilities.internal.nativeId(this), function.value());
    }
    
    @QtUninvokable
    private native void setComparisonFunction_native_QOpenGLTexture_ComparisonFunction(long __this__nativeId, int function);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setComparisonMode">QOpenGLTexture::setComparisonMode(QOpenGLTexture::ComparisonMode)</a></p>
     */
    @QtUninvokable
    public final void setComparisonMode(io.qt.opengl.QOpenGLTexture.@NonNull ComparisonMode mode){
        setComparisonMode_native_QOpenGLTexture_ComparisonMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setComparisonMode_native_QOpenGLTexture_ComparisonMode(long __this__nativeId, int mode);
    
    /**
     * <p>Overloaded function for {@link #setCompressedData(int, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setCompressedData(int dataSize, java.nio.Buffer data) {
        setCompressedData(dataSize, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setCompressedData-4">QOpenGLTexture::setCompressedData(int,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setCompressedData(int dataSize, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setCompressedData_native_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), dataSize, data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setCompressedData_native_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int dataSize, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setCompressedData(int, int, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int dataSize, java.nio.Buffer data) {
        setCompressedData(mipLevel, dataSize, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setCompressedData-3">QOpenGLTexture::setCompressedData(int,int,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int dataSize, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setCompressedData_native_int_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, dataSize, data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setCompressedData_native_int_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int dataSize, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setCompressedData(int, int, io.qt.opengl.QOpenGLTexture.CubeMapFace, int, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, int dataSize, java.nio.Buffer data) {
        setCompressedData(mipLevel, layer, cubeFace, dataSize, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setCompressedData">QOpenGLTexture::setCompressedData(int,int,QOpenGLTexture::CubeMapFace,int,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, int dataSize, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setCompressedData_native_int_int_QOpenGLTexture_CubeMapFace_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, layer, cubeFace.value(), dataSize, data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setCompressedData_native_int_int_QOpenGLTexture_CubeMapFace_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int layer, int cubeFace, int dataSize, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setCompressedData(int, int, int, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int layer, int dataSize, java.nio.Buffer data) {
        setCompressedData(mipLevel, layer, dataSize, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setCompressedData-2">QOpenGLTexture::setCompressedData(int,int,int,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int layer, int dataSize, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setCompressedData_native_int_int_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, layer, dataSize, data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setCompressedData_native_int_int_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int layer, int dataSize, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setCompressedData(int, int, int, io.qt.opengl.QOpenGLTexture.CubeMapFace, int, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int layer, int layerCount, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, int dataSize, java.nio.Buffer data) {
        setCompressedData(mipLevel, layer, layerCount, cubeFace, dataSize, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setCompressedData-1">QOpenGLTexture::setCompressedData(int,int,int,QOpenGLTexture::CubeMapFace,int,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setCompressedData(int mipLevel, int layer, int layerCount, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, int dataSize, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setCompressedData_native_int_int_int_QOpenGLTexture_CubeMapFace_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, layer, layerCount, cubeFace.value(), dataSize, data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setCompressedData_native_int_int_int_QOpenGLTexture_CubeMapFace_int_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int layer, int layerCount, int cubeFace, int dataSize, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-4">QOpenGLTexture::setData(QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(io.qt.gui.QImage, io.qt.opengl.QOpenGLTexture.MipMapGeneration)}
     *  with <code>genMipMaps = io.qt.opengl.QOpenGLTexture.MipMapGeneration.GenerateMipMaps</code>.</p>
     */
    @QtUninvokable
    public final void setData(io.qt.gui.@NonNull QImage image) {
        setData(image, io.qt.opengl.QOpenGLTexture.MipMapGeneration.GenerateMipMaps);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-10">QOpenGLTexture::setData(QImage,QOpenGLTexture::MipMapGeneration)</a></p>
     */
    @QtUninvokable
    public final void setData(io.qt.gui.@NonNull QImage image, io.qt.opengl.QOpenGLTexture.@NonNull MipMapGeneration genMipMaps){
        setData_native_cref_QImage_QOpenGLTexture_MipMapGeneration(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(image), genMipMaps.value());
    }
    
    @QtUninvokable
    private native void setData_native_cref_QImage_QOpenGLTexture_MipMapGeneration(long __this__nativeId, long image, int genMipMaps);
    
    /**
     * <p>Overloaded function for {@link #setData(int, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(mipLevel, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-3">QOpenGLTexture::setData(int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, io.qt.opengl.QOpenGLTexture.CubeMapFace, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(mipLevel, layer, cubeFace, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData">QOpenGLTexture::setData(int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_QOpenGLTexture_CubeMapFace_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, layer, cubeFace.value(), sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_QOpenGLTexture_CubeMapFace_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int layer, int cubeFace, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(mipLevel, layer, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-2">QOpenGLTexture::setData(int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, layer, sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int layer, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, int, io.qt.opengl.QOpenGLTexture.CubeMapFace, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, int layer, int layerCount, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(mipLevel, layer, layerCount, cubeFace, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-1">QOpenGLTexture::setData(int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int mipLevel, int layer, int layerCount, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_int_QOpenGLTexture_CubeMapFace_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel, layer, layerCount, cubeFace.value(), sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_int_QOpenGLTexture_CubeMapFace_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int mipLevel, int layer, int layerCount, int cubeFace, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, int, int, int, int, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(xOffset, yOffset, zOffset, width, height, depth, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-5">QOpenGLTexture::setData(int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_int_int_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), xOffset, yOffset, zOffset, width, height, depth, sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_int_int_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int xOffset, int yOffset, int zOffset, int width, int height, int depth, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, int, int, int, int, int, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(xOffset, yOffset, zOffset, width, height, depth, mipLevel, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-6">QOpenGLTexture::setData(int,int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_int_int_int_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), xOffset, yOffset, zOffset, width, height, depth, mipLevel, sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_int_int_int_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, int, int, int, int, int, int, io.qt.opengl.QOpenGLTexture.CubeMapFace, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(xOffset, yOffset, zOffset, width, height, depth, mipLevel, layer, cubeFace, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-8">QOpenGLTexture::setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_int_int_int_int_int_int_QOpenGLTexture_CubeMapFace_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), xOffset, yOffset, zOffset, width, height, depth, mipLevel, layer, cubeFace.value(), sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_int_int_int_int_int_int_QOpenGLTexture_CubeMapFace_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, int cubeFace, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, int, int, int, int, int, int, io.qt.opengl.QOpenGLTexture.CubeMapFace, int, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, int layerCount, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(xOffset, yOffset, zOffset, width, height, depth, mipLevel, layer, cubeFace, layerCount, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-9">QOpenGLTexture::setData(int,int,int,int,int,int,int,int,QOpenGLTexture::CubeMapFace,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull CubeMapFace cubeFace, int layerCount, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_int_int_int_int_int_int_QOpenGLTexture_CubeMapFace_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), xOffset, yOffset, zOffset, width, height, depth, mipLevel, layer, cubeFace.value(), layerCount, sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_int_int_int_int_int_int_QOpenGLTexture_CubeMapFace_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, int cubeFace, int layerCount, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>Overloaded function for {@link #setData(int, int, int, int, int, int, int, int, io.qt.opengl.QOpenGLTexture.PixelFormat, io.qt.opengl.QOpenGLTexture.PixelType, java.nio.Buffer, io.qt.opengl.QOpenGLPixelTransferOptions)}
     *  with <code>options = null</code>.</p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data) {
        setData(xOffset, yOffset, zOffset, width, height, depth, mipLevel, layer, sourceFormat, sourceType, data, (io.qt.opengl.QOpenGLPixelTransferOptions)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setData-7">QOpenGLTexture::setData(int,int,int,int,int,int,int,int,QOpenGLTexture::PixelFormat,QOpenGLTexture::PixelType,const void*,const QOpenGLPixelTransferOptions*)</a></p>
     */
    @QtUninvokable
    public final void setData(int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat sourceFormat, io.qt.opengl.QOpenGLTexture.@NonNull PixelType sourceType, java.nio.Buffer data, io.qt.opengl.@Nullable QOpenGLPixelTransferOptions options){
        setData_native_int_int_int_int_int_int_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(QtJambi_LibraryUtilities.internal.nativeId(this), xOffset, yOffset, zOffset, width, height, depth, mipLevel, layer, sourceFormat.value(), sourceType.value(), data, QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    @QtUninvokable
    private native void setData_native_int_int_int_int_int_int_int_int_QOpenGLTexture_PixelFormat_QOpenGLTexture_PixelType_const_void_ptr_const_QOpenGLPixelTransferOptions_cptr(long __this__nativeId, int xOffset, int yOffset, int zOffset, int width, int height, int depth, int mipLevel, int layer, int sourceFormat, int sourceType, java.nio.Buffer data, long options);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setDepthStencilMode">QOpenGLTexture::setDepthStencilMode(QOpenGLTexture::DepthStencilMode)</a></p>
     */
    @QtUninvokable
    public final void setDepthStencilMode(io.qt.opengl.QOpenGLTexture.@NonNull DepthStencilMode mode){
        setDepthStencilMode_native_QOpenGLTexture_DepthStencilMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setDepthStencilMode_native_QOpenGLTexture_DepthStencilMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setFixedSamplePositions">QOpenGLTexture::setFixedSamplePositions(bool)</a></p>
     */
    @QtUninvokable
    public final void setFixedSamplePositions(boolean fixed){
        setFixedSamplePositions_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), fixed);
    }
    
    @QtUninvokable
    private native void setFixedSamplePositions_native_bool(long __this__nativeId, boolean fixed);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setFormat">QOpenGLTexture::setFormat(QOpenGLTexture::TextureFormat)</a></p>
     */
    @QtUninvokable
    public final void setFormat(io.qt.opengl.QOpenGLTexture.@NonNull TextureFormat format){
        setFormat_native_QOpenGLTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setFormat_native_QOpenGLTexture_TextureFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setLayers">QOpenGLTexture::setLayers(int)</a></p>
     */
    @QtUninvokable
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    @QtUninvokable
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setLevelOfDetailRange">QOpenGLTexture::setLevelOfDetailRange(float,float)</a></p>
     */
    @QtUninvokable
    public final void setLevelOfDetailRange(float min, float max){
        setLevelOfDetailRange_native_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), min, max);
    }
    
    @QtUninvokable
    private native void setLevelOfDetailRange_native_float_float(long __this__nativeId, float min, float max);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setLevelofDetailBias">QOpenGLTexture::setLevelofDetailBias(float)</a></p>
     */
    @QtUninvokable
    public final void setLevelofDetailBias(float bias){
        setLevelofDetailBias_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), bias);
    }
    
    @QtUninvokable
    private native void setLevelofDetailBias_native_float(long __this__nativeId, float bias);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMagnificationFilter">QOpenGLTexture::setMagnificationFilter(QOpenGLTexture::Filter)</a></p>
     */
    @QtUninvokable
    public final void setMagnificationFilter(io.qt.opengl.QOpenGLTexture.@NonNull Filter filter){
        setMagnificationFilter_native_QOpenGLTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @QtUninvokable
    private native void setMagnificationFilter_native_QOpenGLTexture_Filter(long __this__nativeId, int filter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMaximumAnisotropy">QOpenGLTexture::setMaximumAnisotropy(float)</a></p>
     */
    @QtUninvokable
    public final void setMaximumAnisotropy(float anisotropy){
        setMaximumAnisotropy_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), anisotropy);
    }
    
    @QtUninvokable
    private native void setMaximumAnisotropy_native_float(long __this__nativeId, float anisotropy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMaximumLevelOfDetail">QOpenGLTexture::setMaximumLevelOfDetail(float)</a></p>
     */
    @QtUninvokable
    public final void setMaximumLevelOfDetail(float value){
        setMaximumLevelOfDetail_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setMaximumLevelOfDetail_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMinMagFilters">QOpenGLTexture::setMinMagFilters(QOpenGLTexture::Filter,QOpenGLTexture::Filter)</a></p>
     */
    @QtUninvokable
    public final void setMinMagFilters(io.qt.opengl.QOpenGLTexture.@NonNull Filter minificationFilter, io.qt.opengl.QOpenGLTexture.@NonNull Filter magnificationFilter){
        setMinMagFilters_native_QOpenGLTexture_Filter_QOpenGLTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), minificationFilter.value(), magnificationFilter.value());
    }
    
    @QtUninvokable
    private native void setMinMagFilters_native_QOpenGLTexture_Filter_QOpenGLTexture_Filter(long __this__nativeId, int minificationFilter, int magnificationFilter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMinificationFilter">QOpenGLTexture::setMinificationFilter(QOpenGLTexture::Filter)</a></p>
     */
    @QtUninvokable
    public final void setMinificationFilter(io.qt.opengl.QOpenGLTexture.@NonNull Filter filter){
        setMinificationFilter_native_QOpenGLTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @QtUninvokable
    private native void setMinificationFilter_native_QOpenGLTexture_Filter(long __this__nativeId, int filter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMinimumLevelOfDetail">QOpenGLTexture::setMinimumLevelOfDetail(float)</a></p>
     */
    @QtUninvokable
    public final void setMinimumLevelOfDetail(float value){
        setMinimumLevelOfDetail_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void setMinimumLevelOfDetail_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMipBaseLevel">QOpenGLTexture::setMipBaseLevel(int)</a></p>
     */
    @QtUninvokable
    public final void setMipBaseLevel(int baseLevel){
        setMipBaseLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), baseLevel);
    }
    
    @QtUninvokable
    private native void setMipBaseLevel_native_int(long __this__nativeId, int baseLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMipLevelRange">QOpenGLTexture::setMipLevelRange(int,int)</a></p>
     */
    @QtUninvokable
    public final void setMipLevelRange(int baseLevel, int maxLevel){
        setMipLevelRange_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), baseLevel, maxLevel);
    }
    
    @QtUninvokable
    private native void setMipLevelRange_native_int_int(long __this__nativeId, int baseLevel, int maxLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMipLevels">QOpenGLTexture::setMipLevels(int)</a></p>
     */
    @QtUninvokable
    public final void setMipLevels(int levels){
        setMipLevels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), levels);
    }
    
    @QtUninvokable
    private native void setMipLevels_native_int(long __this__nativeId, int levels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setMipMaxLevel">QOpenGLTexture::setMipMaxLevel(int)</a></p>
     */
    @QtUninvokable
    public final void setMipMaxLevel(int maxLevel){
        setMipMaxLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), maxLevel);
    }
    
    @QtUninvokable
    private native void setMipMaxLevel_native_int(long __this__nativeId, int maxLevel);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setSamples">QOpenGLTexture::setSamples(int)</a></p>
     */
    @QtUninvokable
    public final void setSamples(int samples){
        setSamples_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), samples);
    }
    
    @QtUninvokable
    private native void setSamples_native_int(long __this__nativeId, int samples);
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}
     *  with <code>depth = 1</code>.</p>
     */
    @QtUninvokable
    public final void setSize(int width, int height) {
        setSize(width, height, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>height = 1</code></li>
     * <li><code>depth = 1</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void setSize(int width) {
        setSize(width, (int)1, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setSize">QOpenGLTexture::setSize(int,int,int)</a></p>
     */
    @QtUninvokable
    public final void setSize(int width, int height, int depth){
        setSize_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, depth);
    }
    
    @QtUninvokable
    private native void setSize_native_int_int_int(long __this__nativeId, int width, int height, int depth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setSwizzleMask">QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleComponent,QOpenGLTexture::SwizzleValue)</a></p>
     */
    @QtUninvokable
    public final void setSwizzleMask(io.qt.opengl.QOpenGLTexture.@NonNull SwizzleComponent component, io.qt.opengl.QOpenGLTexture.@NonNull SwizzleValue value){
        setSwizzleMask_native_QOpenGLTexture_SwizzleComponent_QOpenGLTexture_SwizzleValue(QtJambi_LibraryUtilities.internal.nativeId(this), component.value(), value.value());
    }
    
    @QtUninvokable
    private native void setSwizzleMask_native_QOpenGLTexture_SwizzleComponent_QOpenGLTexture_SwizzleValue(long __this__nativeId, int component, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setSwizzleMask-1">QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue,QOpenGLTexture::SwizzleValue)</a></p>
     */
    @QtUninvokable
    public final void setSwizzleMask(io.qt.opengl.QOpenGLTexture.@NonNull SwizzleValue r, io.qt.opengl.QOpenGLTexture.@NonNull SwizzleValue g, io.qt.opengl.QOpenGLTexture.@NonNull SwizzleValue b, io.qt.opengl.QOpenGLTexture.@NonNull SwizzleValue a){
        setSwizzleMask_native_QOpenGLTexture_SwizzleValue_QOpenGLTexture_SwizzleValue_QOpenGLTexture_SwizzleValue_QOpenGLTexture_SwizzleValue(QtJambi_LibraryUtilities.internal.nativeId(this), r.value(), g.value(), b.value(), a.value());
    }
    
    @QtUninvokable
    private native void setSwizzleMask_native_QOpenGLTexture_SwizzleValue_QOpenGLTexture_SwizzleValue_QOpenGLTexture_SwizzleValue_QOpenGLTexture_SwizzleValue(long __this__nativeId, int r, int g, int b, int a);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setWrapMode-1">QOpenGLTexture::setWrapMode(QOpenGLTexture::CoordinateDirection,QOpenGLTexture::WrapMode)</a></p>
     */
    @QtUninvokable
    public final void setWrapMode(io.qt.opengl.QOpenGLTexture.@NonNull CoordinateDirection direction, io.qt.opengl.QOpenGLTexture.@NonNull WrapMode mode){
        setWrapMode_native_QOpenGLTexture_CoordinateDirection_QOpenGLTexture_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), direction.value(), mode.value());
    }
    
    @QtUninvokable
    private native void setWrapMode_native_QOpenGLTexture_CoordinateDirection_QOpenGLTexture_WrapMode(long __this__nativeId, int direction, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#setWrapMode">QOpenGLTexture::setWrapMode(QOpenGLTexture::WrapMode)</a></p>
     */
    @QtUninvokable
    public final void setWrapMode(io.qt.opengl.QOpenGLTexture.@NonNull WrapMode mode){
        setWrapMode_native_QOpenGLTexture_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @QtUninvokable
    private native void setWrapMode_native_QOpenGLTexture_WrapMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#swizzleMask">QOpenGLTexture::swizzleMask(QOpenGLTexture::SwizzleComponent)const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull SwizzleValue swizzleMask(io.qt.opengl.QOpenGLTexture.@NonNull SwizzleComponent component){
        return io.qt.opengl.QOpenGLTexture.SwizzleValue.resolve(swizzleMask_native_QOpenGLTexture_SwizzleComponent_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), component.value()));
    }
    
    @QtUninvokable
    private native int swizzleMask_native_QOpenGLTexture_SwizzleComponent_constfct(long __this__nativeId, int component);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#target">QOpenGLTexture::target()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull Target target(){
        return io.qt.opengl.QOpenGLTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#textureId">QOpenGLTexture::textureId()const</a></p>
     */
    @QtUninvokable
    public final int textureId(){
        return textureId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#width">QOpenGLTexture::width()const</a></p>
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#wrapMode">QOpenGLTexture::wrapMode(QOpenGLTexture::CoordinateDirection)const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull WrapMode wrapMode(io.qt.opengl.QOpenGLTexture.@NonNull CoordinateDirection direction){
        return io.qt.opengl.QOpenGLTexture.WrapMode.resolve(wrapMode_native_QOpenGLTexture_CoordinateDirection_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), direction.value()));
    }
    
    @QtUninvokable
    private native int wrapMode_native_QOpenGLTexture_CoordinateDirection_constfct(long __this__nativeId, int direction);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#boundTextureId">QOpenGLTexture::boundTextureId(QOpenGLTexture::BindingTarget)</a></p>
     */
    public static int boundTextureId(io.qt.opengl.QOpenGLTexture.@NonNull BindingTarget target){
        return boundTextureId_native_QOpenGLTexture_BindingTarget(target.value());
    }
    
    private native static int boundTextureId_native_QOpenGLTexture_BindingTarget(int target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#boundTextureId-1">QOpenGLTexture::boundTextureId(uint,QOpenGLTexture::BindingTarget)</a></p>
     */
    public static int boundTextureId(int unit, io.qt.opengl.QOpenGLTexture.@NonNull BindingTarget target){
        return boundTextureId_native_uint_QOpenGLTexture_BindingTarget(unit, target.value());
    }
    
    private native static int boundTextureId_native_uint_QOpenGLTexture_BindingTarget(int unit, int target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltexture.html#hasFeature">QOpenGLTexture::hasFeature(QOpenGLTexture::Feature)</a></p>
     */
    public static boolean hasFeature(io.qt.opengl.QOpenGLTexture.@NonNull Feature feature){
        return hasFeature_native_QOpenGLTexture_Feature(feature.value());
    }
    
    private native static boolean hasFeature_native_QOpenGLTexture_Feature(int feature);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLTexture(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
}
