package io.qt.opengl;


/**
 * <p>Convenience subclass of QWindow to perform OpenGL painting</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglwindow.html">QOpenGLWindow</a></p>
 */
public class QOpenGLWindow extends io.qt.gui.QPaintDeviceWindow
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLWindow.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglwindow.html#UpdateBehavior-enum">QOpenGLWindow::UpdateBehavior</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum UpdateBehavior implements io.qt.QtEnumerator {
        NoPartialUpdate(0),
        PartialUpdateBlit(1),
        PartialUpdateBlend(2);

        private UpdateBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static UpdateBehavior resolve(int value) {
            switch (value) {
            case 0: return NoPartialUpdate;
            case 1: return PartialUpdateBlit;
            case 2: return PartialUpdateBlend;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#frameSwapped">QOpenGLWindow::frameSwapped()</a></p>
     */
    public final Signal0 frameSwapped = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.gui.QOpenGLContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLWindow(io.qt.gui.QOpenGLContext shareContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior) {
        this(shareContext, updateBehavior, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.gui.QOpenGLContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>updateBehavior = io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QOpenGLWindow(io.qt.gui.QOpenGLContext shareContext) {
        this(shareContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#QOpenGLWindow-1">QOpenGLWindow::QOpenGLWindow(QOpenGLContext*,QOpenGLWindow::UpdateBehavior,QWindow*)</a></p>
     */
    public QOpenGLWindow(io.qt.gui.QOpenGLContext shareContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior, io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, shareContext, updateBehavior, parent);
    }
    
    private native static void initialize_native(QOpenGLWindow instance, io.qt.gui.QOpenGLContext shareContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior, io.qt.gui.QWindow parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLWindow(io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior) {
        this(updateBehavior, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>updateBehavior = io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QOpenGLWindow() {
        this(io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#QOpenGLWindow">QOpenGLWindow::QOpenGLWindow(QOpenGLWindow::UpdateBehavior,QWindow*)</a></p>
     */
    public QOpenGLWindow(io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior, io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, updateBehavior, parent);
    }
    
    private native static void initialize_native(QOpenGLWindow instance, io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#context">QOpenGLWindow::context()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLContext context(){
        return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLContext context_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#defaultFramebufferObject">QOpenGLWindow::defaultFramebufferObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int defaultFramebufferObject(){
        return defaultFramebufferObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int defaultFramebufferObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#doneCurrent">QOpenGLWindow::doneCurrent()</a></p>
     */
    @io.qt.QtUninvokable
    public final void doneCurrent(){
        doneCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void doneCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#grabFramebuffer">QOpenGLWindow::grabFramebuffer()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage grabFramebuffer(){
        return grabFramebuffer_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage grabFramebuffer_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#isValid">QOpenGLWindow::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#makeCurrent">QOpenGLWindow::makeCurrent()</a></p>
     */
    @io.qt.QtUninvokable
    public final void makeCurrent(){
        makeCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void makeCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#shareContext">QOpenGLWindow::shareContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLContext shareContext(){
        return shareContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLContext shareContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#updateBehavior">QOpenGLWindow::updateBehavior()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior(){
        return io.qt.opengl.QOpenGLWindow.UpdateBehavior.resolve(updateBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int updateBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#initializeGL">QOpenGLWindow::initializeGL()</a></p>
     */
    @io.qt.QtUninvokable
    protected void initializeGL(){
        initializeGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void initializeGL_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#metric">QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const</a></p>
     */
    @io.qt.QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#paintEvent">QWindow::paintEvent(QPaintEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintEvent(io.qt.gui.QPaintEvent event){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#paintGL">QOpenGLWindow::paintGL()</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintGL(){
        paintGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void paintGL_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#paintOverGL">QOpenGLWindow::paintOverGL()</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintOverGL(){
        paintOverGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void paintOverGL_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#paintUnderGL">QOpenGLWindow::paintUnderGL()</a></p>
     */
    @io.qt.QtUninvokable
    protected void paintUnderGL(){
        paintUnderGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void paintUnderGL_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPaintDevice redirected(io.qt.core.QPoint arg__1){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, io.qt.core.QPoint arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#resizeEvent">QWindow::resizeEvent(QResizeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeEvent(io.qt.gui.QResizeEvent event){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#resizeGL">QOpenGLWindow::resizeGL(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeGL(int w, int h){
        resizeGL_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), w, h);
    }
    
    @io.qt.QtUninvokable
    private native void resizeGL_native_int_int(long __this__nativeId, int w, int h);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLWindow(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOpenGLWindow(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOpenGLWindow instance, QDeclarativeConstructor constructor);
    
}
