package io.qt.opengl;


/**
 * <p>Represents the version and if applicable the profile of an OpenGL context</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglversionprofile.html">QOpenGLVersionProfile</a></p>
 */
public class QOpenGLVersionProfile extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#QOpenGLVersionProfile">QOpenGLVersionProfile::QOpenGLVersionProfile()</a></p>
     */
    public QOpenGLVersionProfile(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLVersionProfile instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#QOpenGLVersionProfile-2">QOpenGLVersionProfile::QOpenGLVersionProfile(QOpenGLVersionProfile)</a></p>
     */
    public QOpenGLVersionProfile(io.qt.opengl.QOpenGLVersionProfile other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QOpenGLVersionProfile instance, io.qt.opengl.QOpenGLVersionProfile other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#QOpenGLVersionProfile-1">QOpenGLVersionProfile::QOpenGLVersionProfile(QSurfaceFormat)</a></p>
     */
    public QOpenGLVersionProfile(io.qt.gui.QSurfaceFormat format){
        super((QPrivateConstructor)null);
        initialize_native(this, format);
    }
    
    private native static void initialize_native(QOpenGLVersionProfile instance, io.qt.gui.QSurfaceFormat format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#hasProfiles">QOpenGLVersionProfile::hasProfiles()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasProfiles(){
        return hasProfiles_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasProfiles_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#isLegacyVersion">QOpenGLVersionProfile::isLegacyVersion()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isLegacyVersion(){
        return isLegacyVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLegacyVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#isValid">QOpenGLVersionProfile::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.opengl.QOpenGLVersionProfile rhs){
        return operator_equal_native_cref_QOpenGLVersionProfile(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QOpenGLVersionProfile(long __this__nativeId, long rhs);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#profile">QOpenGLVersionProfile::profile()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QSurfaceFormat.OpenGLContextProfile profile(){
        return io.qt.gui.QSurfaceFormat.OpenGLContextProfile.resolve(profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#setProfile">QOpenGLVersionProfile::setProfile(QSurfaceFormat::OpenGLContextProfile)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProfile(io.qt.gui.QSurfaceFormat.OpenGLContextProfile profile){
        setProfile_native_QSurfaceFormat_OpenGLContextProfile(QtJambi_LibraryUtilities.internal.nativeId(this), profile.value());
    }
    
    @io.qt.QtUninvokable
    private native void setProfile_native_QSurfaceFormat_OpenGLContextProfile(long __this__nativeId, int profile);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#setVersion">QOpenGLVersionProfile::setVersion(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setVersion(int majorVersion, int minorVersion){
        setVersion_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), majorVersion, minorVersion);
    }
    
    @io.qt.QtUninvokable
    private native void setVersion_native_int_int(long __this__nativeId, int majorVersion, int minorVersion);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionprofile.html#version">QOpenGLVersionProfile::version()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPair<java.lang.Integer, java.lang.Integer> version(){
        return version_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPair<java.lang.Integer, java.lang.Integer> version_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLVersionProfile(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.opengl.QOpenGLVersionProfile) {
            return operator_equal((io.qt.opengl.QOpenGLVersionProfile) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QOpenGLVersionProfile clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QOpenGLVersionProfile clone_native(long __this_nativeId);
}
