package io.qt.opengl;


/**
 * <p>Describes the pixel storage modes that affect the unpacking of pixels during texture upload</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html">QOpenGLPixelTransferOptions</a></p>
 */
public class QOpenGLPixelTransferOptions extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#QOpenGLPixelTransferOptions">QOpenGLPixelTransferOptions::QOpenGLPixelTransferOptions()</a></p>
     */
    public QOpenGLPixelTransferOptions(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLPixelTransferOptions instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#QOpenGLPixelTransferOptions">QOpenGLPixelTransferOptions::QOpenGLPixelTransferOptions(QOpenGLPixelTransferOptions)</a></p>
     */
    public QOpenGLPixelTransferOptions(io.qt.opengl.QOpenGLPixelTransferOptions arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QOpenGLPixelTransferOptions instance, io.qt.opengl.QOpenGLPixelTransferOptions arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#alignment">QOpenGLPixelTransferOptions::alignment()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int alignment(){
        return alignment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int alignment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#imageHeight">QOpenGLPixelTransferOptions::imageHeight()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int imageHeight(){
        return imageHeight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int imageHeight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#isLeastSignificantBitFirst">QOpenGLPixelTransferOptions::isLeastSignificantBitFirst()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isLeastSignificantBitFirst(){
        return isLeastSignificantBitFirst_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLeastSignificantBitFirst_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#isSwapBytesEnabled">QOpenGLPixelTransferOptions::isSwapBytesEnabled()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSwapBytesEnabled(){
        return isSwapBytesEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSwapBytesEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#rowLength">QOpenGLPixelTransferOptions::rowLength()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int rowLength(){
        return rowLength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int rowLength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setAlignment">QOpenGLPixelTransferOptions::setAlignment(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAlignment(int alignment){
        setAlignment_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), alignment);
    }
    
    @io.qt.QtUninvokable
    private native void setAlignment_native_int(long __this__nativeId, int alignment);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setImageHeight">QOpenGLPixelTransferOptions::setImageHeight(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setImageHeight(int imageHeight){
        setImageHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), imageHeight);
    }
    
    @io.qt.QtUninvokable
    private native void setImageHeight_native_int(long __this__nativeId, int imageHeight);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setLeastSignificantByteFirst">QOpenGLPixelTransferOptions::setLeastSignificantByteFirst(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLeastSignificantByteFirst(boolean lsbFirst){
        setLeastSignificantByteFirst_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), lsbFirst);
    }
    
    @io.qt.QtUninvokable
    private native void setLeastSignificantByteFirst_native_bool(long __this__nativeId, boolean lsbFirst);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setRowLength">QOpenGLPixelTransferOptions::setRowLength(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRowLength(int rowLength){
        setRowLength_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), rowLength);
    }
    
    @io.qt.QtUninvokable
    private native void setRowLength_native_int(long __this__nativeId, int rowLength);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSkipImages">QOpenGLPixelTransferOptions::setSkipImages(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSkipImages(int skipImages){
        setSkipImages_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), skipImages);
    }
    
    @io.qt.QtUninvokable
    private native void setSkipImages_native_int(long __this__nativeId, int skipImages);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSkipPixels">QOpenGLPixelTransferOptions::setSkipPixels(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSkipPixels(int skipPixels){
        setSkipPixels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), skipPixels);
    }
    
    @io.qt.QtUninvokable
    private native void setSkipPixels_native_int(long __this__nativeId, int skipPixels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSkipRows">QOpenGLPixelTransferOptions::setSkipRows(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSkipRows(int skipRows){
        setSkipRows_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), skipRows);
    }
    
    @io.qt.QtUninvokable
    private native void setSkipRows_native_int(long __this__nativeId, int skipRows);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSwapBytesEnabled">QOpenGLPixelTransferOptions::setSwapBytesEnabled(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSwapBytesEnabled(boolean swapBytes){
        setSwapBytesEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), swapBytes);
    }
    
    @io.qt.QtUninvokable
    private native void setSwapBytesEnabled_native_bool(long __this__nativeId, boolean swapBytes);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#skipImages">QOpenGLPixelTransferOptions::skipImages()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int skipImages(){
        return skipImages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int skipImages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#skipPixels">QOpenGLPixelTransferOptions::skipPixels()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int skipPixels(){
        return skipPixels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int skipPixels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#skipRows">QOpenGLPixelTransferOptions::skipRows()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int skipRows(){
        return skipRows_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int skipRows_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void swap(io.qt.opengl.QOpenGLPixelTransferOptions other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QOpenGLPixelTransferOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QOpenGLPixelTransferOptions(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLPixelTransferOptions(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QOpenGLPixelTransferOptions clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QOpenGLPixelTransferOptions clone_native(long __this_nativeId);
}
